/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

public abstract class TransportResult {
    public static TransportResult success() {
        return SuccessTransportResult.INSTANCE;
    }

    public static TransportResult error(long retryMillis, int responseCode) {
        return new ErrorTransportResult(retryMillis, responseCode);
    }

    private TransportResult() {
    }

    public abstract boolean isSuccess();

    public abstract long getRetryMillis();

    public abstract int getResponseCode();

    private static final class ErrorTransportResult
    extends TransportResult {
        private final long retryMillis;
        private final int responseCode;

        ErrorTransportResult(long retryMillis, int responseCode) {
            this.retryMillis = retryMillis;
            this.responseCode = responseCode;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public long getRetryMillis() {
            return this.retryMillis;
        }

        @Override
        public int getResponseCode() {
            return this.responseCode;
        }
    }

    private static final class SuccessTransportResult
    extends TransportResult {
        static final SuccessTransportResult INSTANCE = new SuccessTransportResult();

        private SuccessTransportResult() {
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public long getRetryMillis() {
            return -1L;
        }

        @Override
        public int getResponseCode() {
            return -1;
        }
    }
}

