/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.DirectoryProcessor;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryLevel;
import io.sentry.core.hints.Cached;
import io.sentry.core.hints.Retryable;
import io.sentry.core.hints.SubmissionResult;
import io.sentry.core.util.Objects;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SendCachedEvent
extends DirectoryProcessor {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ISerializer serializer;
    private final IHub hub;
    private final ILogger logger;

    SendCachedEvent(@NotNull ISerializer serializer, @NotNull IHub hub, @NotNull ILogger logger) {
        super(logger);
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required.");
        this.hub = Objects.requireNonNull(hub, "Hub is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void processFile(@NotNull File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isRelevantFileName(String fileName) {
        return fileName.endsWith(".sentry-event");
    }

    private void safeDelete(File file, String errorMessageSuffix) {
        try {
            file.delete();
        }
        catch (Exception e) {
            ILogger.logIfNotNull(this.logger, SentryLevel.ERROR, "Failed to delete '%s' " + errorMessageSuffix, file.getName(), e);
        }
    }

    private static final class SendCachedEventHint
    implements Cached,
    Retryable,
    SubmissionResult {
        boolean retry = false;
        private final CountDownLatch latch;
        private final long timeoutMills;
        @Nullable
        private final ILogger logger;

        SendCachedEventHint(long timeoutMills, @Nullable ILogger logger) {
            this.timeoutMills = timeoutMills;
            this.latch = new CountDownLatch(1);
            this.logger = logger;
        }

        @Override
        public boolean getRetry() {
            return this.retry;
        }

        @Override
        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        boolean waitFlush() {
            try {
                return this.latch.await(this.timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                ILogger.logIfNotNull(this.logger, SentryLevel.ERROR, "Exception while awaiting on lock.", e);
                return false;
            }
        }

        @Override
        public void setResult(boolean succeeded) {
            this.latch.countDown();
        }
    }
}

