/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.CredentialsSettingConfigurator;
import io.sentry.core.Dsn;
import io.sentry.core.SentryOptions;
import io.sentry.core.cache.IEventCache;
import io.sentry.core.transport.AsyncConnection;
import io.sentry.core.transport.HttpTransport;
import io.sentry.core.transport.IBackOffIntervalStrategy;
import io.sentry.core.transport.ITransportGate;
import java.net.MalformedURLException;
import java.net.URL;

final class AsyncConnectionFactory {
    AsyncConnectionFactory() {
    }

    public static AsyncConnection create(SentryOptions options, IEventCache eventCache) {
        try {
            Dsn parsedDsn = new Dsn(options.getDsn());
            CredentialsSettingConfigurator setCredentials = new CredentialsSettingConfigurator(parsedDsn, options.getSentryClientName());
            URL sentryUrl = parsedDsn.getSentryUri().toURL();
            HttpTransport transport = new HttpTransport(options, setCredentials, 5000, 5000, false, sentryUrl);
            ITransportGate alwaysOn = () -> true;
            IBackOffIntervalStrategy linearBackoff = attempt -> attempt * 500;
            return new AsyncConnection(transport, alwaysOn, linearBackoff, eventCache, 0, options.getCacheDirSize(), options);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to compose the connection to the Sentry server.", e);
        }
    }
}

