/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.protocol.SentryStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class SentryStackTraceFactory {
    private final List<String> inAppExcludes;
    private final List<String> inAppIncludes;

    public SentryStackTraceFactory(@Nullable List<String> inAppExcludes, @Nullable List<String> inAppIncludes) {
        this.inAppExcludes = inAppExcludes;
        this.inAppIncludes = inAppIncludes;
    }

    List<SentryStackFrame> getStackFrames(@Nullable StackTraceElement[] elements) {
        ArrayList<SentryStackFrame> sentryStackFrames = new ArrayList<SentryStackFrame>();
        if (elements != null) {
            for (StackTraceElement item : elements) {
                if (item == null) continue;
                SentryStackFrame sentryStackFrame = new SentryStackFrame();
                sentryStackFrame.setInApp(this.isInApp(item.getClassName()));
                sentryStackFrame.setModule(item.getClassName());
                sentryStackFrame.setFunction(item.getMethodName());
                sentryStackFrame.setFilename(item.getFileName());
                if (item.getLineNumber() >= 0) {
                    sentryStackFrame.setLineno(item.getLineNumber());
                }
                sentryStackFrame.setNative(item.isNativeMethod());
                sentryStackFrames.add(sentryStackFrame);
            }
        }
        Collections.reverse(sentryStackFrames);
        return sentryStackFrames;
    }

    boolean isInApp(String className) {
        if (className == null || className.isEmpty()) {
            return true;
        }
        if (this.inAppIncludes != null) {
            for (String include : this.inAppIncludes) {
                if (!className.startsWith(include)) continue;
                return true;
            }
        }
        if (this.inAppExcludes != null) {
            for (String exclude : this.inAppExcludes) {
                if (!className.startsWith(exclude)) continue;
                return false;
            }
        }
        return false;
    }
}

