/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SendCachedEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

final class SendCachedEventFireAndForgetIntegration
implements Integration {
    SendCachedEventFireAndForgetIntegration() {
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        String cachedDir = options.getCacheDirPath();
        if (cachedDir == null) {
            ILogger.logIfNotNull(options.getLogger(), SentryLevel.WARNING, "No cache dir path is defined in options.", new Object[0]);
            return;
        }
        SendCachedEvent sender = new SendCachedEvent(options.getSerializer(), hub, options.getLogger());
        File outbox = new File(cachedDir);
        try {
            ExecutorService es = Executors.newSingleThreadExecutor();
            es.submit(() -> {
                try {
                    sender.sendCachedFiles(outbox);
                }
                catch (Exception e) {
                    ILogger.logIfNotNull(options.getLogger(), SentryLevel.ERROR, "Failed trying to send cached events at %s", e, outbox);
                }
            });
            es.shutdown();
        }
        catch (Exception e) {
            ILogger.logIfNotNull(options.getLogger(), SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent", e, outbox);
        }
    }
}

