/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IEnvelopeReader;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEnvelopeItem;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.util.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class EnvelopeSender
implements IEnvelopeSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final IHub hub;
    private final IEnvelopeReader envelopeReader;
    private final ISerializer serializer;
    private final ILogger logger;

    public EnvelopeSender(IHub hub, IEnvelopeReader envelopeReader, ISerializer serializer, ILogger logger) {
        this.hub = Objects.requireNonNull(hub, "Hub is required.");
        this.envelopeReader = Objects.requireNonNull(envelopeReader, "Envelope reader is required.");
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEnvelopeFile(@NotNull String path) {
        InputStream stream = null;
        File file = null;
        try {
            file = new File(path);
            stream = new FileInputStream(file);
            SentryEnvelope envelope = this.envelopeReader.read(stream);
            if (envelope == null) {
                this.logger.log(SentryLevel.ERROR, "Stream from path %s resulted in a null envelope.", path);
            } else {
                this.processEnvelope(envelope);
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error processing envelope.", e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                this.logger.log(SentryLevel.ERROR, "Error closing envelope.", ex);
            }
            if (file != null) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    this.logger.log(SentryLevel.ERROR, "Failed to delete.", e);
                }
            }
        }
    }

    private void processEnvelope(SentryEnvelope envelope) throws IOException {
        this.logger.log(SentryLevel.DEBUG, "Envelope for event Id: %s", envelope.getHeader().getEventId());
        int items = 0;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            ++items;
            if (item.getHeader() == null) {
                this.logger.log(SentryLevel.ERROR, "Item %d has no header", items);
                continue;
            }
            if ("event".equals(item.getHeader().getType())) {
                InputStreamReader eventReader = new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8);
                Throwable throwable = null;
                try {
                    SentryEvent event = this.serializer.deserializeEvent(eventReader);
                    if (event == null) {
                        this.logger.log(SentryLevel.ERROR, "Item %d of type %s returned null by the parser.", items, item.getHeader().getType());
                        continue;
                    }
                    this.hub.captureEvent(event);
                    this.logger.log(SentryLevel.DEBUG, "Item %d is being captured.", items);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (throwable != null) {
                        try {
                            ((Reader)eventReader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)eventReader).close();
                    continue;
                }
            }
            this.logger.log(SentryLevel.WARNING, "Item %d of type: %s ignored.", items, item.getHeader().getType());
        }
    }
}

