/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEnvelopeHeader;
import io.sentry.core.SentryEnvelopeItem;
import io.sentry.core.SentryEnvelopeItemHeader;
import io.sentry.core.protocol.SentryId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvelopeReader
implements IEnvelopeReader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Gson gson = new GsonBuilder().registerTypeAdapter(SentryEnvelopeHeader.class, (Object)new SentryEnvelopeHeaderAdapter()).registerTypeAdapter(SentryEnvelopeItemHeader.class, (Object)new SentryEnvelopeItemHeaderAdapter()).create();

    @Override
    @Nullable
    public SentryEnvelope read(@NotNull InputStream stream) throws IOException {
        int currentLength;
        byte[] buffer = new byte[1024];
        int streamOffset = 0;
        int envelopeEndHeaderOffset = -1;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((currentLength = stream.read(buffer)) > 0) {
            for (int i = 0; envelopeEndHeaderOffset == -1 && i < currentLength; ++i) {
                if (buffer[i] != 10) continue;
                envelopeEndHeaderOffset = streamOffset + i;
                break;
            }
            outputStream.write(buffer, 0, currentLength);
            streamOffset += currentLength;
        }
        byte[] envelopeBytes = outputStream.toByteArray();
        if (envelopeBytes.length == 0) {
            throw new IllegalArgumentException("Empty stream.");
        }
        if (envelopeEndHeaderOffset == -1) {
            throw new IllegalArgumentException("Envelope contains no header.");
        }
        SentryEnvelopeHeader header = this.deserializeEnvelopeHeader(envelopeBytes, 0, envelopeEndHeaderOffset);
        int itemHeaderStartOffset = envelopeEndHeaderOffset + 1;
        ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
        while (true) {
            int lineBreakIndex = -1;
            for (int i = itemHeaderStartOffset; i < envelopeBytes.length; ++i) {
                if (envelopeBytes[i] != 10) continue;
                lineBreakIndex = i;
                break;
            }
            if (lineBreakIndex == -1) {
                throw new IllegalArgumentException("Invalid envelope. Item at index '" + items.size() + "'. has no header delimiter.");
            }
            SentryEnvelopeItemHeader itemHeader = this.deserializeEnvelopeItemHeader(envelopeBytes, itemHeaderStartOffset, lineBreakIndex - itemHeaderStartOffset);
            if (itemHeader.getLength() <= 0) {
                throw new IllegalArgumentException("Item header at index '" + items.size() + "' has an invalid value: '" + itemHeader.getLength() + "'.");
            }
            int payloadEndOffsetExclusive = lineBreakIndex + itemHeader.getLength() + 1;
            if (payloadEndOffsetExclusive > envelopeBytes.length) {
                throw new IllegalArgumentException("Invalid length for item at index '" + items.size() + "'. Item is '" + payloadEndOffsetExclusive + "' bytes. There are '" + envelopeBytes.length + "' in the buffer.");
            }
            byte[] envelopeItemBytes = Arrays.copyOfRange(envelopeBytes, lineBreakIndex + 1, payloadEndOffsetExclusive);
            SentryEnvelopeItem item = new SentryEnvelopeItem(itemHeader, envelopeItemBytes);
            items.add(item);
            if (payloadEndOffsetExclusive == envelopeBytes.length) break;
            if (payloadEndOffsetExclusive + 1 == envelopeBytes.length) {
                if (envelopeBytes[payloadEndOffsetExclusive] == 10) break;
                throw new IllegalArgumentException("Envelope has invalid data following an item.");
            }
            itemHeaderStartOffset = payloadEndOffsetExclusive + 1;
        }
        return new SentryEnvelope(header, items);
    }

    private SentryEnvelopeHeader deserializeEnvelopeHeader(byte[] buffer, int offset, int length) {
        String json = new String(buffer, offset, length, UTF_8);
        return (SentryEnvelopeHeader)this.gson.fromJson(json, SentryEnvelopeHeader.class);
    }

    private SentryEnvelopeItemHeader deserializeEnvelopeItemHeader(byte[] buffer, int offset, int length) {
        String json = new String(buffer, offset, length, UTF_8);
        return (SentryEnvelopeItemHeader)this.gson.fromJson(json, SentryEnvelopeItemHeader.class);
    }

    private static final class SentryEnvelopeItemHeaderAdapter
    extends TypeAdapter<SentryEnvelopeItemHeader> {
        private SentryEnvelopeItemHeaderAdapter() {
        }

        public void write(JsonWriter out, SentryEnvelopeItemHeader value) throws IOException {
        }

        public SentryEnvelopeItemHeader read(JsonReader reader) throws IOException {
            String contentType = null;
            String fileName = null;
            String type = null;
            int length = 0;
            reader.beginObject();
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "content_type": {
                        contentType = reader.nextString();
                        continue block12;
                    }
                    case "filename": {
                        fileName = reader.nextString();
                        continue block12;
                    }
                    case "type": {
                        type = reader.nextString();
                        continue block12;
                    }
                    case "length": {
                        length = reader.nextInt();
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return new SentryEnvelopeItemHeader(type, length, contentType, fileName);
        }
    }

    private static final class SentryEnvelopeHeaderAdapter
    extends TypeAdapter<SentryEnvelopeHeader> {
        private SentryEnvelopeHeaderAdapter() {
        }

        public void write(JsonWriter out, SentryEnvelopeHeader value) {
        }

        public SentryEnvelopeHeader read(JsonReader reader) throws IOException {
            SentryId sentryId = SentryId.EMPTY_ID;
            String auth = null;
            reader.beginObject();
            block8: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "event_id": {
                        sentryId = new SentryId(reader.nextString());
                        continue block8;
                    }
                    case "auth": {
                        auth = reader.nextString();
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return new SentryEnvelopeHeader(sentryId, auth);
        }
    }
}

