/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class DiagnosticLogger
implements ILogger {
    private final SentryOptions options;
    private final ILogger logger;

    public DiagnosticLogger(SentryOptions options, @Nullable ILogger logger) {
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.logger = logger;
    }

    public boolean isEnabled(SentryLevel level) {
        SentryLevel diagLevel = this.options.getDiagnosticLevel();
        if (level == null || diagLevel == null) {
            return false;
        }
        return this.options.isDebug() && level.ordinal() >= diagLevel.ordinal();
    }

    @Override
    public void log(SentryLevel level, String message, Object ... args) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message, args);
        }
    }

    @Override
    public void log(SentryLevel level, String message, Throwable throwable) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message, throwable);
        }
    }
}

