/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import java.lang.reflect.Field;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/sentry/compose/SentryComposeHelper;", "", "logger", "Lio/sentry/ILogger;", "(Lio/sentry/ILogger;)V", "sentryTagElementField", "Ljava/lang/reflect/Field;", "testTagElementField", "extractTag", "", "modifier", "Landroidx/compose/ui/Modifier;", "Companion", "sentry-compose_release"})
@StabilityInferred(parameters=0)
public final class SentryComposeHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Field testTagElementField;
    @Nullable
    private final Field sentryTagElementField;
    public static final int $stable = 8;

    public SentryComposeHelper(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.testTagElementField = SentryComposeHelper.Companion.loadField(logger, "androidx.compose.ui.platform.TestTagElement", "tag");
        this.sentryTagElementField = SentryComposeHelper.Companion.loadField(logger, "io.sentry.compose.SentryModifier$SentryTagModifierNodeElement", "tag");
    }

    @Nullable
    public final String extractTag(@NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        String type = modifier.getClass().getName();
        try {
            if (Intrinsics.areEqual((Object)"androidx.compose.ui.platform.TestTagElement", (Object)type) && this.testTagElementField != null) {
                Object value = this.testTagElementField.get(modifier);
                return (String)value;
            }
            if (Intrinsics.areEqual((Object)"io.sentry.compose.SentryModifier$SentryTagModifierNodeElement", (Object)type) && this.sentryTagElementField != null) {
                Object value = this.sentryTagElementField.get(modifier);
                return (String)value;
            }
        }
        catch (Throwable value) {
            // empty catch block
        }
        if (modifier instanceof SemanticsModifier) {
            SemanticsConfiguration semanticsConfiguration = ((SemanticsModifier)modifier).getSemanticsConfiguration();
            for (Map.Entry entry : semanticsConfiguration) {
                SemanticsPropertyKey item = (SemanticsPropertyKey)entry.getKey();
                Object value = entry.getValue();
                String key = item.getName();
                if (!Intrinsics.areEqual((Object)"SentryTag", (Object)key) && !Intrinsics.areEqual((Object)"TestTag", (Object)key) || !(value instanceof String)) continue;
                return (String)value;
            }
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lio/sentry/compose/SentryComposeHelper$Companion;", "", "()V", "loadField", "Ljava/lang/reflect/Field;", "logger", "Lio/sentry/ILogger;", "className", "", "fieldName", "sentry-compose_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Field loadField(ILogger logger, String className, String fieldName) {
            try {
                Class<?> clazz = Class.forName(className);
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception e) {
                logger.log(SentryLevel.WARNING, "Could not load " + className + '.' + fieldName + " field", new Object[0]);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

