/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.apollo;

import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanContext;
import io.sentry.SpanStatus;
import io.sentry.apollo.SentryApolloInterceptor;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Platform;
import io.sentry.util.TracingUtils;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J'\u0010\u001d\u001a\u00020\u0010*\u0004\u0018\u00010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00100 H\u0002\u00a2\u0006\u0002\u0010!R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/sentry/apollo/SentryApolloInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor;", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "beforeSpan", "Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;", "(Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;)V", "(Lio/sentry/IHub;Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;)V", "addTracingHeaders", "Lcom/apollographql/apollo/request/RequestHeaders;", "request", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorRequest;", "span", "Lio/sentry/ISpan;", "dispose", "", "finish", "response", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorResponse;", "interceptAsync", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$CallBack;", "startChild", "activeSpan", "ifHasValidLength", "", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "BeforeSpanCallback", "sentry-apollo"})
public final class SentryApolloInterceptor
implements ApolloInterceptor {
    private final IHub hub;
    private final BeforeSpanCallback beforeSpan;

    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        ISpan activeSpan;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        ISpan iSpan = activeSpan = Platform.isAndroid() ? (ISpan)this.hub.getTransaction() : this.hub.getSpan();
        if (activeSpan == null) {
            RequestHeaders headers = this.addTracingHeaders(request, null);
            ApolloInterceptor.InterceptorRequest modifiedRequest = request.toBuilder().requestHeaders(headers).build();
            chain.proceedAsync(modifiedRequest, dispatcher, callBack);
        } else {
            ISpan span = this.startChild(request, activeSpan);
            SpanContext spanContext = span.getSpanContext();
            Intrinsics.checkNotNullExpressionValue((Object)spanContext, (String)"span.spanContext");
            spanContext.setOrigin("auto.graphql.apollo");
            RequestHeaders headers = this.addTracingHeaders(request, span);
            ApolloInterceptor.InterceptorRequest requestWithHeader = request.toBuilder().requestHeaders(headers).build();
            span.setData("operationId", (Object)requestWithHeader.operation.operationId());
            span.setData("variables", (Object)requestWithHeader.operation.variables().valueMap().toString());
            chain.proceedAsync(requestWithHeader, dispatcher, new ApolloInterceptor.CallBack(this, span, requestWithHeader, callBack){
                final /* synthetic */ SentryApolloInterceptor this$0;
                final /* synthetic */ ISpan $span;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $requestWithHeader;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Integer statusCode2 = (Integer)response.httpResponse.map((Function)interceptAsync.onResponse.statusCode.1.INSTANCE).orNull();
                    if (statusCode2 != null) {
                        this.$span.setStatus(SpanStatus.fromHttpStatusCode((Integer)statusCode2, (SpanStatus)SpanStatus.UNKNOWN));
                        this.$span.setData("http.response.status_code", (Object)statusCode2);
                    } else {
                        this.$span.setStatus(SpanStatus.UNKNOWN);
                    }
                    String string = (String)response.httpResponse.map((Function)interceptAsync.onResponse.1.INSTANCE).orNull();
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        boolean bl = false;
                        String string3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                        String string4 = string3;
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                        Locale locale2 = locale;
                        String string5 = string4;
                        boolean bl2 = false;
                        String string6 = string5;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.toUpperCase(locale2);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase(locale)");
                        this.$span.setData("http.request.method", (Object)string7);
                    }
                    ApolloInterceptor.InterceptorRequest interceptorRequest = this.$requestWithHeader;
                    Intrinsics.checkNotNullExpressionValue((Object)interceptorRequest, (String)"requestWithHeader");
                    SentryApolloInterceptor.access$finish(this.this$0, this.$span, interceptorRequest, response);
                    this.$callBack.onResponse(response);
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }

                public void onFailure(@NotNull ApolloException e) {
                    SpanStatus spanStatus;
                    ISpan iSpan;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ISpan $this$apply = iSpan = this.$span;
                    boolean bl = false;
                    if (e instanceof ApolloHttpException) {
                        $this$apply.setData("http.response.status_code", (Object)((ApolloHttpException)e).code());
                        spanStatus = SpanStatus.fromHttpStatusCode((Integer)((ApolloHttpException)e).code(), (SpanStatus)SpanStatus.INTERNAL_ERROR);
                    } else {
                        spanStatus = SpanStatus.INTERNAL_ERROR;
                    }
                    $this$apply.setStatus(spanStatus);
                    $this$apply.setThrowable((Throwable)e);
                    ApolloInterceptor.InterceptorRequest interceptorRequest = this.$requestWithHeader;
                    Intrinsics.checkNotNullExpressionValue((Object)interceptorRequest, (String)"requestWithHeader");
                    SentryApolloInterceptor.finish$default(this.this$0, this.$span, interceptorRequest, null, 4, null);
                    this.$callBack.onFailure(e);
                }

                public void onCompleted() {
                    this.$callBack.onCompleted();
                }
                {
                    this.this$0 = this$0;
                    this.$span = $captured_local_variable$1;
                    this.$requestWithHeader = $captured_local_variable$2;
                    this.$callBack = $captured_local_variable$3;
                }
            });
        }
    }

    public void dispose() {
    }

    private final RequestHeaders addTracingHeaders(ApolloInterceptor.InterceptorRequest request, ISpan span) {
        RequestHeaders.Builder requestHeaderBuilder = request.requestHeaders.toBuilder();
        SentryOptions sentryOptions = this.hub.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
        if (sentryOptions.isTraceSampling()) {
            TracingUtils.TracingHeaders tracingHeaders = TracingUtils.trace((IHub)this.hub, (List)CollectionsKt.listOf((Object)request.requestHeaders.headerValue("baggage")), (ISpan)span);
            if (tracingHeaders != null) {
                TracingUtils.TracingHeaders tracingHeaders2;
                TracingUtils.TracingHeaders tracingHeaders3 = tracingHeaders2 = tracingHeaders;
                boolean bl = false;
                TracingUtils.TracingHeaders tracingHeaders4 = tracingHeaders3;
                Intrinsics.checkNotNullExpressionValue((Object)tracingHeaders4, (String)"tracingHeaders");
                SentryTraceHeader sentryTraceHeader = tracingHeaders4.getSentryTraceHeader();
                Intrinsics.checkNotNullExpressionValue((Object)sentryTraceHeader, (String)"tracingHeaders.sentryTraceHeader");
                String string = sentryTraceHeader.getName();
                SentryTraceHeader sentryTraceHeader2 = tracingHeaders3.getSentryTraceHeader();
                Intrinsics.checkNotNullExpressionValue((Object)sentryTraceHeader2, (String)"tracingHeaders.sentryTraceHeader");
                requestHeaderBuilder.addHeader(string, sentryTraceHeader2.getValue());
                BaggageHeader baggageHeader = tracingHeaders3.getBaggageHeader();
                if (baggageHeader != null) {
                    BaggageHeader baggageHeader2;
                    BaggageHeader it = baggageHeader2 = baggageHeader;
                    boolean bl2 = false;
                    BaggageHeader baggageHeader3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)baggageHeader3, (String)"it");
                    requestHeaderBuilder.addHeader(baggageHeader3.getName(), it.getValue());
                }
            }
        }
        RequestHeaders requestHeaders = requestHeaderBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)requestHeaders, (String)"requestHeaderBuilder.build()");
        return requestHeaders;
    }

    private final ISpan startChild(ApolloInterceptor.InterceptorRequest request, ISpan activeSpan) {
        String operation = request.operation.name().name();
        Operation operation2 = request.operation;
        String operationType = operation2 instanceof Query ? "query" : (operation2 instanceof Mutation ? "mutation" : (operation2 instanceof Subscription ? "subscription" : request.operation.getClass().getSimpleName()));
        String op = "http.graphql." + operationType;
        String description = operationType + ' ' + operation;
        ISpan iSpan = activeSpan.startChild(op, description);
        Intrinsics.checkNotNullExpressionValue((Object)iSpan, (String)"activeSpan.startChild(op, description)");
        return iSpan;
    }

    private final void finish(ISpan span, ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        block6: {
            ApolloInterceptor.InterceptorResponse interceptorResponse;
            ISpan newSpan = span;
            if (this.beforeSpan != null) {
                try {
                    newSpan = this.beforeSpan.execute(span, request, response);
                }
                catch (Exception e) {
                    SentryOptions sentryOptions = this.hub.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
                    sentryOptions.getLogger().log(SentryLevel.ERROR, "An error occurred while executing beforeSpan on ApolloInterceptor", (Throwable)e);
                }
            }
            if (newSpan == null) {
                SpanContext spanContext = span.getSpanContext();
                Intrinsics.checkNotNullExpressionValue((Object)spanContext, (String)"span.spanContext");
                spanContext.setSampled(Boolean.valueOf(false));
            } else {
                span.finish();
            }
            ApolloInterceptor.InterceptorResponse interceptorResponse2 = response;
            if (interceptorResponse2 == null) break block6;
            ApolloInterceptor.InterceptorResponse it = interceptorResponse = interceptorResponse2;
            boolean bl = false;
            Optional optional = it.httpResponse;
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"it.httpResponse");
            if (optional.isPresent()) {
                Hint hint;
                Response httpResponse = (Response)it.httpResponse.get();
                Request httpRequest = httpResponse.request();
                Breadcrumb breadcrumb = Breadcrumb.http((String)httpRequest.url().toString(), (String)httpRequest.method(), (Integer)httpResponse.code());
                Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"Breadcrumb.http(httpRequ\u2026d(), httpResponse.code())");
                Breadcrumb breadcrumb2 = breadcrumb;
                RequestBody requestBody = httpRequest.body();
                this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long contentLength) {
                        this.$breadcrumb.setData("request_body_size", (Object)contentLength);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                ResponseBody responseBody = httpResponse.body();
                this.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long contentLength) {
                        this.$breadcrumb.setData("response_body_size", (Object)contentLength);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                Hint $this$apply = hint = new Hint();
                boolean bl2 = false;
                $this$apply.set("apollo:request", (Object)httpRequest);
                $this$apply.set("apollo:response", (Object)httpResponse);
                Hint hint2 = hint;
                this.hub.addBreadcrumb(breadcrumb2, hint2);
            }
        }
    }

    static /* synthetic */ void finish$default(SentryApolloInterceptor sentryApolloInterceptor, ISpan iSpan, ApolloInterceptor.InterceptorRequest interceptorRequest, ApolloInterceptor.InterceptorResponse interceptorResponse, int n, Object object) {
        if ((n & 4) != 0) {
            interceptorResponse = null;
        }
        sentryApolloInterceptor.finish(iSpan, interceptorRequest, interceptorResponse);
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null && $this$ifHasValidLength != -1L) {
            fn.invoke((Object)$this$ifHasValidLength);
        }
    }

    public SentryApolloInterceptor(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.beforeSpan = beforeSpan;
        IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-apollo", "7.7.0");
    }

    public /* synthetic */ SentryApolloInterceptor(IHub iHub, BeforeSpanCallback beforeSpanCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        this(iHub, beforeSpanCallback);
    }

    public SentryApolloInterceptor() {
        this(null, null, 3, null);
    }

    public SentryApolloInterceptor(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, null);
    }

    public SentryApolloInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
        this((IHub)hubAdapter, beforeSpan);
    }

    public static final /* synthetic */ void access$finish(SentryApolloInterceptor $this, ISpan span, ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        $this.finish(span, request, response);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorRequest;", "response", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorResponse;", "sentry-apollo"})
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull ApolloInterceptor.InterceptorRequest var2, @Nullable ApolloInterceptor.InterceptorResponse var3);
    }
}

