/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.apollo;

import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.IntegrationName;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.apollo.SentryApolloInterceptor;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J'\u0010\u001c\u001a\u00020\u000b*\u0004\u0018\u00010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0\u001fH\u0002\u00a2\u0006\u0002\u0010 R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/sentry/apollo/SentryApolloInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor;", "Lio/sentry/IntegrationName;", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "beforeSpan", "Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;", "(Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;)V", "(Lio/sentry/IHub;Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;)V", "dispose", "", "finish", "span", "Lio/sentry/ISpan;", "request", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorRequest;", "response", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorResponse;", "interceptAsync", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$CallBack;", "startChild", "activeSpan", "ifHasValidLength", "", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "BeforeSpanCallback", "sentry-apollo"})
public final class SentryApolloInterceptor
implements ApolloInterceptor,
IntegrationName {
    private final IHub hub;
    private final BeforeSpanCallback beforeSpan;

    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            chain.proceedAsync(request, dispatcher, callBack);
        } else {
            ApolloInterceptor.InterceptorRequest interceptorRequest;
            ISpan span = this.startChild(request, activeSpan);
            if (span.isNoOp()) {
                interceptorRequest = request;
            } else {
                SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
                Intrinsics.checkNotNullExpressionValue((Object)sentryTraceHeader, (String)"span.toSentryTrace()");
                SentryTraceHeader sentryTraceHeader2 = sentryTraceHeader;
                RequestHeaders.Builder requestHeaderBuilder = request.requestHeaders.toBuilder();
                requestHeaderBuilder.addHeader(sentryTraceHeader2.getName(), sentryTraceHeader2.getValue());
                BaggageHeader baggageHeader = span.toBaggageHeader(CollectionsKt.listOf((Object)request.requestHeaders.headerValue("baggage")));
                if (baggageHeader != null) {
                    BaggageHeader baggageHeader2;
                    BaggageHeader it = baggageHeader2 = baggageHeader;
                    boolean bl = false;
                    BaggageHeader baggageHeader3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)baggageHeader3, (String)"it");
                    requestHeaderBuilder.addHeader(baggageHeader3.getName(), it.getValue());
                }
                RequestHeaders headers = requestHeaderBuilder.build();
                interceptorRequest = request.toBuilder().requestHeaders(headers).build();
            }
            ApolloInterceptor.InterceptorRequest requestWithHeader = interceptorRequest;
            span.setData("operationId", (Object)requestWithHeader.operation.operationId());
            span.setData("variables", (Object)requestWithHeader.operation.variables().valueMap().toString());
            chain.proceedAsync(requestWithHeader, dispatcher, new ApolloInterceptor.CallBack(this, span, requestWithHeader, callBack){
                final /* synthetic */ SentryApolloInterceptor this$0;
                final /* synthetic */ ISpan $span;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $requestWithHeader;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$span.setStatus((SpanStatus)response.httpResponse.map((Function)interceptAsync.onResponse.1.INSTANCE).or((Object)SpanStatus.UNKNOWN));
                    ApolloInterceptor.InterceptorRequest interceptorRequest = this.$requestWithHeader;
                    Intrinsics.checkNotNullExpressionValue((Object)interceptorRequest, (String)"requestWithHeader");
                    SentryApolloInterceptor.access$finish(this.this$0, this.$span, interceptorRequest, response);
                    this.$callBack.onResponse(response);
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }

                public void onFailure(@NotNull ApolloException e) {
                    ISpan iSpan;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ISpan $this$apply = iSpan = this.$span;
                    boolean bl = false;
                    $this$apply.setStatus(e instanceof ApolloHttpException ? SpanStatus.fromHttpStatusCode((Integer)((ApolloHttpException)e).code(), (SpanStatus)SpanStatus.INTERNAL_ERROR) : SpanStatus.INTERNAL_ERROR);
                    $this$apply.setThrowable((Throwable)e);
                    ApolloInterceptor.InterceptorRequest interceptorRequest = this.$requestWithHeader;
                    Intrinsics.checkNotNullExpressionValue((Object)interceptorRequest, (String)"requestWithHeader");
                    SentryApolloInterceptor.finish$default(this.this$0, this.$span, interceptorRequest, null, 4, null);
                    this.$callBack.onFailure(e);
                }

                public void onCompleted() {
                    this.$callBack.onCompleted();
                }
                {
                    this.this$0 = this$0;
                    this.$span = $captured_local_variable$1;
                    this.$requestWithHeader = $captured_local_variable$2;
                    this.$callBack = $captured_local_variable$3;
                }
            });
        }
    }

    public void dispose() {
    }

    private final ISpan startChild(ApolloInterceptor.InterceptorRequest request, ISpan activeSpan) {
        String operation = request.operation.name().name();
        Operation operation2 = request.operation;
        String operationType = operation2 instanceof Query ? "query" : (operation2 instanceof Mutation ? "mutation" : (operation2 instanceof Subscription ? "subscription" : request.operation.getClass().getSimpleName()));
        String op = "http.graphql." + operationType;
        String description = operationType + ' ' + operation;
        ISpan iSpan = activeSpan.startChild(op, description);
        Intrinsics.checkNotNullExpressionValue((Object)iSpan, (String)"activeSpan.startChild(op, description)");
        return iSpan;
    }

    private final void finish(ISpan span, ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        block4: {
            ApolloInterceptor.InterceptorResponse interceptorResponse;
            ISpan newSpan = span;
            if (this.beforeSpan != null) {
                try {
                    newSpan = this.beforeSpan.execute(span, request, response);
                }
                catch (Exception e) {
                    SentryOptions sentryOptions = this.hub.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
                    sentryOptions.getLogger().log(SentryLevel.ERROR, "An error occurred while executing beforeSpan on ApolloInterceptor", (Throwable)e);
                }
            }
            newSpan.finish();
            ApolloInterceptor.InterceptorResponse interceptorResponse2 = response;
            if (interceptorResponse2 == null) break block4;
            ApolloInterceptor.InterceptorResponse it = interceptorResponse = interceptorResponse2;
            boolean bl = false;
            Optional optional = it.httpResponse;
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"it.httpResponse");
            if (optional.isPresent()) {
                Hint hint;
                Response httpResponse = (Response)it.httpResponse.get();
                Request httpRequest = httpResponse.request();
                Breadcrumb breadcrumb = Breadcrumb.http((String)httpRequest.url().toString(), (String)httpRequest.method(), (Integer)httpResponse.code());
                Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"Breadcrumb.http(httpRequ\u2026d(), httpResponse.code())");
                Breadcrumb breadcrumb2 = breadcrumb;
                RequestBody requestBody = httpRequest.body();
                this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long contentLength) {
                        this.$breadcrumb.setData("request_body_size", (Object)contentLength);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                ResponseBody responseBody = httpResponse.body();
                this.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long contentLength) {
                        this.$breadcrumb.setData("response_body_size", (Object)contentLength);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                Hint it2 = hint = new Hint();
                boolean bl2 = false;
                it2.set("apollo:request", (Object)httpRequest);
                it2.set("apollo:response", (Object)httpResponse);
                Hint hint2 = hint;
                this.hub.addBreadcrumb(breadcrumb2, hint2);
            }
        }
    }

    static /* synthetic */ void finish$default(SentryApolloInterceptor sentryApolloInterceptor, ISpan iSpan, ApolloInterceptor.InterceptorRequest interceptorRequest, ApolloInterceptor.InterceptorResponse interceptorResponse, int n, Object object) {
        if ((n & 4) != 0) {
            interceptorResponse = null;
        }
        sentryApolloInterceptor.finish(iSpan, interceptorRequest, interceptorResponse);
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null && $this$ifHasValidLength != -1L) {
            fn.invoke((Object)$this$ifHasValidLength);
        }
    }

    public SentryApolloInterceptor(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.beforeSpan = beforeSpan;
        this.addIntegrationToSdkVersion();
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-apollo", "6.20.0");
    }

    public /* synthetic */ SentryApolloInterceptor(IHub iHub, BeforeSpanCallback beforeSpanCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        this(iHub, beforeSpanCallback);
    }

    public SentryApolloInterceptor() {
        this(null, null, 3, null);
    }

    public SentryApolloInterceptor(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, null);
    }

    public SentryApolloInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
        this((IHub)hubAdapter, beforeSpan);
    }

    public static final /* synthetic */ void access$finish(SentryApolloInterceptor $this, ISpan span, ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        $this.finish(span, request, response);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/apollo/SentryApolloInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorRequest;", "response", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorResponse;", "sentry-apollo"})
    public static interface BeforeSpanCallback {
        @NotNull
        public ISpan execute(@NotNull ISpan var1, @NotNull ApolloInterceptor.InterceptorRequest var2, @Nullable ApolloInterceptor.InterceptorResponse var3);
    }
}

