/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.timber;

import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.protocol.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J,\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/timber/SentryTimberTree;", "Ltimber/log/Timber$Tree;", "hub", "Lio/sentry/core/IHub;", "minEventLevel", "Lio/sentry/core/SentryLevel;", "minBreadcrumbLevel", "(Lio/sentry/core/IHub;Lio/sentry/core/SentryLevel;Lio/sentry/core/SentryLevel;)V", "addBreadcrumb", "", "sentryLevel", "msg", "", "captureEvent", "tag", "throwable", "", "getSentryLevel", "priority", "", "isLoggable", "", "level", "minLevel", "log", "message", "sentry-android-timber_release"})
public final class SentryTimberTree
extends Timber.Tree {
    private final IHub hub;
    private final SentryLevel minEventLevel;
    private final SentryLevel minBreadcrumbLevel;

    private final boolean isLoggable(SentryLevel level, SentryLevel minLevel) {
        return level.ordinal() >= minLevel.ordinal();
    }

    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        SentryLevel level = this.getSentryLevel(priority);
        this.captureEvent(level, tag, message, throwable);
        this.addBreadcrumb(level, message);
    }

    private final void captureEvent(SentryLevel sentryLevel, String tag, String msg, Throwable throwable) {
        if (this.isLoggable(sentryLevel, this.minEventLevel)) {
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            SentryEvent sentryEvent = new SentryEvent();
            boolean bl3 = false;
            boolean bl4 = false;
            SentryEvent $this$apply = sentryEvent;
            boolean bl5 = false;
            $this$apply.setLevel(sentryLevel);
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                object = throwable2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl6 = false;
                $this$apply.setThrowable((Throwable)it);
            }
            object = new Message();
            SentryEvent sentryEvent2 = $this$apply;
            bl2 = false;
            bl = false;
            Throwable $this$apply2 = object;
            boolean bl7 = false;
            $this$apply2.setFormatted(msg);
            Throwable throwable3 = object;
            sentryEvent2.setMessage((Message)throwable3);
            String string = tag;
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl8 = false;
                $this$apply.setTag("TimberTag", (String)it);
            }
            $this$apply.setLogger("Timber");
            SentryEvent sentryEvent3 = sentryEvent;
            this.hub.captureEvent(sentryEvent3);
        }
    }

    private final void addBreadcrumb(SentryLevel sentryLevel, String msg) {
        if (this.isLoggable(sentryLevel, this.minBreadcrumbLevel)) {
            Breadcrumb breadcrumb = new Breadcrumb();
            boolean bl = false;
            boolean bl2 = false;
            Breadcrumb $this$apply = breadcrumb;
            boolean bl3 = false;
            $this$apply.setLevel(sentryLevel);
            $this$apply.setCategory("Timber");
            $this$apply.setMessage(msg);
            Breadcrumb breadCrumb = breadcrumb;
            this.hub.addBreadcrumb(breadCrumb);
        }
    }

    private final SentryLevel getSentryLevel(int priority) {
        SentryLevel sentryLevel;
        switch (priority) {
            case 7: {
                sentryLevel = SentryLevel.FATAL;
                break;
            }
            case 6: {
                sentryLevel = SentryLevel.ERROR;
                break;
            }
            case 5: {
                sentryLevel = SentryLevel.WARNING;
                break;
            }
            case 4: {
                sentryLevel = SentryLevel.INFO;
                break;
            }
            case 3: {
                sentryLevel = SentryLevel.DEBUG;
                break;
            }
            case 2: {
                sentryLevel = SentryLevel.DEBUG;
                break;
            }
            default: {
                sentryLevel = SentryLevel.DEBUG;
            }
        }
        return sentryLevel;
    }

    public SentryTimberTree(@NotNull IHub hub, @NotNull SentryLevel minEventLevel, @NotNull SentryLevel minBreadcrumbLevel) {
        Intrinsics.checkParameterIsNotNull((Object)hub, (String)"hub");
        Intrinsics.checkParameterIsNotNull((Object)minEventLevel, (String)"minEventLevel");
        Intrinsics.checkParameterIsNotNull((Object)minBreadcrumbLevel, (String)"minBreadcrumbLevel");
        this.hub = hub;
        this.minEventLevel = minEventLevel;
        this.minBreadcrumbLevel = minBreadcrumbLevel;
    }
}

