/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.sqlite;

import android.database.CrossProcessCursor;
import android.database.SQLException;
import io.sentry.IScopes;
import io.sentry.ISpan;
import io.sentry.Instrumenter;
import io.sentry.ScopesAdapter;
import io.sentry.SentryDate;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SpanStatus;
import io.sentry.android.sqlite.SentryCrossProcessCursor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r\u00a2\u0006\u0002\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/sqlite/SQLiteSpanManager;", "", "scopes", "Lio/sentry/IScopes;", "databaseName", "", "(Lio/sentry/IScopes;Ljava/lang/String;)V", "stackTraceFactory", "Lio/sentry/SentryStackTraceFactory;", "performSql", "T", "sql", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "sentry-android-sqlite_release"})
public final class SQLiteSpanManager {
    @NotNull
    private final IScopes scopes;
    @Nullable
    private final String databaseName;
    @NotNull
    private final SentryStackTraceFactory stackTraceFactory;

    public SQLiteSpanManager(@NotNull IScopes scopes, @Nullable String databaseName) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        this.scopes = scopes;
        this.databaseName = databaseName;
        this.stackTraceFactory = new SentryStackTraceFactory(this.scopes.getOptions());
        SentryIntegrationPackageStorage.getInstance().addIntegration("SQLite");
    }

    public /* synthetic */ SQLiteSpanManager(IScopes iScopes, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ScopesAdapter scopesAdapter = ScopesAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)scopesAdapter, (String)"getInstance()");
            iScopes = (IScopes)scopesAdapter;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(iScopes, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T performSql(@NotNull String sql, @NotNull Function0<? extends T> operation) throws SQLException {
        Object object;
        Object result;
        ISpan span;
        SentryDate startTimestamp;
        block15: {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            startTimestamp = this.scopes.getOptions().getDateProvider().now();
            span = null;
            result = operation.invoke();
            if (!(result instanceof CrossProcessCursor)) break block15;
            Object object2 = new SentryCrossProcessCursor((CrossProcessCursor)result, this, sql);
            return (T)object2;
        }
        try {
            ISpan iSpan = this.scopes.getSpan();
            ISpan iSpan2 = span = iSpan != null ? iSpan.startChild("db.sql.query", sql, startTimestamp, Instrumenter.SENTRY) : null;
            Object object3 = iSpan2 != null ? iSpan2.getSpanContext() : null;
            if (object3 != null) {
                object3.setOrigin("auto.db.sqlite");
            }
            ISpan iSpan3 = span;
            if (iSpan3 != null) {
                iSpan3.setStatus(SpanStatus.OK);
            }
            object = result;
        }
        catch (Throwable e) {
            ISpan iSpan = this.scopes.getSpan();
            ISpan iSpan4 = span = iSpan != null ? iSpan.startChild("db.sql.query", sql, startTimestamp, Instrumenter.SENTRY) : null;
            Object object4 = iSpan4 != null ? iSpan4.getSpanContext() : null;
            if (object4 != null) {
                object4.setOrigin("auto.db.sqlite");
            }
            ISpan iSpan5 = span;
            if (iSpan5 != null) {
                iSpan5.setStatus(SpanStatus.INTERNAL_ERROR);
            }
            ISpan iSpan6 = span;
            if (iSpan6 != null) {
                iSpan6.setThrowable(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ISpan iSpan = span;
            if (iSpan != null) {
                ISpan iSpan7;
                ISpan $this$performSql_u24lambda_u240 = iSpan7 = iSpan;
                boolean bl = false;
                boolean isMainThread = this.scopes.getOptions().getThreadChecker().isMainThread();
                $this$performSql_u24lambda_u240.setData("blocked_main_thread", (Object)isMainThread);
                if (isMainThread) {
                    $this$performSql_u24lambda_u240.setData("call_stack", (Object)this.stackTraceFactory.getInAppCallStack());
                }
                if (this.databaseName != null) {
                    $this$performSql_u24lambda_u240.setData("db.system", (Object)"sqlite");
                    $this$performSql_u24lambda_u240.setData("db.name", (Object)this.databaseName);
                } else {
                    $this$performSql_u24lambda_u240.setData("db.system", (Object)"in-memory");
                }
                $this$performSql_u24lambda_u240.finish();
            }
        }
        return (T)object;
    }

    public SQLiteSpanManager() {
        this(null, null, 3, null);
    }
}

