/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.video;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.video.MuxerConfig;
import io.sentry.android.replay.video.SimpleMp4FrameMuxer;
import io.sentry.android.replay.video.SimpleVideoEncoder;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0013H\u0002J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\bJ\u0006\u0010/\u001a\u00020\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0017\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/sentry/android/replay/video/SimpleVideoEncoder;", "", "options", "Lio/sentry/SentryOptions;", "muxerConfig", "Lio/sentry/android/replay/video/MuxerConfig;", "onClose", "Lkotlin/Function0;", "", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/video/MuxerConfig;Lkotlin/jvm/functions/Function0;)V", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "duration", "", "getDuration", "()J", "frameMuxer", "Lio/sentry/android/replay/video/SimpleMp4FrameMuxer;", "hasExynosCodec", "", "getHasExynosCodec", "()Z", "hasExynosCodec$delegate", "Lkotlin/Lazy;", "mediaCodec", "Landroid/media/MediaCodec;", "getMediaCodec$sentry_android_replay_release", "()Landroid/media/MediaCodec;", "mediaFormat", "Landroid/media/MediaFormat;", "getMediaFormat", "()Landroid/media/MediaFormat;", "mediaFormat$delegate", "getMuxerConfig", "()Lio/sentry/android/replay/video/MuxerConfig;", "getOnClose", "()Lkotlin/jvm/functions/Function0;", "getOptions", "()Lio/sentry/SentryOptions;", "surface", "Landroid/view/Surface;", "drainCodec", "endOfStream", "encode", "image", "Landroid/graphics/Bitmap;", "release", "start", "sentry-android-replay_release"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
public final class SimpleVideoEncoder {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final MuxerConfig muxerConfig;
    @Nullable
    private final Function0<Unit> onClose;
    @NotNull
    private final Lazy hasExynosCodec$delegate;
    @NotNull
    private final MediaCodec mediaCodec;
    @NotNull
    private final Lazy mediaFormat$delegate;
    @NotNull
    private final MediaCodec.BufferInfo bufferInfo;
    @NotNull
    private final SimpleMp4FrameMuxer frameMuxer;
    @Nullable
    private Surface surface;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SimpleVideoEncoder(@NotNull SentryOptions options, @NotNull MuxerConfig muxerConfig, @Nullable Function0<Unit> onClose) {
        void $this$mediaCodec_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)muxerConfig, (String)"muxerConfig");
        this.options = options;
        this.muxerConfig = muxerConfig;
        this.onClose = onClose;
        this.hasExynosCodec$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)hasExynosCodec.2.INSTANCE);
        SimpleVideoEncoder simpleVideoEncoder = this;
        SimpleVideoEncoder simpleVideoEncoder2 = this;
        boolean bl = false;
        MediaCodec mediaCodec = super.getHasExynosCodec() ? MediaCodec.createByCodecName((String)"c2.android.avc.encoder") : MediaCodec.createEncoderByType((String)$this$mediaCodec_u24lambda_u240.muxerConfig.getMimeType());
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"if (hasExynosCodec) {\n  \u2026onfig.mimeType)\n        }");
        MediaCodec codec = mediaCodec;
        simpleVideoEncoder2.mediaCodec = codec;
        this.mediaFormat$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<MediaFormat>(this){
            final /* synthetic */ SimpleVideoEncoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MediaFormat invoke() {
                int bitRate = this.this$0.getMuxerConfig().getBitRate();
                try {
                    MediaCodecInfo.VideoCapabilities videoCapabilities = this.this$0.getMediaCodec$sentry_android_replay_release().getCodecInfo().getCapabilitiesForType(this.this$0.getMuxerConfig().getMimeType()).getVideoCapabilities();
                    if (!videoCapabilities.getBitrateRange().contains((Comparable)Integer.valueOf(bitRate))) {
                        this.this$0.getOptions().getLogger().log(SentryLevel.DEBUG, "Encoder doesn't support the provided bitRate: " + bitRate + ", the value will be clamped to the closest one", new Object[0]);
                        Comparable comparable = videoCapabilities.getBitrateRange().clamp((Comparable)Integer.valueOf(bitRate));
                        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"videoCapabilities.bitrateRange.clamp(bitRate)");
                        bitRate = ((Number)((Object)comparable)).intValue();
                    }
                }
                catch (Throwable e) {
                    this.this$0.getOptions().getLogger().log(SentryLevel.DEBUG, "Could not retrieve MediaCodec info", e);
                }
                MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)this.this$0.getMuxerConfig().getMimeType(), (int)this.this$0.getMuxerConfig().getRecordingWidth(), (int)this.this$0.getMuxerConfig().getRecordingHeight());
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"createVideoFormat(\n     \u2026recordingHeight\n        )");
                MediaFormat format = mediaFormat2;
                format.setInteger("color-format", 2130708361);
                format.setInteger("bitrate", bitRate);
                format.setFloat("frame-rate", (float)this.this$0.getMuxerConfig().getFrameRate());
                format.setInteger("i-frame-interval", 6);
                return format;
            }
        }));
        this.bufferInfo = new MediaCodec.BufferInfo();
        String string = this.muxerConfig.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"muxerConfig.file.absolutePath");
        this.frameMuxer = new SimpleMp4FrameMuxer(string, this.muxerConfig.getFrameRate());
    }

    public /* synthetic */ SimpleVideoEncoder(SentryOptions sentryOptions, MuxerConfig muxerConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        this(sentryOptions, muxerConfig, (Function0<Unit>)function0);
    }

    @NotNull
    public final SentryOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final MuxerConfig getMuxerConfig() {
        return this.muxerConfig;
    }

    @Nullable
    public final Function0<Unit> getOnClose() {
        return this.onClose;
    }

    private final boolean getHasExynosCodec() {
        Lazy lazy = this.hasExynosCodec$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final MediaCodec getMediaCodec$sentry_android_replay_release() {
        return this.mediaCodec;
    }

    private final MediaFormat getMediaFormat() {
        Lazy lazy = this.mediaFormat$delegate;
        return (MediaFormat)lazy.getValue();
    }

    public final long getDuration() {
        return this.frameMuxer.getVideoTime();
    }

    public final void start() {
        this.mediaCodec.configure(this.getMediaFormat(), null, null, 1);
        this.surface = this.mediaCodec.createInputSurface();
        this.mediaCodec.start();
        this.drainCodec(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void encode(@NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        v0 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"MANUFACTURER");
        if (StringsKt.contains((CharSequence)v0, (CharSequence)"xiaomi", (boolean)true)) ** GOTO lbl-1000
        v1 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"MANUFACTURER");
        if (StringsKt.contains((CharSequence)v1, (CharSequence)"motorola", (boolean)true)) lbl-1000:
        // 2 sources

        {
            v2 = this.surface;
            v3 /* !! */  = v2 != null ? v2.lockCanvas(null) : null;
        } else {
            v4 = this.surface;
            v3 /* !! */  = v4 != null ? v4.lockHardwareCanvas() : null;
        }
        v5 = canvas = v3 /* !! */ ;
        if (v5 != null) {
            v5.drawBitmap(image, 0.0f, 0.0f, null);
        }
        v6 = this.surface;
        if (v6 != null) {
            v6.unlockCanvasAndPost(canvas);
        }
        this.drainCodec(false);
    }

    private final void drainCodec(boolean endOfStream) {
        block14: {
            this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: drainCodec(" + endOfStream + ')', new Object[0]);
            if (endOfStream) {
                this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: sending EOS to encoder", new Object[0]);
                this.mediaCodec.signalEndOfInputStream();
            }
            ByteBuffer[] encoderOutputBuffers = this.mediaCodec.getOutputBuffers();
            while (true) {
                int encoderStatus;
                if ((encoderStatus = this.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 100000L)) == -1) {
                    if (endOfStream) {
                        this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: no output available, spinning to await EOS", new Object[0]);
                        continue;
                    }
                    break block14;
                }
                if (encoderStatus == -3) {
                    encoderOutputBuffers = this.mediaCodec.getOutputBuffers();
                    continue;
                }
                if (encoderStatus == -2) {
                    MediaFormat newFormat;
                    if (this.frameMuxer.isStarted()) {
                        throw new RuntimeException("format changed twice");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)this.mediaCodec.getOutputFormat(), (String)"mediaCodec.outputFormat");
                    this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: encoder output format changed: " + newFormat, new Object[0]);
                    this.frameMuxer.start(newFormat);
                    continue;
                }
                if (encoderStatus < 0) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus, new Object[0]);
                    continue;
                }
                Object object = encoderOutputBuffers;
                if (encoderOutputBuffers == null || (object = object[encoderStatus]) == null) {
                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                }
                Object encodedData = object;
                if ((this.bufferInfo.flags & 2) != 0) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: ignoring BUFFER_FLAG_CODEC_CONFIG", new Object[0]);
                    this.bufferInfo.size = 0;
                }
                if (this.bufferInfo.size != 0) {
                    if (!this.frameMuxer.isStarted()) {
                        throw new RuntimeException("muxer hasn't started");
                    }
                    this.frameMuxer.muxVideoFrame((ByteBuffer)encodedData, this.bufferInfo);
                    this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: sent " + this.bufferInfo.size + " bytes to muxer", new Object[0]);
                }
                this.mediaCodec.releaseOutputBuffer(encoderStatus, false);
                if ((this.bufferInfo.flags & 4) != 0) break;
            }
            if (!endOfStream) {
                this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: reached end of stream unexpectedly", new Object[0]);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "[Encoder]: end of stream reached", new Object[0]);
            }
        }
    }

    public final void release() {
        try {
            Function0<Unit> function0 = this.onClose;
            if (function0 != null) {
                function0.invoke();
            }
            this.drainCodec(true);
            this.mediaCodec.stop();
            this.mediaCodec.release();
            Surface surface = this.surface;
            if (surface != null) {
                surface.release();
            }
            this.frameMuxer.release();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Failed to properly release video encoder", e);
        }
    }
}

