/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.ScreenshotStrategyType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ExecutorProvider;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.screenshot.CanvasStrategy;
import io.sentry.android.replay.screenshot.PixelCopyStrategy;
import io.sentry.android.replay.screenshot.ScreenshotStrategy;
import io.sentry.android.replay.util.DebugOverlayDrawable;
import io.sentry.android.replay.util.ViewsKt;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\b\u0010 \u001a\u00020\u001cH\u0016J\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020\u001cJ\u0010\u0010#\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "options", "Lio/sentry/SentryOptions;", "executorProvider", "Lio/sentry/android/replay/ExecutorProvider;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ExecutorProvider;Lio/sentry/android/replay/ScreenshotRecorderCallback;)V", "getConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "debugOverlayDrawable", "Lio/sentry/android/replay/util/DebugOverlayDrawable;", "getExecutorProvider", "()Lio/sentry/android/replay/ExecutorProvider;", "isCapturing", "getOptions", "()Lio/sentry/SentryOptions;", "rootView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "screenshotStrategy", "Lio/sentry/android/replay/screenshot/ScreenshotStrategy;", "bind", "", "root", "capture", "close", "onDraw", "pause", "resume", "unbind", "sentry-android-replay_release"})
@SuppressLint(value={"UseKtx", "UseRequiresApi"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
public final class ScreenshotRecorder
implements ViewTreeObserver.OnDrawListener {
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ExecutorProvider executorProvider;
    @Nullable
    private WeakReference<View> rootView;
    @NotNull
    private final AtomicBoolean isCapturing;
    @NotNull
    private final DebugOverlayDrawable debugOverlayDrawable;
    @NotNull
    private final AtomicBoolean contentChanged;
    @NotNull
    private final ScreenshotStrategy screenshotStrategy;
    public static final int $stable = 8;

    public ScreenshotRecorder(@NotNull ScreenshotRecorderConfig config, @NotNull SentryOptions options, @NotNull ExecutorProvider executorProvider, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback) {
        ScreenshotStrategy screenshotStrategy;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)executorProvider, (String)"executorProvider");
        this.config = config;
        this.options = options;
        this.executorProvider = executorProvider;
        this.isCapturing = new AtomicBoolean(true);
        this.debugOverlayDrawable = new DebugOverlayDrawable();
        this.contentChanged = new AtomicBoolean(false);
        switch (WhenMappings.$EnumSwitchMapping$0[this.options.getSessionReplay().getScreenshotStrategy().ordinal()]) {
            case 1: {
                screenshotStrategy = new CanvasStrategy(this.executorProvider, screenshotRecorderCallback, this.options, this.config);
                break;
            }
            case 2: {
                screenshotStrategy = new PixelCopyStrategy(this.executorProvider, screenshotRecorderCallback, this.options, this.config, this.debugOverlayDrawable);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.screenshotStrategy = screenshotStrategy;
    }

    @NotNull
    public final ScreenshotRecorderConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final SentryOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final void capture() {
        View root;
        Object[] objectArray;
        if (this.options.getSessionReplay().isDebug()) {
            objectArray = new Object[]{this.isCapturing.get()};
            this.options.getLogger().log(SentryLevel.DEBUG, "Capturing screenshot, isCapturing: %s", objectArray);
        }
        if (!this.isCapturing.get()) {
            if (this.options.getSessionReplay().isDebug()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "ScreenshotRecorder is paused, not capturing screenshot", new Object[0]);
            }
            return;
        }
        if (this.options.getSessionReplay().isDebug()) {
            objectArray = new Object[]{this.contentChanged.get(), this.screenshotStrategy.lastCaptureSuccessful()};
            this.options.getLogger().log(SentryLevel.DEBUG, "Capturing screenshot, contentChanged: %s, lastCaptureSuccessful: %s", objectArray);
        }
        if (!this.contentChanged.get()) {
            this.screenshotStrategy.emitLastScreenshot();
            return;
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Window window = WindowsKt.getPhoneWindow(root);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        try {
            this.contentChanged.set(false);
            this.screenshotStrategy.capture(root);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to capture replay recording", e);
        }
    }

    public void onDraw() {
        View root;
        if (!this.isCapturing.get()) {
            return;
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        this.contentChanged.set(true);
        this.screenshotStrategy.onContentChanged();
    }

    public final void bind(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        this.rootView = new WeakReference<View>(root);
        ViewsKt.addOnDrawListenerSafe(root, this);
        this.contentChanged.set(true);
        this.screenshotStrategy.onContentChanged();
    }

    public final void unbind(@Nullable View root) {
        block1: {
            View view;
            if (this.options.getReplayController().isDebugMaskingOverlayEnabled() && (view = root) != null && (view = view.getOverlay()) != null) {
                view.remove((Drawable)this.debugOverlayDrawable);
            }
            View view2 = root;
            if (view2 == null) break block1;
            ViewsKt.removeOnDrawListenerSafe(view2, this);
        }
    }

    public final void pause() {
        this.isCapturing.set(false);
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
    }

    public final void resume() {
        View view = this.rootView;
        if (view != null && (view = (View)view.get()) != null) {
            ViewsKt.addOnDrawListenerSafe(view, this);
        }
        this.isCapturing.set(true);
    }

    public final void close() {
        this.isCapturing.set(false);
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        this.screenshotStrategy.close();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScreenshotStrategyType.values().length];
            try {
                nArray[ScreenshotStrategyType.CANVAS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScreenshotStrategyType.PIXEL_COPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

