/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.screenshot;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ExecutorProvider;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.screenshot.PixelCopyStrategy;
import io.sentry.android.replay.screenshot.ScreenshotStrategy;
import io.sentry.android.replay.util.DebugOverlayDrawable;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.ReplayRunnable;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0017J\b\u0010/\u001a\u00020,H\u0016J\b\u00100\u001a\u00020,H\u0016J\b\u0010\u0012\u001a\u000201H\u0016J\b\u00102\u001a\u00020,H\u0016J\u0014\u00103\u001a\u000204*\u00020!2\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001a\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001a\u001a\u0004\b(\u0010)\u00a8\u00067"}, d2={"Lio/sentry/android/replay/screenshot/PixelCopyStrategy;", "Lio/sentry/android/replay/screenshot/ScreenshotStrategy;", "executorProvider", "Lio/sentry/android/replay/ExecutorProvider;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "options", "Lio/sentry/SentryOptions;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "debugOverlayDrawable", "Lio/sentry/android/replay/util/DebugOverlayDrawable;", "(Lio/sentry/android/replay/ExecutorProvider;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderConfig;Lio/sentry/android/replay/util/DebugOverlayDrawable;)V", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "isClosed", "lastCaptureSuccessful", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "maskingPaint", "Landroid/graphics/Paint;", "getMaskingPaint", "()Landroid/graphics/Paint;", "maskingPaint$delegate", "Lkotlin/Lazy;", "prescaledMatrix", "Landroid/graphics/Matrix;", "getPrescaledMatrix", "()Landroid/graphics/Matrix;", "prescaledMatrix$delegate", "screenshot", "Landroid/graphics/Bitmap;", "singlePixelBitmap", "getSinglePixelBitmap", "()Landroid/graphics/Bitmap;", "singlePixelBitmap$delegate", "singlePixelBitmapCanvas", "Landroid/graphics/Canvas;", "getSinglePixelBitmapCanvas", "()Landroid/graphics/Canvas;", "singlePixelBitmapCanvas$delegate", "capture", "", "root", "Landroid/view/View;", "close", "emitLastScreenshot", "", "onContentChanged", "dominantColorForRect", "", "rect", "Landroid/graphics/Rect;", "sentry-android-replay_release"})
@SuppressLint(value={"UseKtx"})
@StabilityInferred(parameters=0)
public final class PixelCopyStrategy
implements ScreenshotStrategy {
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final DebugOverlayDrawable debugOverlayDrawable;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final Lazy singlePixelBitmap$delegate;
    @NotNull
    private final Bitmap screenshot;
    @NotNull
    private final Lazy singlePixelBitmapCanvas$delegate;
    @NotNull
    private final Lazy prescaledMatrix$delegate;
    @NotNull
    private final AtomicBoolean lastCaptureSuccessful;
    @NotNull
    private final Lazy maskingPaint$delegate;
    @NotNull
    private final AtomicBoolean contentChanged;
    @NotNull
    private final AtomicBoolean isClosed;
    public static final int $stable = 8;

    public PixelCopyStrategy(@NotNull ExecutorProvider executorProvider, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull SentryOptions options, @NotNull ScreenshotRecorderConfig config, @NotNull DebugOverlayDrawable debugOverlayDrawable) {
        Intrinsics.checkNotNullParameter((Object)executorProvider, (String)"executorProvider");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)debugOverlayDrawable), (String)"debugOverlayDrawable");
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.options = options;
        this.config = config;
        this.debugOverlayDrawable = debugOverlayDrawable;
        this.executor = executorProvider.getExecutor();
        this.mainLooperHandler = executorProvider.getMainLooperHandler();
        this.singlePixelBitmap$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)singlePixelBitmap.2.INSTANCE);
        Bitmap bitmap = Bitmap.createBitmap((int)this.config.getRecordingWidth(), (int)this.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        this.screenshot = bitmap;
        this.singlePixelBitmapCanvas$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Canvas>(this){
            final /* synthetic */ PixelCopyStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Canvas invoke() {
                return new Canvas(PixelCopyStrategy.access$getSinglePixelBitmap(this.this$0));
            }
        }));
        this.prescaledMatrix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Matrix>(this){
            final /* synthetic */ PixelCopyStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Matrix invoke() {
                Matrix matrix = new Matrix();
                PixelCopyStrategy pixelCopyStrategy = this.this$0;
                Matrix $this$invoke_u24lambda_u240 = matrix;
                boolean bl = false;
                $this$invoke_u24lambda_u240.preScale(PixelCopyStrategy.access$getConfig$p(pixelCopyStrategy).getScaleFactorX(), PixelCopyStrategy.access$getConfig$p(pixelCopyStrategy).getScaleFactorY());
                return matrix;
            }
        }));
        this.lastCaptureSuccessful = new AtomicBoolean(false);
        this.maskingPaint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)maskingPaint.2.INSTANCE);
        this.contentChanged = new AtomicBoolean(false);
        this.isClosed = new AtomicBoolean(false);
    }

    private final Bitmap getSinglePixelBitmap() {
        Lazy lazy = this.singlePixelBitmap$delegate;
        return (Bitmap)lazy.getValue();
    }

    private final Canvas getSinglePixelBitmapCanvas() {
        Lazy lazy = this.singlePixelBitmapCanvas$delegate;
        return (Canvas)lazy.getValue();
    }

    private final Matrix getPrescaledMatrix() {
        Lazy lazy = this.prescaledMatrix$delegate;
        return (Matrix)lazy.getValue();
    }

    private final Paint getMaskingPaint() {
        Lazy lazy = this.maskingPaint$delegate;
        return (Paint)lazy.getValue();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void capture(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Window window = WindowsKt.getPhoneWindow(root);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        if (this.isClosed.get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "PixelCopyStrategy is closed, not capturing screenshot", new Object[0]);
            return;
        }
        try {
            this.contentChanged.set(false);
            PixelCopy.request((Window)window, (Bitmap)this.screenshot, arg_0 -> PixelCopyStrategy.capture$lambda$2(this, root, arg_0), (Handler)this.mainLooperHandler.getHandler());
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to capture replay recording", e);
            this.lastCaptureSuccessful.set(false);
        }
    }

    @Override
    public void onContentChanged() {
        this.contentChanged.set(true);
    }

    @Override
    public boolean lastCaptureSuccessful() {
        return this.lastCaptureSuccessful.get();
    }

    @Override
    public void emitLastScreenshot() {
        block1: {
            if (!this.lastCaptureSuccessful() || this.screenshot.isRecycled()) break block1;
            ScreenshotRecorderCallback screenshotRecorderCallback = this.screenshotRecorderCallback;
            if (screenshotRecorderCallback != null) {
                screenshotRecorderCallback.onScreenshotRecorded(this.screenshot);
            }
        }
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.executor.submit(new ReplayRunnable("PixelCopyStrategy.close", () -> PixelCopyStrategy.close$lambda$4(this)));
    }

    private final int dominantColorForRect(Bitmap $this$dominantColorForRect, Rect rect) {
        if (this.isClosed.get() || $this$dominantColorForRect.isRecycled() || this.getSinglePixelBitmap().isRecycled()) {
            return -16777216;
        }
        Rect visibleRect = new Rect(rect);
        RectF visibleRectF = new RectF(visibleRect);
        this.getPrescaledMatrix().mapRect(visibleRectF);
        visibleRectF.round(visibleRect);
        this.getSinglePixelBitmapCanvas().drawBitmap($this$dominantColorForRect, visibleRect, new Rect(0, 0, 1, 1), null);
        return this.getSinglePixelBitmap().getPixel(0, 0);
    }

    private static final void capture$lambda$2$lambda$1$lambda$0(PixelCopyStrategy this$0, View $root, List $debugMasks) {
        if (this$0.debugOverlayDrawable.getCallback() == null) {
            $root.getOverlay().add((Drawable)this$0.debugOverlayDrawable);
        }
        this$0.debugOverlayDrawable.updateMasks($debugMasks);
        $root.postInvalidate();
    }

    private static final void capture$lambda$2$lambda$1(PixelCopyStrategy this$0, ViewHierarchyNode $viewHierarchy, View $root) {
        if (this$0.isClosed.get() || this$0.screenshot.isRecycled()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "PixelCopyStrategy is closed, skipping masking", new Object[0]);
            return;
        }
        List debugMasks = new ArrayList();
        Canvas canvas = new Canvas(this$0.screenshot);
        canvas.setMatrix(this$0.getPrescaledMatrix());
        $viewHierarchy.traverse((Function1<? super ViewHierarchyNode, Boolean>)((Function1)new Function1<ViewHierarchyNode, Boolean>(this$0, (List<Rect>)debugMasks, canvas){
            final /* synthetic */ PixelCopyStrategy this$0;
            final /* synthetic */ List<Rect> $debugMasks;
            final /* synthetic */ Canvas $canvas;
            {
                this.this$0 = $receiver;
                this.$debugMasks = $debugMasks;
                this.$canvas = $canvas;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(ViewHierarchyNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getShouldMask() && node.getWidth() > 0 && node.getHeight() > 0) {
                    void $this$forEach$iv;
                    Pair pair;
                    if (node.getVisibleRect() == null) {
                        return false;
                    }
                    ViewHierarchyNode viewHierarchyNode = node;
                    if (viewHierarchyNode instanceof ViewHierarchyNode.ImageViewHierarchyNode) {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)PixelCopyStrategy.access$dominantColorForRect(this.this$0, PixelCopyStrategy.access$getScreenshot$p(this.this$0), node.getVisibleRect()));
                    } else if (viewHierarchyNode instanceof ViewHierarchyNode.TextViewHierarchyNode) {
                        int n;
                        Object object = ((ViewHierarchyNode.TextViewHierarchyNode)node).getLayout();
                        if (object != null && (object = object.getDominantTextColor()) != null) {
                            n = (Integer)object;
                        } else {
                            Integer n2 = ((ViewHierarchyNode.TextViewHierarchyNode)node).getDominantColor();
                            n = n2 != null ? n2 : -16777216;
                        }
                        int textColor = n;
                        pair = TuplesKt.to(ViewsKt.getVisibleRects(((ViewHierarchyNode.TextViewHierarchyNode)node).getLayout(), node.getVisibleRect(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingLeft(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingTop()), (Object)textColor);
                    } else {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)-16777216);
                    }
                    Pair pair2 = pair;
                    List visibleRects = (List)pair2.component1();
                    int color = ((Number)pair2.component2()).intValue();
                    PixelCopyStrategy.access$getMaskingPaint(this.this$0).setColor(color);
                    Iterable iterable = visibleRects;
                    Canvas canvas = this.$canvas;
                    PixelCopyStrategy pixelCopyStrategy = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Rect rect = (Rect)element$iv;
                        boolean bl = false;
                        canvas.drawRoundRect(new RectF(rect), 10.0f, 10.0f, PixelCopyStrategy.access$getMaskingPaint(pixelCopyStrategy));
                    }
                    if (PixelCopyStrategy.access$getOptions$p(this.this$0).getReplayController().isDebugMaskingOverlayEnabled()) {
                        this.$debugMasks.addAll(visibleRects);
                    }
                }
                return true;
            }
        }));
        if (this$0.options.getReplayController().isDebugMaskingOverlayEnabled()) {
            this$0.mainLooperHandler.post(() -> PixelCopyStrategy.capture$lambda$2$lambda$1$lambda$0(this$0, $root, debugMasks));
        }
        ScreenshotRecorderCallback screenshotRecorderCallback = this$0.screenshotRecorderCallback;
        if (screenshotRecorderCallback != null) {
            screenshotRecorderCallback.onScreenshotRecorded(this$0.screenshot);
        }
        this$0.lastCaptureSuccessful.set(true);
        this$0.contentChanged.set(false);
    }

    private static final void capture$lambda$2(PixelCopyStrategy this$0, View $root, int copyResult) {
        if (this$0.isClosed.get()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "PixelCopyStrategy is closed, ignoring capture result", new Object[0]);
            return;
        }
        if (copyResult != 0) {
            Object[] objectArray = new Object[]{copyResult};
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to capture replay recording: %d", objectArray);
            this$0.lastCaptureSuccessful.set(false);
            return;
        }
        if (this$0.contentChanged.get()) {
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to determine view hierarchy, not capturing", new Object[0]);
            this$0.lastCaptureSuccessful.set(false);
            return;
        }
        ViewHierarchyNode viewHierarchy = ViewHierarchyNode.Companion.fromView($root, null, 0, this$0.options);
        ViewsKt.traverse($root, viewHierarchy, this$0.options);
        this$0.executor.submit(new ReplayRunnable("screenshot_recorder.mask", () -> PixelCopyStrategy.capture$lambda$2$lambda$1(this$0, viewHierarchy, $root)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void close$lambda$4(PixelCopyStrategy this$0) {
        if (!this$0.screenshot.isRecycled()) {
            Bitmap bitmap = this$0.screenshot;
            synchronized (bitmap) {
                boolean bl = false;
                if (!this$0.screenshot.isRecycled()) {
                    this$0.screenshot.recycle();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        if (!this$0.getSinglePixelBitmap().isRecycled()) {
            this$0.getSinglePixelBitmap().recycle();
        }
    }

    public static final /* synthetic */ int access$dominantColorForRect(PixelCopyStrategy $this, Bitmap $receiver, Rect rect) {
        return $this.dominantColorForRect($receiver, rect);
    }

    public static final /* synthetic */ Bitmap access$getScreenshot$p(PixelCopyStrategy $this) {
        return $this.screenshot;
    }

    public static final /* synthetic */ Paint access$getMaskingPaint(PixelCopyStrategy $this) {
        return $this.getMaskingPaint();
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(PixelCopyStrategy $this) {
        return $this.options;
    }

    public static final /* synthetic */ Bitmap access$getSinglePixelBitmap(PixelCopyStrategy $this) {
        return $this.getSinglePixelBitmap();
    }

    public static final /* synthetic */ ScreenshotRecorderConfig access$getConfig$p(PixelCopyStrategy $this) {
        return $this.config;
    }
}

