/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.MotionEvent;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.DataCategory;
import io.sentry.Hint;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.NoOpReplayBreadcrumbConverter;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.ReplayController;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.SentryReplayOptions;
import io.sentry.android.replay.LastSegmentData;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayIntegration;
import io.sentry.android.replay.ReplayLifecycle;
import io.sentry.android.replay.ReplayState;
import io.sentry.android.replay.RootViewsSpy;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowCallback;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.BufferCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.capture.SessionCaptureStrategy;
import io.sentry.android.replay.gestures.GestureRecorder;
import io.sentry.android.replay.gestures.TouchRecorderCallback;
import io.sentry.android.replay.util.ContextKt;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.SamplingKt;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.hints.Backfillable;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.transport.RateLimiter;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.FileUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Random;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0007\u0018\u0000 |2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\b:\u0003|}~B\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0091\u0001\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012#\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0012\u0012%\b\u0002\u0010\u0018\u001a\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u000f\u00a2\u0006\u0002\u0010 BN\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012%\b\u0002\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0012\u00a2\u0006\u0002\u0010!J\u0017\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u00020LH\u0002J\u0012\u0010P\u001a\u00020L2\b\b\u0002\u0010Q\u001a\u00020RH\u0002J\b\u0010S\u001a\u00020LH\u0016J\b\u0010T\u001a\u00020LH\u0016J\b\u0010U\u001a\u00020LH\u0016J\b\u0010V\u001a\u00020LH\u0002J\b\u0010W\u001a\u000209H\u0016J\b\u0010X\u001a\u00020\u0013H\u0016J\b\u0010Y\u001a\u00020\u0019H\u0016J\b\u0010Z\u001a\u00020\u0019H\u0016J\u000e\u0010[\u001a\u00020L2\u0006\u0010\\\u001a\u00020]J\u0010\u0010^\u001a\u00020L2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020cH\u0016J\u0010\u0010d\u001a\u00020L2\u0006\u0010e\u001a\u00020fH\u0016J\u0018\u0010d\u001a\u00020L2\u0006\u0010g\u001a\u00020;2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020lH\u0016J\u0018\u0010m\u001a\u00020L2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020oH\u0016J\b\u0010q\u001a\u00020LH\u0016J\b\u0010r\u001a\u00020LH\u0002J\u0018\u0010s\u001a\u00020L2\u0006\u0010I\u001a\u00020J2\u0006\u0010/\u001a\u000200H\u0016J\b\u0010t\u001a\u00020LH\u0002J\b\u0010u\u001a\u00020LH\u0016J\b\u0010v\u001a\u00020LH\u0002J\u0010\u0010w\u001a\u00020L2\u0006\u0010x\u001a\u000209H\u0016J\b\u0010y\u001a\u00020LH\u0016J\b\u0010z\u001a\u00020LH\u0016J\b\u0010{\u001a\u00020LH\u0002R\u0010\u0010\"\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R\u0010\u00107\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010:\u001a\u0004\u0018\u00010;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R+\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0018\u001a\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010>\u001a\n @*\u0004\u0018\u00010?0?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u00106\u001a\u0004\bA\u0010BR\u001b\u0010D\u001a\u00020E8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u00106\u001a\u0004\bF\u0010GR\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lio/sentry/android/replay/ReplayIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "Lio/sentry/android/replay/gestures/TouchRecorderCallback;", "Lio/sentry/ReplayController;", "Lio/sentry/IConnectionStatusProvider$IConnectionStatusObserver;", "Lio/sentry/transport/RateLimiter$IRateLimitObserver;", "Lio/sentry/android/replay/WindowCallback;", "context", "Landroid/content/Context;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;)V", "recorderProvider", "Lkotlin/Function0;", "Lio/sentry/android/replay/Recorder;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "replayCaptureStrategyProvider", "", "isFullSession", "Lio/sentry/android/replay/capture/CaptureStrategy;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "gestureRecorderProvider", "Lio/sentry/android/replay/gestures/GestureRecorder;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lio/sentry/android/replay/util/MainLooperHandler;Lkotlin/jvm/functions/Function0;)V", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "captureStrategy", "debugMaskingEnabled", "gestureRecorder", "isEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled$sentry_android_replay_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isManualPause", "isManualPause$sentry_android_replay_release", "lifecycle", "Lio/sentry/android/replay/ReplayLifecycle;", "lifecycleLock", "Lio/sentry/util/AutoClosableReentrantLock;", "options", "Lio/sentry/SentryOptions;", "random", "Lio/sentry/util/Random;", "getRandom", "()Lio/sentry/util/Random;", "random$delegate", "Lkotlin/Lazy;", "recorder", "replayBreadcrumbConverter", "Lio/sentry/ReplayBreadcrumbConverter;", "replayCacheDir", "Ljava/io/File;", "getReplayCacheDir", "()Ljava/io/File;", "replayExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getReplayExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "replayExecutor$delegate", "rootViewsSpy", "Lio/sentry/android/replay/RootViewsSpy;", "getRootViewsSpy$sentry_android_replay_release", "()Lio/sentry/android/replay/RootViewsSpy;", "rootViewsSpy$delegate", "scopes", "Lio/sentry/IScopes;", "captureReplay", "", "isTerminating", "(Ljava/lang/Boolean;)V", "checkCanRecord", "cleanupReplays", "unfinishedReplayId", "", "close", "disableDebugMaskingOverlay", "enableDebugMaskingOverlay", "finalizePreviousReplay", "getBreadcrumbConverter", "getReplayId", "isDebugMaskingOverlayEnabled", "isRecording", "onConfigurationChanged", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "onConnectionStatusChanged", "status", "Lio/sentry/IConnectionStatusProvider$ConnectionStatus;", "onRateLimitChanged", "rateLimiter", "Lio/sentry/transport/RateLimiter;", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "screenshot", "frameTimestamp", "", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onWindowSizeChanged", "width", "", "height", "pause", "pauseInternal", "register", "registerRootViewListeners", "resume", "resumeInternal", "setBreadcrumbConverter", "converter", "start", "stop", "unregisterRootViewListeners", "Companion", "PreviousReplayHint", "ReplayExecutorServiceThreadFactory", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReplayIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayIntegration.kt\nio/sentry/android/replay/ReplayIntegration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,513:1\n13309#2,2:514\n*S KotlinDebug\n*F\n+ 1 ReplayIntegration.kt\nio/sentry/android/replay/ReplayIntegration\n*L\n404#1:514,2\n*E\n"})
public final class ReplayIntegration
implements Integration,
Closeable,
ScreenshotRecorderCallback,
TouchRecorderCallback,
ReplayController,
IConnectionStatusProvider.IConnectionStatusObserver,
RateLimiter.IRateLimitObserver,
WindowCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private final Function0<Recorder> recorderProvider;
    @Nullable
    private final Function1<SentryId, ReplayCache> replayCacheProvider;
    private boolean debugMaskingEnabled;
    private SentryOptions options;
    @Nullable
    private IScopes scopes;
    @Nullable
    private Recorder recorder;
    @Nullable
    private GestureRecorder gestureRecorder;
    @NotNull
    private final Lazy random$delegate;
    @NotNull
    private final Lazy rootViewsSpy$delegate;
    @NotNull
    private final Lazy replayExecutor$delegate;
    @NotNull
    private final AtomicBoolean isEnabled;
    @NotNull
    private final AtomicBoolean isManualPause;
    @Nullable
    private CaptureStrategy captureStrategy;
    @NotNull
    private ReplayBreadcrumbConverter replayBreadcrumbConverter;
    @Nullable
    private Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider;
    @NotNull
    private MainLooperHandler mainLooperHandler;
    @Nullable
    private Function0<GestureRecorder> gestureRecorderProvider;
    @NotNull
    private final AutoClosableReentrantLock lifecycleLock;
    @NotNull
    private final ReplayLifecycle lifecycle;
    public static final int $stable = 8;

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.context = context;
        this.dateProvider = dateProvider;
        this.recorderProvider = recorderProvider;
        this.replayCacheProvider = replayCacheProvider;
        this.random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
        this.rootViewsSpy$delegate = LazyKt.lazy((Function0)rootViewsSpy.2.INSTANCE);
        this.replayExecutor$delegate = LazyKt.lazy((Function0)replayExecutor.2.INSTANCE);
        this.isEnabled = new AtomicBoolean(false);
        this.isManualPause = new AtomicBoolean(false);
        NoOpReplayBreadcrumbConverter noOpReplayBreadcrumbConverter = NoOpReplayBreadcrumbConverter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)noOpReplayBreadcrumbConverter, (String)"getInstance(...)");
        this.replayBreadcrumbConverter = (ReplayBreadcrumbConverter)noOpReplayBreadcrumbConverter;
        this.mainLooperHandler = new MainLooperHandler(null, 1, null);
        this.lifecycleLock = new AutoClosableReentrantLock();
        this.lifecycle = new ReplayLifecycle();
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super SentryId, ReplayCache>)function1);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(ContextKt.appContext(context), dateProvider, null, null);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider, @Nullable Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider, @Nullable MainLooperHandler mainLooperHandler, @Nullable Function0<GestureRecorder> gestureRecorderProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(ContextKt.appContext(context), dateProvider, recorderProvider, replayCacheProvider);
        this.replayCaptureStrategyProvider = replayCaptureStrategyProvider;
        MainLooperHandler mainLooperHandler2 = mainLooperHandler;
        if (mainLooperHandler2 == null) {
            mainLooperHandler2 = new MainLooperHandler(null, 1, null);
        }
        this.mainLooperHandler = mainLooperHandler2;
        this.gestureRecorderProvider = gestureRecorderProvider;
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, Function1 function12, MainLooperHandler mainLooperHandler, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function12 = null;
        }
        if ((n & 0x20) != 0) {
            mainLooperHandler = null;
        }
        if ((n & 0x40) != 0) {
            function02 = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super SentryId, ReplayCache>)function1, (Function1<? super Boolean, ? extends CaptureStrategy>)function12, mainLooperHandler, (Function0<GestureRecorder>)function02);
    }

    private final Random getRandom() {
        Lazy lazy = this.random$delegate;
        return (Random)lazy.getValue();
    }

    @NotNull
    public final RootViewsSpy getRootViewsSpy$sentry_android_replay_release() {
        Lazy lazy = this.rootViewsSpy$delegate;
        return (RootViewsSpy)lazy.getValue();
    }

    private final ScheduledExecutorService getReplayExecutor() {
        Lazy lazy = this.replayExecutor$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    @NotNull
    public final AtomicBoolean isEnabled$sentry_android_replay_release() {
        return this.isEnabled;
    }

    @NotNull
    public final AtomicBoolean isManualPause$sentry_android_replay_release() {
        return this.isManualPause;
    }

    @Nullable
    public final File getReplayCacheDir() {
        CaptureStrategy captureStrategy = this.captureStrategy;
        return captureStrategy != null ? captureStrategy.getReplayCacheDir() : null;
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        if (Build.VERSION.SDK_INT < 26) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is only supported on API 26 and above", new Object[0]);
            return;
        }
        if (!options.getSessionReplay().isSessionReplayEnabled() && !options.getSessionReplay().isSessionReplayForErrorsEnabled()) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is disabled, no sample rate specified", new Object[0]);
            return;
        }
        this.scopes = scopes;
        Object object2 = this.recorderProvider;
        if (object2 == null || (object2 = (Recorder)object2.invoke()) == null) {
            ScreenshotRecorderCallback screenshotRecorderCallback = this;
            WindowCallback windowCallback = this;
            ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"<get-replayExecutor>(...)");
            object2 = this.recorder = (Recorder)new WindowRecorder(options, screenshotRecorderCallback, windowCallback, this.mainLooperHandler, scheduledExecutorService);
        }
        if ((object = this.gestureRecorderProvider) == null || (object = (GestureRecorder)object.invoke()) == null) {
            object = new GestureRecorder(options, this);
        }
        this.gestureRecorder = object;
        this.isEnabled.set(true);
        options.getConnectionStatusProvider().addConnectionStatusObserver((IConnectionStatusProvider.IConnectionStatusObserver)this);
        RateLimiter rateLimiter = scopes.getRateLimiter();
        if (rateLimiter != null) {
            rateLimiter.addRateLimitObserver((RateLimiter.IRateLimitObserver)this);
        }
        IntegrationUtils.addIntegrationToSdkVersion((String)"Replay");
        this.finalizePreviousReplay();
    }

    public boolean isRecording() {
        return this.lifecycle.getCurrentState$sentry_android_replay_release().compareTo((Enum)ReplayState.STARTED) >= 0 && this.lifecycle.getCurrentState$sentry_android_replay_release().compareTo((Enum)ReplayState.STOPPED) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lifecycleLock.acquire();
        Throwable throwable = null;
        try {
            boolean isFullSession;
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            if (!this.isEnabled.get()) {
                return;
            }
            if (!this.lifecycle.isAllowed(ReplayState.STARTED)) {
                SentryOptions sentryOptions = this.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                sentryOptions.getLogger().log(SentryLevel.DEBUG, "Session replay is already being recorded, not starting a new one", new Object[0]);
                return;
            }
            Random random2 = this.getRandom();
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            if (!(isFullSession = SamplingKt.sample(random2, sentryOptions.getSessionReplay().getSessionSampleRate()))) {
                SentryOptions sentryOptions2 = this.options;
                if (sentryOptions2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions2 = null;
                }
                if (!sentryOptions2.getSessionReplay().isSessionReplayForErrorsEnabled()) {
                    SentryOptions sentryOptions3 = this.options;
                    if (sentryOptions3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions3 = null;
                    }
                    sentryOptions3.getLogger().log(SentryLevel.INFO, "Session replay is not started, full session was not sampled and onErrorSampleRate is not specified", new Object[0]);
                    return;
                }
            }
            this.lifecycle.setCurrentState$sentry_android_replay_release(ReplayState.STARTED);
            Object object = this.replayCaptureStrategyProvider;
            if (object == null || (object = (CaptureStrategy)object.invoke((Object)isFullSession)) == null) {
                BaseCaptureStrategy baseCaptureStrategy;
                if (isFullSession) {
                    SentryOptions sentryOptions4 = this.options;
                    if (sentryOptions4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions4 = null;
                    }
                    ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
                    Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"<get-replayExecutor>(...)");
                    baseCaptureStrategy = new SessionCaptureStrategy(sentryOptions4, this.scopes, this.dateProvider, scheduledExecutorService, this.replayCacheProvider);
                } else {
                    SentryOptions sentryOptions5 = this.options;
                    if (sentryOptions5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions5 = null;
                    }
                    Random random3 = this.getRandom();
                    ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
                    Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"<get-replayExecutor>(...)");
                    baseCaptureStrategy = new BufferCaptureStrategy(sentryOptions5, this.scopes, this.dateProvider, random3, scheduledExecutorService, this.replayCacheProvider);
                }
                object = baseCaptureStrategy;
            }
            this.captureStrategy = object;
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.start();
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                CaptureStrategy.DefaultImpls.start$default(captureStrategy, 0, null, null, 7, null);
            }
            this.registerRootViewListeners();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public void resume() {
        this.isManualPause.set(false);
        this.resumeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resumeInternal() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lifecycleLock.acquire();
        Throwable throwable = null;
        try {
            Unit unit;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                            boolean bl = false;
                            if (!this.isEnabled.get()) break block18;
                            if (this.lifecycle.isAllowed(ReplayState.RESUMED)) break block19;
                        }
                        return;
                    }
                    if (this.isManualPause.get()) break block20;
                    SentryOptions sentryOptions = this.options;
                    if (sentryOptions == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions = null;
                    }
                    if (sentryOptions.getConnectionStatusProvider().getConnectionStatus() == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) break block20;
                    IScopes iScopes = this.scopes;
                    if (iScopes != null && (iScopes = iScopes.getRateLimiter()) != null ? iScopes.isActiveForCategory(DataCategory.All) : false) break block20;
                    IScopes iScopes2 = this.scopes;
                    boolean bl = iScopes2 != null && (iScopes2 = iScopes2.getRateLimiter()) != null ? iScopes2.isActiveForCategory(DataCategory.Replay) : false;
                    if (!bl) break block21;
                }
                return;
            }
            this.lifecycle.setCurrentState$sentry_android_replay_release(ReplayState.RESUMED);
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.resume();
            }
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.resume();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public void captureReplay(@Nullable Boolean isTerminating) {
        if (!this.isEnabled.get() || !this.isRecording()) {
            return;
        }
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (SentryId.EMPTY_ID.equals(captureStrategy != null ? captureStrategy.getCurrentReplayId() : null)) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Replay id is not set, not capturing for event", new Object[0]);
            return;
        }
        CaptureStrategy captureStrategy2 = this.captureStrategy;
        if (captureStrategy2 != null) {
            captureStrategy2.captureReplay(Intrinsics.areEqual((Object)isTerminating, (Object)true), (Function1<? super Date, Unit>)((Function1)new Function1<Date, Unit>(this){
                final /* synthetic */ ReplayIntegration this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Date newTimestamp) {
                    Intrinsics.checkNotNullParameter((Object)newTimestamp, (String)"newTimestamp");
                    CaptureStrategy captureStrategy = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                    if (captureStrategy != null) {
                        CaptureStrategy captureStrategy2 = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                        Integer n = captureStrategy2 != null ? Integer.valueOf(captureStrategy2.getCurrentSegment()) : null;
                        Intrinsics.checkNotNull((Object)n);
                        captureStrategy.setCurrentSegment(n + 1);
                    }
                    CaptureStrategy captureStrategy3 = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                    if (captureStrategy3 != null) {
                        captureStrategy3.setSegmentTimestamp(newTimestamp);
                    }
                }
            }));
        }
        CaptureStrategy captureStrategy3 = this.captureStrategy;
        this.captureStrategy = captureStrategy3 != null ? captureStrategy3.convert() : null;
    }

    @NotNull
    public SentryId getReplayId() {
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy == null || (captureStrategy = captureStrategy.getCurrentReplayId()) == null) {
            SentryId sentryId = SentryId.EMPTY_ID;
            captureStrategy = sentryId;
            Intrinsics.checkNotNullExpressionValue((Object)sentryId, (String)"EMPTY_ID");
        }
        return captureStrategy;
    }

    public void setBreadcrumbConverter(@NotNull ReplayBreadcrumbConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.replayBreadcrumbConverter = converter;
    }

    @NotNull
    public ReplayBreadcrumbConverter getBreadcrumbConverter() {
        return this.replayBreadcrumbConverter;
    }

    public void pause() {
        this.isManualPause.set(true);
        this.pauseInternal();
    }

    public void enableDebugMaskingOverlay() {
        this.debugMaskingEnabled = true;
    }

    public void disableDebugMaskingOverlay() {
        this.debugMaskingEnabled = false;
    }

    public boolean isDebugMaskingOverlayEnabled() {
        return this.debugMaskingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pauseInternal() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lifecycleLock.acquire();
        Throwable throwable = null;
        try {
            block13: {
                block12: {
                    ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                    boolean bl = false;
                    if (!this.isEnabled.get()) break block12;
                    if (this.lifecycle.isAllowed(ReplayState.PAUSED)) break block13;
                }
                return;
            }
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.pause();
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.pause();
            }
            this.lifecycle.setCurrentState$sentry_android_replay_release(ReplayState.PAUSED);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lifecycleLock.acquire();
        Throwable throwable = null;
        try {
            block15: {
                block14: {
                    ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                    boolean bl = false;
                    if (!this.isEnabled.get()) break block14;
                    if (this.lifecycle.isAllowed(ReplayState.STOPPED)) break block15;
                }
                return;
            }
            this.unregisterRootViewListeners();
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.reset();
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.stop();
            }
            GestureRecorder gestureRecorder = this.gestureRecorder;
            if (gestureRecorder != null) {
                gestureRecorder.stop();
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.stop();
            }
            this.captureStrategy = null;
            this.lifecycle.setCurrentState$sentry_android_replay_release(ReplayState.STOPPED);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void onScreenshotRecorded(@NotNull Bitmap bitmap) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Ref.ObjectRef screen = new Ref.ObjectRef();
            IScopes iScopes = this.scopes;
            if (iScopes != null) {
                iScopes.configureScope(arg_0 -> ReplayIntegration.onScreenshotRecorded$lambda$4(screen, arg_0));
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block1;
            captureStrategy.onScreenshotRecorded(bitmap, (Function2<? super ReplayCache, ? super Long, Unit>)((Function2)new Function2<ReplayCache, Long, Unit>(bitmap, (Ref.ObjectRef<String>)screen, this){
                final /* synthetic */ Bitmap $bitmap;
                final /* synthetic */ Ref.ObjectRef<String> $screen;
                final /* synthetic */ ReplayIntegration this$0;
                {
                    this.$bitmap = $bitmap;
                    this.$screen = $screen;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(ReplayCache $this$onScreenshotRecorded, long frameTimeStamp) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    $this$onScreenshotRecorded.addFrame$sentry_android_replay_release(this.$bitmap, frameTimeStamp, (String)this.$screen.element);
                    ReplayIntegration.access$checkCanRecord(this.this$0);
                }
            }));
        }
    }

    @Override
    public void onScreenshotRecorded(@NotNull File screenshot, long frameTimestamp) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            CaptureStrategy.DefaultImpls.onScreenshotRecorded$default(captureStrategy, null, (Function2)new Function2<ReplayCache, Long, Unit>(screenshot, frameTimestamp, this){
                final /* synthetic */ File $screenshot;
                final /* synthetic */ long $frameTimestamp;
                final /* synthetic */ ReplayIntegration this$0;
                {
                    this.$screenshot = $screenshot;
                    this.$frameTimestamp = $frameTimestamp;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(ReplayCache $this$onScreenshotRecorded, long l) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    ReplayCache.addFrame$default($this$onScreenshotRecorded, this.$screenshot, this.$frameTimestamp, null, 4, null);
                    ReplayIntegration.access$checkCanRecord(this.this$0);
                }
            }, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lifecycleLock.acquire();
        Throwable throwable = null;
        try {
            block15: {
                block14: {
                    ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                    boolean bl = false;
                    if (!this.isEnabled.get()) break block14;
                    if (this.lifecycle.isAllowed(ReplayState.CLOSED)) break block15;
                }
                return;
            }
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            sentryOptions.getConnectionStatusProvider().removeConnectionStatusObserver((IConnectionStatusProvider.IConnectionStatusObserver)this);
            IScopes iScopes = this.scopes;
            if (iScopes != null && (iScopes = iScopes.getRateLimiter()) != null) {
                iScopes.removeRateLimitObserver((RateLimiter.IRateLimitObserver)this);
            }
            this.stop();
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.close();
            }
            this.recorder = null;
            this.getRootViewsSpy$sentry_android_replay_release().close();
            ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"<get-replayExecutor>(...)");
            ExecutorService executorService = scheduledExecutorService;
            SentryOptions sentryOptions2 = this.options;
            if (sentryOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions2 = null;
            }
            ExecutorsKt.gracefullyShutdown(executorService, sentryOptions2);
            this.lifecycle.setCurrentState$sentry_android_replay_release(ReplayState.CLOSED);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public void onConnectionStatusChanged(@NotNull IConnectionStatusProvider.ConnectionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (!(this.captureStrategy instanceof SessionCaptureStrategy)) {
            return;
        }
        if (status == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) {
            this.pauseInternal();
        } else {
            this.resumeInternal();
        }
    }

    public void onRateLimitChanged(@NotNull RateLimiter rateLimiter) {
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        if (!(this.captureStrategy instanceof SessionCaptureStrategy)) {
            return;
        }
        if (rateLimiter.isActiveForCategory(DataCategory.All) || rateLimiter.isActiveForCategory(DataCategory.Replay)) {
            this.pauseInternal();
        } else {
            this.resumeInternal();
        }
    }

    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.isEnabled.get() || !this.lifecycle.isTouchRecordingAllowed()) {
                return;
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block1;
            captureStrategy.onTouchEvent(event);
        }
    }

    private final void checkCanRecord() {
        block4: {
            block5: {
                if (!(this.captureStrategy instanceof SessionCaptureStrategy)) break block4;
                SentryOptions sentryOptions = this.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                if (sentryOptions.getConnectionStatusProvider().getConnectionStatus() == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) break block5;
                IScopes iScopes = this.scopes;
                if (iScopes != null && (iScopes = iScopes.getRateLimiter()) != null ? iScopes.isActiveForCategory(DataCategory.All) : false) break block5;
                IScopes iScopes2 = this.scopes;
                boolean bl = iScopes2 != null && (iScopes2 = iScopes2.getRateLimiter()) != null ? iScopes2.isActiveForCategory(DataCategory.Replay) : false;
                if (!bl) break block4;
            }
            this.pauseInternal();
        }
    }

    private final void registerRootViewListeners() {
        if (this.recorder instanceof OnRootViewsChangedListener) {
            Collection collection = this.getRootViewsSpy$sentry_android_replay_release().getListeners();
            Recorder recorder = this.recorder;
            Intrinsics.checkNotNull((Object)recorder, (String)"null cannot be cast to non-null type io.sentry.android.replay.OnRootViewsChangedListener");
            collection.add((OnRootViewsChangedListener)((Object)recorder));
        }
        ((Collection)this.getRootViewsSpy$sentry_android_replay_release().getListeners()).add(this.gestureRecorder);
    }

    private final void unregisterRootViewListeners() {
        if (this.recorder instanceof OnRootViewsChangedListener) {
            Collection collection = this.getRootViewsSpy$sentry_android_replay_release().getListeners();
            Recorder recorder = this.recorder;
            Intrinsics.checkNotNull((Object)recorder, (String)"null cannot be cast to non-null type io.sentry.android.replay.OnRootViewsChangedListener");
            collection.remove((OnRootViewsChangedListener)((Object)recorder));
        }
        ((Collection)this.getRootViewsSpy$sentry_android_replay_release().getListeners()).remove(this.gestureRecorder);
    }

    private final void cleanupReplays(String unfinishedReplayId) {
        block3: {
            File[] fileArray;
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            String string = sentryOptions.getCacheDirPath();
            if (string == null) break block3;
            String cacheDir = string;
            boolean bl = false;
            if (fileArray != null) {
                fileArray = new File(cacheDir).listFiles();
                Intrinsics.checkNotNull((Object)fileArray);
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    String name = file.getName();
                    Intrinsics.checkNotNull((Object)name);
                    if (!StringsKt.startsWith$default((String)name, (String)"replay_", (boolean)false, (int)2, null)) continue;
                    CharSequence charSequence = name;
                    String string2 = this.getReplayId().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) || !StringsKt.isBlank((CharSequence)unfinishedReplayId) && StringsKt.contains$default((CharSequence)name, (CharSequence)unfinishedReplayId, (boolean)false, (int)2, null)) continue;
                    FileUtils.deleteRecursively((File)file);
                }
            }
        }
    }

    static /* synthetic */ void cleanupReplays$default(ReplayIntegration replayIntegration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        replayIntegration.cleanupReplays(string);
    }

    private final void finalizePreviousReplay() {
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ISentryExecutorService iSentryExecutorService = sentryOptions.getExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)iSentryExecutorService, (String)"getExecutorService(...)");
        SentryOptions sentryOptions2 = this.options;
        if (sentryOptions2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions2 = null;
        }
        ExecutorsKt.submitSafely(iSentryExecutorService, sentryOptions2, "ReplayIntegration.finalize_previous_replay", () -> ReplayIntegration.finalizePreviousReplay$lambda$10(this));
    }

    @Override
    public void onWindowSizeChanged(int width, int height) {
        if (!this.isEnabled.get() || !this.isRecording()) {
            return;
        }
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        if (sentryOptions.getSessionReplay().isTrackConfiguration()) {
            SentryOptions sentryOptions2 = this.options;
            if (sentryOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions2 = null;
            }
            SentryReplayOptions sentryReplayOptions = sentryOptions2.getSessionReplay();
            Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"getSessionReplay(...)");
            ScreenshotRecorderConfig recorderConfig = ScreenshotRecorderConfig.Companion.fromSize(this.context, sentryReplayOptions, width, height);
            this.onConfigurationChanged(recorderConfig);
        }
    }

    public final void onConfigurationChanged(@NotNull ScreenshotRecorderConfig config) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (!this.isEnabled.get() || !this.isRecording()) {
                return;
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.onConfigurationChanged(config);
            }
            Recorder recorder = this.recorder;
            if (recorder != null) {
                recorder.onConfigurationChanged(config);
            }
            if (this.lifecycle.getCurrentState$sentry_android_replay_release() != ReplayState.PAUSED) break block4;
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.pause();
            }
        }
    }

    private static final void onScreenshotRecorded$lambda$4(Ref.ObjectRef $screen, IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getScreen();
        $screen.element = string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
    }

    private static final void finalizePreviousReplay$lambda$10(ReplayIntegration this$0) {
        LinkedList linkedList;
        String string;
        Object $this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u2482;
        PersistingScopeObserver persistingScopeObserver;
        Object object;
        block12: {
            block11: {
                SentryOptions sentryOptions = this$0.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                if ((object = (persistingScopeObserver = sentryOptions.findPersistingScopeObserver())) == null) break block11;
                SentryOptions sentryOptions2 = this$0.options;
                if (sentryOptions2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions2 = null;
                }
                if ((object = (String)object.read(sentryOptions2, "replay.json", String.class)) != null) break block12;
            }
            ReplayIntegration $this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u2482 = this$0;
            boolean bl = false;
            ReplayIntegration.cleanupReplays$default($this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u2482, null, 1, null);
            return;
        }
        Object previousReplayIdString = object;
        SentryId previousReplayId = new SentryId((String)previousReplayIdString);
        if (Intrinsics.areEqual((Object)previousReplayId, (Object)SentryId.EMPTY_ID)) {
            ReplayIntegration.cleanupReplays$default(this$0, null, 1, null);
            return;
        }
        SentryOptions sentryOptions = this$0.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        LastSegmentData lastSegmentData = ReplayCache.Companion.fromDisk$sentry_android_replay_release(sentryOptions, previousReplayId, this$0.replayCacheProvider);
        if (lastSegmentData == null) {
            ReplayIntegration $this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u249 = this$0;
            boolean bl = false;
            ReplayIntegration.cleanupReplays$default($this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u249, null, 1, null);
            return;
        }
        LastSegmentData lastSegment = lastSegmentData;
        SentryOptions sentryOptions3 = this$0.options;
        if (sentryOptions3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions3 = null;
        }
        List breadcrumbs = ($this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u2482 = persistingScopeObserver.read(sentryOptions3, "breadcrumbs.json", List.class)) instanceof List ? (List)$this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u2482 : null;
        CaptureStrategy.Companion $this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u249 = CaptureStrategy.Companion;
        IScopes iScopes = this$0.scopes;
        SentryOptions sentryOptions4 = this$0.options;
        if (sentryOptions4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions4 = null;
        }
        SentryOptions sentryOptions5 = sentryOptions4;
        long l = lastSegment.getDuration();
        Date date = lastSegment.getTimestamp();
        int n = lastSegment.getId();
        int n2 = lastSegment.getRecorderConfig().getRecordingHeight();
        int n3 = lastSegment.getRecorderConfig().getRecordingWidth();
        int n4 = lastSegment.getRecorderConfig().getFrameRate();
        int n5 = lastSegment.getRecorderConfig().getBitRate();
        ReplayCache replayCache = lastSegment.getCache();
        SentryReplayEvent.ReplayType replayType = lastSegment.getReplayType();
        CaptureStrategy.ReplaySegment segment = $this$finalizePreviousReplay_u24lambda_u2410_u24lambda_u249.createSegment(iScopes, sentryOptions5, l, date, previousReplayId, n, n2, n3, replayType, replayCache, n4, n5, string = lastSegment.getScreenAtStart(), breadcrumbs, linkedList = new LinkedList(lastSegment.getEvents()));
        if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
            Hint hint = HintUtils.createWithTypeCheckHint((Object)new PreviousReplayHint());
            CaptureStrategy.ReplaySegment.Created created = (CaptureStrategy.ReplaySegment.Created)segment;
            IScopes iScopes2 = this$0.scopes;
            Intrinsics.checkNotNull((Object)hint);
            created.capture(iScopes2, hint);
        }
        this$0.cleanupReplays((String)previousReplayIdString);
    }

    public static final /* synthetic */ CaptureStrategy access$getCaptureStrategy$p(ReplayIntegration $this) {
        return $this.captureStrategy;
    }

    public static final /* synthetic */ void access$checkCanRecord(ReplayIntegration $this) {
        $this.checkCanRecord();
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-replay", "8.23.0");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/sentry/android/replay/ReplayIntegration$Companion;", "", "()V", "sentry-android-replay_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/ReplayIntegration$PreviousReplayHint;", "Lio/sentry/hints/Backfillable;", "()V", "shouldEnrich", "", "sentry-android-replay_release"})
    private static final class PreviousReplayHint
    implements Backfillable {
        public boolean shouldEnrich() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/ReplayIntegration$ReplayExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class ReplayExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayIntegration-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

