/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.viewhierarchy;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.SentryOptions;
import io.sentry.android.replay.R;
import io.sentry.android.replay.util.AndroidTextLayout;
import io.sentry.android.replay.util.TextLayout;
import io.sentry.android.replay.util.ViewsKt;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u0000 32\u00020\u0001:\u000534567Bm\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0002J\u000e\u0010,\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\fJ\u001a\u00100\u001a\u00020.2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f02R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001b\u0082\u0001\u000389:\u00a8\u0006;"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "", "x", "", "y", "width", "", "height", "elevation", "distance", "parent", "shouldMask", "", "isImportantForContentCapture", "isVisible", "visibleRect", "Landroid/graphics/Rect;", "(FFIIFILio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;ZZZLandroid/graphics/Rect;)V", "children", "", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "getDistance", "()I", "getElevation", "()F", "getHeight", "()Z", "setImportantForContentCapture", "(Z)V", "getParent", "()Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "getShouldMask", "getVisibleRect", "()Landroid/graphics/Rect;", "getWidth", "getX", "getY", "findLCA", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$LCAResult;", "node", "otherNode", "isObscured", "setImportantForCaptureToAncestors", "", "isImportant", "traverse", "callback", "Lkotlin/Function1;", "Companion", "GenericViewHierarchyNode", "ImageViewHierarchyNode", "LCAResult", "TextViewHierarchyNode", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$GenericViewHierarchyNode;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$ImageViewHierarchyNode;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$TextViewHierarchyNode;", "sentry-android-replay_release"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nViewHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ViewHierarchyNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1855#2,2:392\n*S KotlinDebug\n*F\n+ 1 ViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ViewHierarchyNode\n*L\n149#1:392,2\n*E\n"})
public abstract class ViewHierarchyNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final int width;
    private final int height;
    private final float elevation;
    private final int distance;
    @Nullable
    private final ViewHierarchyNode parent;
    private final boolean shouldMask;
    private boolean isImportantForContentCapture;
    private final boolean isVisible;
    @Nullable
    private final Rect visibleRect;
    @Nullable
    private List<? extends ViewHierarchyNode> children;
    public static final int $stable = 8;
    @NotNull
    private static final String SENTRY_UNMASK_TAG = "sentry-unmask";
    @NotNull
    private static final String SENTRY_MASK_TAG = "sentry-mask";

    private ViewHierarchyNode(float x, float y, int width, int height, float elevation, int distance, ViewHierarchyNode parent, boolean shouldMask, boolean isImportantForContentCapture, boolean isVisible, Rect visibleRect) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.elevation = elevation;
        this.distance = distance;
        this.parent = parent;
        this.shouldMask = shouldMask;
        this.isImportantForContentCapture = isImportantForContentCapture;
        this.isVisible = isVisible;
        this.visibleRect = visibleRect;
    }

    public /* synthetic */ ViewHierarchyNode(float f, float f2, int n, int n2, float f3, int n3, ViewHierarchyNode viewHierarchyNode, boolean bl, boolean bl2, boolean bl3, Rect rect, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x40) != 0) {
            viewHierarchyNode = null;
        }
        if ((n4 & 0x80) != 0) {
            bl = false;
        }
        if ((n4 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x200) != 0) {
            bl3 = false;
        }
        if ((n4 & 0x400) != 0) {
            rect = null;
        }
        this(f, f2, n, n2, f3, n3, viewHierarchyNode, bl, bl2, bl3, rect, null);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float getElevation() {
        return this.elevation;
    }

    public final int getDistance() {
        return this.distance;
    }

    @Nullable
    public final ViewHierarchyNode getParent() {
        return this.parent;
    }

    public final boolean getShouldMask() {
        return this.shouldMask;
    }

    public final boolean isImportantForContentCapture() {
        return this.isImportantForContentCapture;
    }

    public final void setImportantForContentCapture(boolean bl) {
        this.isImportantForContentCapture = bl;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    @Nullable
    public final Rect getVisibleRect() {
        return this.visibleRect;
    }

    @Nullable
    public final List<ViewHierarchyNode> getChildren() {
        return this.children;
    }

    public final void setChildren(@Nullable List<? extends ViewHierarchyNode> list) {
        this.children = list;
    }

    public final void setImportantForCaptureToAncestors(boolean isImportant) {
        ViewHierarchyNode parent = this.parent;
        while (parent != null) {
            parent.isImportantForContentCapture = isImportant;
            parent = parent.parent;
        }
    }

    public final void traverse(@NotNull Function1<? super ViewHierarchyNode, Boolean> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean traverseChildren = (Boolean)callback.invoke((Object)this);
        if (traverseChildren && this.children != null) {
            List<? extends ViewHierarchyNode> list = this.children;
            Intrinsics.checkNotNull(list);
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewHierarchyNode it = (ViewHierarchyNode)element$iv;
                boolean bl = false;
                it.traverse(callback);
            }
        }
    }

    public final boolean isObscured(@NotNull ViewHierarchyNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(this.parent == null)) {
            boolean bl = false;
            String string = "This method should be called on the root node of the view hierarchy.";
            throw new IllegalArgumentException(string.toString());
        }
        if (node.visibleRect == null) {
            return false;
        }
        Ref.BooleanRef isObscured2 = new Ref.BooleanRef();
        this.traverse((Function1<? super ViewHierarchyNode, Boolean>)((Function1)new Function1<ViewHierarchyNode, Boolean>(isObscured2, node, this){
            final /* synthetic */ Ref.BooleanRef $isObscured;
            final /* synthetic */ ViewHierarchyNode $node;
            final /* synthetic */ ViewHierarchyNode this$0;
            {
                this.$isObscured = $isObscured;
                this.$node = $node;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ViewHierarchyNode otherNode) {
                Intrinsics.checkNotNullParameter((Object)otherNode, (String)"otherNode");
                if (otherNode.getVisibleRect() == null || this.$isObscured.element) {
                    return false;
                }
                if (!(otherNode.isVisible() && otherNode.isImportantForContentCapture() && otherNode.getVisibleRect().contains(this.$node.getVisibleRect()))) {
                    return false;
                }
                if (otherNode.getElevation() > this.$node.getElevation()) {
                    this.$isObscured.element = true;
                    return false;
                }
                if (otherNode.getElevation() == this.$node.getElevation()) {
                    LCAResult lCAResult = ViewHierarchyNode.access$findLCA(this.this$0, this.$node, otherNode);
                    ViewHierarchyNode lca = lCAResult.component1();
                    ViewHierarchyNode nodeAncestor = lCAResult.component2();
                    ViewHierarchyNode otherNodeAncestor = lCAResult.component3();
                    if (!Intrinsics.areEqual((Object)lca, (Object)otherNode) && otherNodeAncestor != null && nodeAncestor != null) {
                        this.$isObscured.element = otherNodeAncestor.getDistance() > nodeAncestor.getDistance();
                        return !this.$isObscured.element;
                    }
                }
                return true;
            }
        }));
        return isObscured2.element;
    }

    private final LCAResult findLCA(ViewHierarchyNode node, ViewHierarchyNode otherNode) {
        ViewHierarchyNode nodeSubtree = null;
        ViewHierarchyNode otherNodeSubtree = null;
        ViewHierarchyNode lca = null;
        if (Intrinsics.areEqual((Object)this, (Object)node)) {
            nodeSubtree = this;
        }
        if (Intrinsics.areEqual((Object)this, (Object)otherNode)) {
            otherNodeSubtree = this;
        }
        if (this.children != null) {
            List<? extends ViewHierarchyNode> list = this.children;
            Intrinsics.checkNotNull(list);
            for (ViewHierarchyNode viewHierarchyNode : list) {
                LCAResult result = viewHierarchyNode.findLCA(node, otherNode);
                if (result.getLca() != null) {
                    return result;
                }
                if (result.getNodeSubtree() != null) {
                    nodeSubtree = viewHierarchyNode;
                }
                if (result.getOtherNodeSubtree() == null) continue;
                otherNodeSubtree = viewHierarchyNode;
            }
        }
        if (nodeSubtree != null && otherNodeSubtree != null) {
            lca = this;
        }
        return new LCAResult(lca, nodeSubtree, otherNodeSubtree);
    }

    public /* synthetic */ ViewHierarchyNode(float x, float y, int width, int height, float elevation, int distance, ViewHierarchyNode parent, boolean shouldMask, boolean isImportantForContentCapture, boolean isVisible, Rect visibleRect, DefaultConstructorMarker $constructor_marker) {
        this(x, y, width, height, elevation, distance, parent, shouldMask, isImportantForContentCapture, isVisible, visibleRect);
    }

    public static final /* synthetic */ LCAResult access$findLCA(ViewHierarchyNode $this, ViewHierarchyNode node, ViewHierarchyNode otherNode) {
        return $this.findLCA(node, otherNode);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0010*\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$Companion;", "", "()V", "SENTRY_MASK_TAG", "", "SENTRY_UNMASK_TAG", "fromView", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "view", "Landroid/view/View;", "parent", "distance", "", "options", "Lio/sentry/SentryOptions;", "isAssignableFrom", "", "Ljava/lang/Class;", "set", "", "isMaskContainer", "isUnmaskContainer", "Landroid/view/ViewParent;", "shouldMask", "sentry-android-replay_release"})
    @SourceDebugExtension(value={"SMAP\nViewHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAssignableFrom(Class<?> $this$isAssignableFrom, Set<String> set) {
            for (Class<?> cls = $this$isAssignableFrom; cls != null; cls = cls.getSuperclass()) {
                String canonicalName = cls.getName();
                if (!set.contains(canonicalName)) continue;
                return true;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean shouldMask(View $this$shouldMask, SentryOptions options) {
            var3_3 = $this$shouldMask.getTag();
            v0 = var3_3 instanceof String != false ? (String)var3_3 : null;
            if (v0 == null) ** GOTO lbl-1000
            v1 = v0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            v0 = v1;
            if (v1 != null) {
                v2 = StringsKt.contains$default((CharSequence)v0, (CharSequence)"sentry-unmask", (boolean)false, (int)2, null);
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (v2 || Intrinsics.areEqual((Object)$this$shouldMask.getTag(R.id.sentry_privacy), (Object)"unmask")) {
                return false;
            }
            var3_3 = $this$shouldMask.getTag();
            v3 = var3_3 instanceof String != false ? (String)var3_3 : null;
            if (v3 == null) ** GOTO lbl-1000
            v4 = v3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toLowerCase(...)");
            v3 = v4;
            if (v4 != null) {
                v5 = StringsKt.contains$default((CharSequence)v3, (CharSequence)"sentry-mask", (boolean)false, (int)2, null);
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            if (v5 || Intrinsics.areEqual((Object)$this$shouldMask.getTag(R.id.sentry_privacy), (Object)"mask")) {
                return true;
            }
            if (!this.isMaskContainer($this$shouldMask, options) && $this$shouldMask.getParent() != null) {
                v6 = $this$shouldMask.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"this.parent");
                if (this.isUnmaskContainer(v6, options)) {
                    return false;
                }
            }
            v7 = $this$shouldMask.getClass();
            v8 = options.getSessionReplay().getUnmaskViewClasses();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"options.sessionReplay.unmaskViewClasses");
            if (this.isAssignableFrom(v7, v8)) {
                return false;
            }
            v9 = $this$shouldMask.getClass();
            v10 = options.getSessionReplay().getMaskViewClasses();
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"options.sessionReplay.maskViewClasses");
            return this.isAssignableFrom(v9, v10);
        }

        private final boolean isUnmaskContainer(ViewParent $this$isUnmaskContainer, SentryOptions options) {
            String string = options.getSessionReplay().getUnmaskViewContainerClass();
            if (string == null) {
                return false;
            }
            String unmaskContainer = string;
            return Intrinsics.areEqual((Object)$this$isUnmaskContainer.getClass().getName(), (Object)unmaskContainer);
        }

        private final boolean isMaskContainer(View $this$isMaskContainer, SentryOptions options) {
            String string = options.getSessionReplay().getMaskViewContainerClass();
            if (string == null) {
                return false;
            }
            String maskContainer = string;
            return Intrinsics.areEqual((Object)$this$isMaskContainer.getClass().getName(), (Object)maskContainer);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final ViewHierarchyNode fromView(@NotNull View view, @Nullable ViewHierarchyNode parent, int distance, @NotNull SentryOptions options) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                var5_5 = ViewsKt.isVisibleToUser(view);
                isVisible = (Boolean)var5_5.component1();
                visibleRect = (Rect)var5_5.component2();
                shouldMask = isVisible != false && this.shouldMask(view, options) != false;
                var9_9 = view;
                if (var9_9 instanceof TextView) {
                    v0 = parent;
                    if (v0 != null) {
                        v0.setImportantForCaptureToAncestors(true);
                    }
                    v1 = ((TextView)view).getLayout();
                    if (v1 != null) {
                        it = v1;
                        $i$a$-let-ViewHierarchyNode$Companion$fromView$1 = false;
                        v2 = new AndroidTextLayout(it);
                    } else {
                        v2 = null;
                    }
                    var10_16 = v2;
                    var11_18 = ViewsKt.toOpaque(((TextView)view).getCurrentTextColor());
                    var12_20 = ((TextView)view).getTotalPaddingLeft();
                    var13_11 = ViewsKt.getTotalPaddingTopSafe((TextView)view);
                    var14_14 = ((TextView)view).getX();
                    var15_22 = ((TextView)view).getY();
                    var16_24 = ((TextView)view).getWidth();
                    var17_25 = ((TextView)view).getHeight();
                    v3 = parent;
                    var18_26 = (v3 != null ? v3.getElevation() : 0.0f) + ((TextView)view).getElevation();
                    return new TextViewHierarchyNode(var10_16, var11_18, var12_20, var13_11, var14_14, var15_22, var16_24, var17_25, var18_26, distance, parent, shouldMask, true, isVisible, visibleRect);
                }
                if (!(var9_9 instanceof ImageView)) break block7;
                v4 = parent;
                if (v4 != null) {
                    v4.setImportantForCaptureToAncestors(true);
                }
                var10_17 = ((ImageView)view).getX();
                var11_19 = ((ImageView)view).getY();
                var12_21 = ((ImageView)view).getWidth();
                var13_12 = ((ImageView)view).getHeight();
                v5 = parent;
                var14_15 = (v5 != null ? v5.getElevation() : 0.0f) + ((ImageView)view).getElevation();
                if (!shouldMask) ** GOTO lbl-1000
                v6 = ((ImageView)view).getDrawable();
                v7 = v6 != null ? ViewsKt.isMaskable(v6) : false;
                if (v7) {
                    v8 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v8 = false;
                }
                var15_23 = v8;
                return new ImageViewHierarchyNode(var10_17, var11_19, var12_21, var13_12, var14_15, distance, parent, var15_23, true, isVisible, visibleRect);
            }
            v9 = parent;
            return new GenericViewHierarchyNode(view.getX(), view.getY(), view.getWidth(), view.getHeight(), (v9 != null ? v9.getElevation() : 0.0f) + view.getElevation(), distance, parent, shouldMask, false, isVisible, visibleRect);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$GenericViewHierarchyNode;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "x", "", "y", "width", "", "height", "elevation", "distance", "parent", "shouldMask", "", "isImportantForContentCapture", "isVisible", "visibleRect", "Landroid/graphics/Rect;", "(FFIIFILio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;ZZZLandroid/graphics/Rect;)V", "sentry-android-replay_release"})
    @StabilityInferred(parameters=1)
    public static final class GenericViewHierarchyNode
    extends ViewHierarchyNode {
        public static final int $stable;

        public GenericViewHierarchyNode(float x, float y, int width, int height, float elevation, int distance, @Nullable ViewHierarchyNode parent, boolean shouldMask, boolean isImportantForContentCapture, boolean isVisible, @Nullable Rect visibleRect) {
            super(x, y, width, height, elevation, distance, parent, shouldMask, isImportantForContentCapture, isVisible, visibleRect, null);
        }

        public /* synthetic */ GenericViewHierarchyNode(float f, float f2, int n, int n2, float f3, int n3, ViewHierarchyNode viewHierarchyNode, boolean bl, boolean bl2, boolean bl3, Rect rect, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x40) != 0) {
                viewHierarchyNode = null;
            }
            if ((n4 & 0x80) != 0) {
                bl = false;
            }
            if ((n4 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n4 & 0x200) != 0) {
                bl3 = false;
            }
            if ((n4 & 0x400) != 0) {
                rect = null;
            }
            this(f, f2, n, n2, f3, n3, viewHierarchyNode, bl, bl2, bl3, rect);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$ImageViewHierarchyNode;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "x", "", "y", "width", "", "height", "elevation", "distance", "parent", "shouldMask", "", "isImportantForContentCapture", "isVisible", "visibleRect", "Landroid/graphics/Rect;", "(FFIIFILio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;ZZZLandroid/graphics/Rect;)V", "sentry-android-replay_release"})
    @StabilityInferred(parameters=1)
    public static final class ImageViewHierarchyNode
    extends ViewHierarchyNode {
        public static final int $stable;

        public ImageViewHierarchyNode(float x, float y, int width, int height, float elevation, int distance, @Nullable ViewHierarchyNode parent, boolean shouldMask, boolean isImportantForContentCapture, boolean isVisible, @Nullable Rect visibleRect) {
            super(x, y, width, height, elevation, distance, parent, shouldMask, isImportantForContentCapture, isVisible, visibleRect, null);
        }

        public /* synthetic */ ImageViewHierarchyNode(float f, float f2, int n, int n2, float f3, int n3, ViewHierarchyNode viewHierarchyNode, boolean bl, boolean bl2, boolean bl3, Rect rect, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x40) != 0) {
                viewHierarchyNode = null;
            }
            if ((n4 & 0x80) != 0) {
                bl = false;
            }
            if ((n4 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n4 & 0x200) != 0) {
                bl3 = false;
            }
            if ((n4 & 0x400) != 0) {
                rect = null;
            }
            this(f, f2, n, n2, f3, n3, viewHierarchyNode, bl, bl2, bl3, rect);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$LCAResult;", "", "lca", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "nodeSubtree", "otherNodeSubtree", "(Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;)V", "getLca", "()Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "getNodeSubtree", "setNodeSubtree", "(Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;)V", "getOtherNodeSubtree", "setOtherNodeSubtree", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sentry-android-replay_release"})
    private static final class LCAResult {
        @Nullable
        private final ViewHierarchyNode lca;
        @Nullable
        private ViewHierarchyNode nodeSubtree;
        @Nullable
        private ViewHierarchyNode otherNodeSubtree;

        public LCAResult(@Nullable ViewHierarchyNode lca, @Nullable ViewHierarchyNode nodeSubtree, @Nullable ViewHierarchyNode otherNodeSubtree) {
            this.lca = lca;
            this.nodeSubtree = nodeSubtree;
            this.otherNodeSubtree = otherNodeSubtree;
        }

        @Nullable
        public final ViewHierarchyNode getLca() {
            return this.lca;
        }

        @Nullable
        public final ViewHierarchyNode getNodeSubtree() {
            return this.nodeSubtree;
        }

        public final void setNodeSubtree(@Nullable ViewHierarchyNode viewHierarchyNode) {
            this.nodeSubtree = viewHierarchyNode;
        }

        @Nullable
        public final ViewHierarchyNode getOtherNodeSubtree() {
            return this.otherNodeSubtree;
        }

        public final void setOtherNodeSubtree(@Nullable ViewHierarchyNode viewHierarchyNode) {
            this.otherNodeSubtree = viewHierarchyNode;
        }

        @Nullable
        public final ViewHierarchyNode component1() {
            return this.lca;
        }

        @Nullable
        public final ViewHierarchyNode component2() {
            return this.nodeSubtree;
        }

        @Nullable
        public final ViewHierarchyNode component3() {
            return this.otherNodeSubtree;
        }

        @NotNull
        public final LCAResult copy(@Nullable ViewHierarchyNode lca, @Nullable ViewHierarchyNode nodeSubtree, @Nullable ViewHierarchyNode otherNodeSubtree) {
            return new LCAResult(lca, nodeSubtree, otherNodeSubtree);
        }

        public static /* synthetic */ LCAResult copy$default(LCAResult lCAResult, ViewHierarchyNode viewHierarchyNode, ViewHierarchyNode viewHierarchyNode2, ViewHierarchyNode viewHierarchyNode3, int n, Object object) {
            if ((n & 1) != 0) {
                viewHierarchyNode = lCAResult.lca;
            }
            if ((n & 2) != 0) {
                viewHierarchyNode2 = lCAResult.nodeSubtree;
            }
            if ((n & 4) != 0) {
                viewHierarchyNode3 = lCAResult.otherNodeSubtree;
            }
            return lCAResult.copy(viewHierarchyNode, viewHierarchyNode2, viewHierarchyNode3);
        }

        @NotNull
        public String toString() {
            return "LCAResult(lca=" + this.lca + ", nodeSubtree=" + this.nodeSubtree + ", otherNodeSubtree=" + this.otherNodeSubtree + ')';
        }

        public int hashCode() {
            int result = this.lca == null ? 0 : this.lca.hashCode();
            result = result * 31 + (this.nodeSubtree == null ? 0 : this.nodeSubtree.hashCode());
            result = result * 31 + (this.otherNodeSubtree == null ? 0 : this.otherNodeSubtree.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LCAResult)) {
                return false;
            }
            LCAResult lCAResult = (LCAResult)other;
            if (!Intrinsics.areEqual((Object)this.lca, (Object)lCAResult.lca)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nodeSubtree, (Object)lCAResult.nodeSubtree)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherNodeSubtree, (Object)lCAResult.otherNodeSubtree);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0097\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode$TextViewHierarchyNode;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "layout", "Lio/sentry/android/replay/util/TextLayout;", "dominantColor", "", "paddingLeft", "paddingTop", "x", "", "y", "width", "height", "elevation", "distance", "parent", "shouldMask", "", "isImportantForContentCapture", "isVisible", "visibleRect", "Landroid/graphics/Rect;", "(Lio/sentry/android/replay/util/TextLayout;Ljava/lang/Integer;IIFFIIFILio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;ZZZLandroid/graphics/Rect;)V", "getDominantColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLayout", "()Lio/sentry/android/replay/util/TextLayout;", "getPaddingLeft", "()I", "getPaddingTop", "sentry-android-replay_release"})
    @StabilityInferred(parameters=0)
    public static final class TextViewHierarchyNode
    extends ViewHierarchyNode {
        @Nullable
        private final TextLayout layout;
        @Nullable
        private final Integer dominantColor;
        private final int paddingLeft;
        private final int paddingTop;
        public static final int $stable = 8;

        public TextViewHierarchyNode(@Nullable TextLayout layout, @Nullable Integer dominantColor, int paddingLeft, int paddingTop, float x, float y, int width, int height, float elevation, int distance, @Nullable ViewHierarchyNode parent, boolean shouldMask, boolean isImportantForContentCapture, boolean isVisible, @Nullable Rect visibleRect) {
            super(x, y, width, height, elevation, distance, parent, shouldMask, isImportantForContentCapture, isVisible, visibleRect, null);
            this.layout = layout;
            this.dominantColor = dominantColor;
            this.paddingLeft = paddingLeft;
            this.paddingTop = paddingTop;
        }

        public /* synthetic */ TextViewHierarchyNode(TextLayout textLayout, Integer n, int n2, int n3, float f, float f2, int n4, int n5, float f3, int n6, ViewHierarchyNode viewHierarchyNode, boolean bl, boolean bl2, boolean bl3, Rect rect, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                textLayout = null;
            }
            if ((n7 & 2) != 0) {
                n = null;
            }
            if ((n7 & 4) != 0) {
                n2 = 0;
            }
            if ((n7 & 8) != 0) {
                n3 = 0;
            }
            if ((n7 & 0x400) != 0) {
                viewHierarchyNode = null;
            }
            if ((n7 & 0x800) != 0) {
                bl = false;
            }
            if ((n7 & 0x1000) != 0) {
                bl2 = false;
            }
            if ((n7 & 0x2000) != 0) {
                bl3 = false;
            }
            if ((n7 & 0x4000) != 0) {
                rect = null;
            }
            this(textLayout, n, n2, n3, f, f2, n4, n5, f3, n6, viewHierarchyNode, bl, bl2, bl3, rect);
        }

        @Nullable
        public final TextLayout getLayout() {
            return this.layout;
        }

        @Nullable
        public final Integer getDominantColor() {
            return this.dominantColor;
        }

        public final int getPaddingLeft() {
            return this.paddingLeft;
        }

        public final int getPaddingTop() {
            return this.paddingTop;
        }
    }
}

