/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryOptions;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowCallback;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.util.AutoClosableReentrantLock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u0000 22\u00020\u00012\u00020\u0002:\u000223B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001fJ\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020$H\u0016J\b\u0010/\u001a\u00020$H\u0016J\b\u00100\u001a\u00020$H\u0016J\b\u00101\u001a\u00020$H\u0016R#\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001dj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/sentry/android/replay/WindowRecorder;", "Lio/sentry/android/replay/Recorder;", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "windowCallback", "Lio/sentry/android/replay/WindowCallback;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "replayExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/android/replay/WindowCallback;Lio/sentry/android/replay/util/MainLooperHandler;Ljava/util/concurrent/ScheduledExecutorService;)V", "capturer", "kotlin.jvm.PlatformType", "getCapturer", "()Ljava/util/concurrent/ScheduledExecutorService;", "capturer$delegate", "Lkotlin/Lazy;", "capturingTask", "Ljava/util/concurrent/ScheduledFuture;", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastKnownWindowSize", "Landroid/graphics/Point;", "recorder", "Lio/sentry/android/replay/ScreenshotRecorder;", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "rootViewsLock", "Lio/sentry/util/AutoClosableReentrantLock;", "close", "", "determineWindowSize", "root", "onConfigurationChanged", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "onRootViewsChanged", "added", "", "pause", "reset", "resume", "start", "stop", "Companion", "RecorderExecutorServiceThreadFactory", "sentry-android-replay_release"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWindowRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1855#2,2:169\n*S KotlinDebug\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n*L\n140#1:169,2\n*E\n"})
public final class WindowRecorder
implements Recorder,
OnRootViewsChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final WindowCallback windowCallback;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final ScheduledExecutorService replayExecutor;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    @NotNull
    private Point lastKnownWindowSize;
    @NotNull
    private final AutoClosableReentrantLock rootViewsLock;
    @Nullable
    private ScreenshotRecorder recorder;
    @Nullable
    private ScheduledFuture<?> capturingTask;
    @NotNull
    private final Lazy capturer$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "WindowRecorder";

    public WindowRecorder(@NotNull SentryOptions options, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull WindowCallback windowCallback, @NotNull MainLooperHandler mainLooperHandler, @NotNull ScheduledExecutorService replayExecutor2) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)windowCallback, (String)"windowCallback");
        Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
        Intrinsics.checkNotNullParameter((Object)replayExecutor2, (String)"replayExecutor");
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.windowCallback = windowCallback;
        this.mainLooperHandler = mainLooperHandler;
        this.replayExecutor = replayExecutor2;
        this.isRecording = new AtomicBoolean(false);
        this.rootViews = new ArrayList();
        this.lastKnownWindowSize = new Point();
        this.rootViewsLock = new AutoClosableReentrantLock();
        this.capturer$delegate = LazyKt.lazy((Function0)capturer.2.INSTANCE);
    }

    public /* synthetic */ WindowRecorder(SentryOptions sentryOptions, ScreenshotRecorderCallback screenshotRecorderCallback, WindowCallback windowCallback, MainLooperHandler mainLooperHandler, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            screenshotRecorderCallback = null;
        }
        this(sentryOptions, screenshotRecorderCallback, windowCallback, mainLooperHandler, scheduledExecutorService);
    }

    private final ScheduledExecutorService getCapturer() {
        Lazy lazy = this.capturer$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRootViewsChanged(@NotNull View root, boolean added) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        AutoCloseable autoCloseable = (AutoCloseable)this.rootViewsLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            if (added) {
                this.rootViews.add(new WeakReference<View>(root));
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.bind(root);
                }
                this.determineWindowSize(root);
            } else {
                View newRoot;
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.unbind(root);
                }
                CollectionsKt.removeAll((List)this.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                    final /* synthetic */ View $root;
                    {
                        this.$root = $root;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull WeakReference<View> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return Intrinsics.areEqual(it.get(), (Object)this.$root);
                    }
                }));
                WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this.rootViews);
                Object object = newRoot = weakReference != null ? (View)weakReference.get() : null;
                if (newRoot != null && !Intrinsics.areEqual((Object)root, (Object)newRoot)) {
                    ScreenshotRecorder screenshotRecorder2 = this.recorder;
                    if (screenshotRecorder2 != null) {
                        screenshotRecorder2.bind(newRoot);
                    }
                    this.determineWindowSize(newRoot);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void determineWindowSize(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (ViewsKt.hasSize(root)) {
            if (root.getWidth() != this.lastKnownWindowSize.x && root.getHeight() != this.lastKnownWindowSize.y) {
                this.lastKnownWindowSize.set(root.getWidth(), root.getHeight());
                this.windowCallback.onWindowSizeChanged(root.getWidth(), root.getHeight());
            }
        } else {
            ViewsKt.addOnPreDrawListenerSafe(root, new ViewTreeObserver.OnPreDrawListener(this, root){
                final /* synthetic */ WindowRecorder this$0;
                final /* synthetic */ View $root;
                {
                    this.this$0 = $receiver;
                    this.$root = $root;
                }

                public boolean onPreDraw() {
                    View currentRoot;
                    WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)WindowRecorder.access$getRootViews$p(this.this$0));
                    Object object = currentRoot = weakReference != null ? (View)weakReference.get() : null;
                    if (!Intrinsics.areEqual((Object)this.$root, (Object)currentRoot)) {
                        ViewsKt.removeOnPreDrawListenerSafe(this.$root, this);
                        return true;
                    }
                    if (ViewsKt.hasSize(this.$root)) {
                        ViewsKt.removeOnPreDrawListenerSafe(this.$root, this);
                        if (this.$root.getWidth() != WindowRecorder.access$getLastKnownWindowSize$p((WindowRecorder)this.this$0).x && this.$root.getHeight() != WindowRecorder.access$getLastKnownWindowSize$p((WindowRecorder)this.this$0).y) {
                            WindowRecorder.access$getLastKnownWindowSize$p(this.this$0).set(this.$root.getWidth(), this.$root.getHeight());
                            WindowRecorder.access$getWindowCallback$p(this.this$0).onWindowSizeChanged(this.$root.getWidth(), this.$root.getHeight());
                        }
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void start() {
        this.isRecording.getAndSet(true);
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig config) {
        View newRoot;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.isRecording.get()) {
            return;
        }
        this.recorder = new ScreenshotRecorder(config, this.options, this.mainLooperHandler, this.replayExecutor, this.screenshotRecorderCallback);
        WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this.rootViews);
        Object object = newRoot = weakReference != null ? (View)weakReference.get() : null;
        if (newRoot != null) {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.bind(newRoot);
            }
        }
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        this.capturingTask = ExecutorsKt.scheduleAtFixedRateSafely(scheduledExecutorService, this.options, "WindowRecorder.capture", 100L, 1000L / (long)config.getFrameRate(), TimeUnit.MILLISECONDS, () -> WindowRecorder.onConfigurationChanged$lambda$1(this));
    }

    @Override
    public void resume() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.resume();
        }
    }

    @Override
    public void pause() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lastKnownWindowSize.set(0, 0);
        AutoCloseable autoCloseable = (AutoCloseable)this.rootViewsLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            Iterable $this$forEach$iv = this.rootViews;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it2 = (WeakReference)element$iv;
                boolean bl2 = false;
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder == null) continue;
                screenshotRecorder.unbind((View)it2.get());
            }
            this.rootViews.clear();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void stop() {
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.close();
        }
        this.recorder = null;
        ScheduledFuture<?> scheduledFuture = this.capturingTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.capturingTask = null;
        this.isRecording.set(false);
    }

    @Override
    public void close() {
        this.reset();
        this.stop();
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        ExecutorsKt.gracefullyShutdown(scheduledExecutorService, this.options);
    }

    private static final void onConfigurationChanged$lambda$1(WindowRecorder this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.capture();
        }
    }

    public static final /* synthetic */ ArrayList access$getRootViews$p(WindowRecorder $this) {
        return $this.rootViews;
    }

    public static final /* synthetic */ Point access$getLastKnownWindowSize$p(WindowRecorder $this) {
        return $this.lastKnownWindowSize;
    }

    public static final /* synthetic */ WindowCallback access$getWindowCallback$p(WindowRecorder $this) {
        return $this.windowCallback;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/WindowRecorder$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/WindowRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryWindowRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

