/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.viewhierarchy;

import android.annotation.TargetApi;
import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.unit.TextUnit;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.SentryReplayModifiers;
import io.sentry.android.replay.util.ComposeTextLayout;
import io.sentry.android.replay.util.NodesKt;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u001c\u0010\u0017\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0018\u001a\u00020\u0019*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode;", "", "()V", "_rootCoordinates", "Ljava/lang/ref/WeakReference;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "fromComposeNode", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "node", "Landroidx/compose/ui/node/LayoutNode;", "parent", "distance", "", "isComposeRoot", "", "options", "Lio/sentry/SentryOptions;", "fromView", "view", "Landroid/view/View;", "getProxyClassName", "", "isImage", "shouldMask", "traverse", "", "parentNode", "sentry-android-replay_release"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposeViewHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,223:1\n652#2:224\n*S KotlinDebug\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n*L\n108#1:224\n*E\n"})
public final class ComposeViewHierarchyNode {
    @NotNull
    public static final ComposeViewHierarchyNode INSTANCE = new ComposeViewHierarchyNode();
    @Nullable
    private static WeakReference<LayoutCoordinates> _rootCoordinates;
    public static final int $stable;

    private ComposeViewHierarchyNode() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getProxyClassName(LayoutNode $this$getProxyClassName, boolean isImage) {
        boolean bl;
        boolean bl2;
        if (isImage) {
            return "android.widget.ImageView";
        }
        SemanticsConfiguration semanticsConfiguration = $this$getProxyClassName.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration != null) {
            if (semanticsConfiguration.contains(SemanticsProperties.INSTANCE.getText())) {
                return "android.widget.TextView";
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return "android.widget.TextView";
        SemanticsConfiguration semanticsConfiguration2 = $this$getProxyClassName.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration2 != null) {
            if (semanticsConfiguration2.contains(SemanticsActions.INSTANCE.getSetText())) {
                return "android.widget.TextView";
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return "android.widget.TextView";
        SemanticsConfiguration semanticsConfiguration3 = $this$getProxyClassName.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration3 == null) return "android.view.View";
        if (!semanticsConfiguration3.contains(SemanticsProperties.INSTANCE.getEditableText())) return "android.view.View";
        return "android.widget.TextView";
    }

    private final boolean shouldMask(LayoutNode $this$shouldMask, boolean isImage, SentryOptions options) {
        String sentryPrivacyModifier;
        SemanticsConfiguration semanticsConfiguration = $this$shouldMask.getCollapsedSemantics$ui_release();
        String string = sentryPrivacyModifier = semanticsConfiguration != null ? (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsConfiguration, SentryReplayModifiers.INSTANCE.getSentryPrivacy()) : null;
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"unmask")) {
            return false;
        }
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"mask")) {
            return true;
        }
        String className = this.getProxyClassName($this$shouldMask, isImage);
        if (options.getSessionReplay().getUnmaskViewClasses().contains(className)) {
            return false;
        }
        return options.getSessionReplay().getMaskViewClasses().contains(className);
    }

    /*
     * Unable to fully structure code
     */
    private final ViewHierarchyNode fromComposeNode(LayoutNode node, ViewHierarchyNode parent, int distance, boolean isComposeRoot, SentryOptions options) {
        v0 = isInTree = node.isPlaced() != false && node.isAttached() != false;
        if (!isInTree) {
            return null;
        }
        if (isComposeRoot) {
            ComposeViewHierarchyNode._rootCoordinates = new WeakReference<LayoutCoordinates>(LayoutCoordinatesKt.findRootCoordinates((LayoutCoordinates)node.getCoordinates()));
        }
        semantics = node.getCollapsedSemantics$ui_release();
        v1 = ComposeViewHierarchyNode._rootCoordinates;
        visibleRect = NodesKt.boundsInWindow(node.getCoordinates(), (LayoutCoordinates)(v1 != null ? (LayoutCoordinates)v1.get() : null));
        isVisible = node.getOuterCoordinator$ui_release().isTransparent() == false && (semantics == null || semantics.contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) == false) && visibleRect.height() > 0 && visibleRect.width() > 0;
        v2 = semantics;
        if (v2 != null ? v2.contains(SemanticsActions.INSTANCE.getSetText()) : false) ** GOTO lbl-1000
        v3 = semantics;
        v4 = v3 != null ? v3.contains(SemanticsProperties.INSTANCE.getEditableText()) : false;
        if (v4) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        isEditable = v5;
        v6 = semantics;
        v7 = v6 != null ? v6.contains(SemanticsProperties.INSTANCE.getText()) : false;
        if (v7 || isEditable) {
            shouldMask = isVisible != false && this.shouldMask(node, false, options) != false;
            v8 = parent;
            if (v8 != null) {
                v8.setImportantForCaptureToAncestors(true);
            }
            textLayoutResults = new ArrayList<E>();
            if (semantics != null && (var13_16 = (AccessibilityAction)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semantics, (SemanticsPropertyKey)SemanticsActions.INSTANCE.getGetTextLayoutResult())) != null && (var14_18 = (Function1)var13_16.getAction()) != null) {
                (Boolean)var14_18.invoke((Object)textLayoutResults);
            }
            var13_16 = NodesKt.findTextAttributes(node);
            color = var13_16.component1-QN2ZGVo();
            hasFillModifier = var13_16.component2();
            textLayoutResult = (TextLayoutResult)CollectionsKt.firstOrNull((List)textLayoutResults);
            v9 = textLayoutResult;
            v10 = textColor = v9 != null && (v9 = v9.getLayoutInput()) != null && (v9 = v9.getStyle()) != null ? Color.box-impl((long)v9.getColor-0d7_KjU()) : null;
            if (v10 != null) {
                $this$isUnspecified$iv = v10.unbox-impl();
                $i$f$isUnspecified-8_81llA = false;
                v11 = $this$isUnspecified$iv == Color.Companion.getUnspecified-0d7_KjU();
            } else {
                v11 = false;
            }
            if (v11) {
                textColor = color;
            }
            var19_27 = (v12 = textLayoutResult) != null && (v12 = v12.getLayoutInput()) != null && (v12 = v12.getStyle()) != null ? TextUnit.box-impl((long)v12.getFontSize-XSAIIZE()) : null;
            var20_29 = TextUnit.Companion.getUnspecified-XSAIIZE();
            v13 = var19_27;
            isLaidOut = (v13 == null ? false : TextUnit.equals-impl0((long)v13.unbox-impl(), (long)var20_29)) == false;
            v14 = textColor;
            v15 = parent;
            v16 = new ViewHierarchyNode.TextViewHierarchyNode(textLayoutResult != null && isEditable == false && isLaidOut != false ? new ComposeTextLayout(textLayoutResult, hasFillModifier) : null, v14 != null ? Integer.valueOf(ViewsKt.toOpaque(ColorKt.toArgb-8_81llA((long)v14.unbox-impl()))) : null, 0, 0, visibleRect.left, visibleRect.top, node.getWidth(), node.getHeight(), v15 != null ? v15.getElevation() : 0.0f, distance, parent, shouldMask, true, isVisible, visibleRect, 12, null);
        } else {
            painter = NodesKt.findPainter(node);
            if (painter != null) {
                shouldMask = isVisible != false && this.shouldMask(node, true, options) != false;
                v17 = parent;
                if (v17 != null) {
                    v17.setImportantForCaptureToAncestors(true);
                }
                var13_17 = visibleRect.left;
                var14_19 = visibleRect.top;
                var15_21 = node.getWidth();
                var16_23 = node.getHeight();
                v18 = parent;
                var17_25 = v18 != null ? v18.getElevation() : 0.0f;
                var18_31 = shouldMask != false && NodesKt.isMaskable(painter) != false;
                v16 = new ViewHierarchyNode.ImageViewHierarchyNode(var13_17, var14_19, var15_21, var16_23, var17_25, distance, parent, var18_31, true, isVisible, visibleRect);
            } else {
                shouldMask = isVisible != false && this.shouldMask(node, false, options) != false;
                v19 = parent;
                v16 = new ViewHierarchyNode.GenericViewHierarchyNode(visibleRect.left, visibleRect.top, node.getWidth(), node.getHeight(), v19 != null ? v19.getElevation() : 0.0f, distance, parent, shouldMask, false, isVisible, visibleRect);
            }
        }
        return v16;
    }

    public final boolean fromView(@NotNull View view, @Nullable ViewHierarchyNode parent, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = view.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"AndroidComposeView", (boolean)false, (int)2, null)) {
            return false;
        }
        if (parent == null) {
            return false;
        }
        try {
            Owner owner = view instanceof Owner ? (Owner)view : null;
            if (owner == null || (owner = owner.getRoot()) == null) {
                return false;
            }
            Owner rootNode = owner;
            this.traverse((LayoutNode)rootNode, parent, true, options);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, e, "Error traversing Compose tree. Most likely you're using an unsupported version of\nandroidx.compose.ui:ui. The minimum supported version is 1.5.0. If it's a newer\nversion, please open a github issue with the version you're using, so we can add\nsupport for it.", new Object[0]);
            return false;
        }
        return true;
    }

    private final void traverse(LayoutNode $this$traverse, ViewHierarchyNode parentNode, boolean isComposeRoot, SentryOptions options) {
        List children = $this$traverse.getChildren$ui_release();
        if (children.isEmpty()) {
            return;
        }
        ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(children.size());
        int n = children.size();
        for (int index = 0; index < n; ++index) {
            LayoutNode child = (LayoutNode)children.get(index);
            ViewHierarchyNode childNode = this.fromComposeNode(child, parentNode, index, isComposeRoot, options);
            if (childNode == null) continue;
            childNodes.add(childNode);
            this.traverse(child, childNode, false, options);
        }
        parentNode.setChildren((List<? extends ViewHierarchyNode>)childNodes);
    }

    static {
        $stable = 8;
    }
}

