/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.util;

import io.sentry.ISentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001aB\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a*\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a*\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0014"}, d2={"gracefullyShutdown", "", "Ljava/util/concurrent/ExecutorService;", "options", "Lio/sentry/SentryOptions;", "scheduleAtFixedRateSafely", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/ScheduledExecutorService;", "taskName", "", "initialDelay", "", "period", "unit", "Ljava/util/concurrent/TimeUnit;", "task", "Ljava/lang/Runnable;", "submitSafely", "Ljava/util/concurrent/Future;", "Lio/sentry/ISentryExecutorService;", "sentry-android-replay_release"})
public final class ExecutorsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void gracefullyShutdown(@NotNull ExecutorService $this$gracefullyShutdown, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)$this$gracefullyShutdown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ExecutorService executorService = $this$gracefullyShutdown;
        synchronized (executorService) {
            boolean bl = false;
            if (!$this$gracefullyShutdown.isShutdown()) {
                $this$gracefullyShutdown.shutdown();
            }
            try {
                if (!$this$gracefullyShutdown.awaitTermination(options.getShutdownTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                    $this$gracefullyShutdown.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                $this$gracefullyShutdown.shutdownNow();
                Thread.currentThread().interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public static final Future<?> submitSafely(@NotNull ISentryExecutorService $this$submitSafely, @NotNull SentryOptions options, @NotNull String taskName, @NotNull Runnable task) {
        Future future;
        Intrinsics.checkNotNullParameter((Object)$this$submitSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            future = $this$submitSafely.submit(() -> ExecutorsKt.submitSafely$lambda$1(task, options, taskName));
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to submit task " + taskName + " to executor", e);
            future = null;
        }
        return future;
    }

    @Nullable
    public static final Future<?> submitSafely(@NotNull ExecutorService $this$submitSafely, @NotNull SentryOptions options, @NotNull String taskName, @NotNull Runnable task) {
        Future<?> future;
        Intrinsics.checkNotNullParameter((Object)$this$submitSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentThread().name");
        if (StringsKt.startsWith$default((String)string, (String)"SentryReplayIntegration", (boolean)false, (int)2, null)) {
            task.run();
            return null;
        }
        try {
            future = $this$submitSafely.submit(() -> ExecutorsKt.submitSafely$lambda$2(task, options, taskName));
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to submit task " + taskName + " to executor", e);
            future = null;
        }
        return future;
    }

    @Nullable
    public static final ScheduledFuture<?> scheduleAtFixedRateSafely(@NotNull ScheduledExecutorService $this$scheduleAtFixedRateSafely, @NotNull SentryOptions options, @NotNull String taskName, long initialDelay, long period, @NotNull TimeUnit unit, @NotNull Runnable task) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkNotNullParameter((Object)$this$scheduleAtFixedRateSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            scheduledFuture = $this$scheduleAtFixedRateSafely.scheduleAtFixedRate(() -> ExecutorsKt.scheduleAtFixedRateSafely$lambda$3(task, options, taskName), initialDelay, period, unit);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to submit task " + taskName + " to executor", e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private static final void submitSafely$lambda$1(Runnable $task, SentryOptions $options, String $taskName) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        try {
            $task.run();
        }
        catch (Throwable e) {
            $options.getLogger().log(SentryLevel.ERROR, "Failed to execute task " + $taskName, e);
        }
    }

    private static final void submitSafely$lambda$2(Runnable $task, SentryOptions $options, String $taskName) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        try {
            $task.run();
        }
        catch (Throwable e) {
            $options.getLogger().log(SentryLevel.ERROR, "Failed to execute task " + $taskName, e);
        }
    }

    private static final void scheduleAtFixedRateSafely$lambda$3(Runnable $task, SentryOptions $options, String $taskName) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        try {
            $task.run();
        }
        catch (Throwable e) {
            $options.getLogger().log(SentryLevel.ERROR, "Failed to execute task " + $taskName, e);
        }
    }
}

