/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.ReplayRecording;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebMetaEvent;
import io.sentry.rrweb.RRWebSpanEvent;
import io.sentry.rrweb.RRWebVideoEvent;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 S2\u00020\u0001:\u0003STUBZ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012%\b\u0002\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0013JP\u00106\u001a\u0002072\u0006\u00108\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020CH\u0016JB\u0010D\u001a\u0002072\u0006\u0010>\u001a\u00020?2\u0006\u0010E\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:2\b\b\u0002\u0010@\u001a\u00020AH\u0004J\u0010\u0010F\u001a\u00020C2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010G\u001a\u00020CH\u0016J\b\u0010H\u001a\u00020CH\u0016J \u0010I\u001a\u00020C2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020CH\u0016J\f\u0010M\u001a\u00020K*\u00020NH\u0002J\f\u0010O\u001a\u00020P*\u00020PH\u0002J\f\u0010Q\u001a\u00020R*\u00020NH\u0002R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u000e0\u000e0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R+\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020\u000b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,R\u0014\u0010/\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001d\u00a8\u0006V"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "Lio/sentry/android/replay/capture/CaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Lio/sentry/android/replay/ScreenshotRecorderConfig;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;)V", "cache", "getCache", "()Lio/sentry/android/replay/ReplayCache;", "setCache", "(Lio/sentry/android/replay/ReplayCache;)V", "currentReplayId", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "getCurrentReplayId", "()Ljava/util/concurrent/atomic/AtomicReference;", "currentSegment", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentSegment", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getRecorderConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "setRecorderConfig", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "replayCacheDir", "Ljava/io/File;", "getReplayCacheDir", "()Ljava/io/File;", "replayExecutor", "getReplayExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "replayExecutor$delegate", "Lkotlin/Lazy;", "replayStartTimestamp", "Ljava/util/concurrent/atomic/AtomicLong;", "getReplayStartTimestamp", "()Ljava/util/concurrent/atomic/AtomicLong;", "segmentTimestamp", "Ljava/util/Date;", "getSegmentTimestamp", "buildReplay", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "video", "segmentId", "", "height", "width", "frameCount", "duration", "", "replayType", "Lio/sentry/SentryReplayEvent$ReplayType;", "close", "", "createSegment", "currentSegmentTimestamp", "onConfigurationChanged", "pause", "resume", "start", "cleanupOldReplays", "", "stop", "isValidForRRWebSpan", "Lio/sentry/Breadcrumb;", "snakeToCamelCase", "", "toRRWebSpanEvent", "Lio/sentry/rrweb/RRWebSpanEvent;", "Companion", "ReplayExecutorServiceThreadFactory", "ReplaySegment", "sentry-android-replay_release"})
@SourceDebugExtension(value={"SMAP\nBaseCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1045#2:340\n1855#2,2:341\n*S KotlinDebug\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy\n*L\n254#1:340\n187#1:341,2\n*E\n"})
public abstract class BaseCaptureStrategy
implements CaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private ScreenshotRecorderConfig recorderConfig;
    @Nullable
    private final Function1<SentryId, ReplayCache> replayCacheProvider;
    @Nullable
    private ReplayCache cache;
    @NotNull
    private final AtomicReference<Date> segmentTimestamp;
    @NotNull
    private final AtomicLong replayStartTimestamp;
    @NotNull
    private final AtomicReference<SentryId> currentReplayId;
    @NotNull
    private final AtomicInteger currentSegment;
    @NotNull
    private final Lazy replayExecutor$delegate;
    @NotNull
    private static final String TAG = "CaptureStrategy";
    @NotNull
    private static final Regex snakecasePattern = new Regex("_[a-z]");
    @NotNull
    private static final Set<String> supportedNetworkData;

    public BaseCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull ScreenshotRecorderConfig recorderConfig, @Nullable ScheduledExecutorService executor, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
        this.recorderConfig = recorderConfig;
        this.replayCacheProvider = replayCacheProvider;
        this.segmentTimestamp = new AtomicReference();
        this.replayStartTimestamp = new AtomicLong();
        this.currentReplayId = new AtomicReference<SentryId>(SentryId.EMPTY_ID);
        this.currentSegment = new AtomicInteger(0);
        this.replayExecutor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScheduledExecutorService>(executor){
            final /* synthetic */ ScheduledExecutorService $executor;
            {
                this.$executor = $executor;
                super(0);
            }

            public final ScheduledExecutorService invoke() {
                ScheduledExecutorService scheduledExecutorService = this.$executor;
                if (scheduledExecutorService == null) {
                    scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ReplayExecutorServiceThreadFactory());
                }
                return scheduledExecutorService;
            }
        }));
    }

    public /* synthetic */ BaseCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, ScreenshotRecorderConfig screenshotRecorderConfig, ScheduledExecutorService scheduledExecutorService, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            scheduledExecutorService = null;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, screenshotRecorderConfig, scheduledExecutorService, (Function1<? super SentryId, ReplayCache>)function1);
    }

    @NotNull
    protected final ScreenshotRecorderConfig getRecorderConfig() {
        return this.recorderConfig;
    }

    protected final void setRecorderConfig(@NotNull ScreenshotRecorderConfig screenshotRecorderConfig) {
        Intrinsics.checkNotNullParameter((Object)screenshotRecorderConfig, (String)"<set-?>");
        this.recorderConfig = screenshotRecorderConfig;
    }

    @Nullable
    protected final ReplayCache getCache() {
        return this.cache;
    }

    protected final void setCache(@Nullable ReplayCache replayCache) {
        this.cache = replayCache;
    }

    @NotNull
    protected final AtomicReference<Date> getSegmentTimestamp() {
        return this.segmentTimestamp;
    }

    @NotNull
    protected final AtomicLong getReplayStartTimestamp() {
        return this.replayStartTimestamp;
    }

    @Override
    @NotNull
    public AtomicReference<SentryId> getCurrentReplayId() {
        return this.currentReplayId;
    }

    @Override
    @NotNull
    public AtomicInteger getCurrentSegment() {
        return this.currentSegment;
    }

    @Override
    @Nullable
    public File getReplayCacheDir() {
        ReplayCache replayCache = this.cache;
        return replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
    }

    @NotNull
    protected final ScheduledExecutorService getReplayExecutor() {
        Lazy lazy = this.replayExecutor$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-replayExecutor>(...)");
        return (ScheduledExecutorService)object;
    }

    @Override
    public void start(int segmentId, @NotNull SentryId replayId, boolean cleanupOldReplays) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        this.getCurrentSegment().set(segmentId);
        this.getCurrentReplayId().set(replayId);
        if (cleanupOldReplays) {
            ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "CaptureStrategy.replays_cleanup", () -> BaseCaptureStrategy.start$lambda$2(this));
        }
        if ((object = this.replayCacheProvider) == null || (object = (ReplayCache)object.invoke((Object)replayId)) == null) {
            object = new ReplayCache(this.options, replayId, this.recorderConfig);
        }
        this.cache = object;
        this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
        this.replayStartTimestamp.set(this.dateProvider.getCurrentTimeMillis());
    }

    @Override
    public void resume() {
        this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.cache;
        if (replayCache != null) {
            replayCache.close();
        }
        this.getCurrentSegment().set(0);
        this.replayStartTimestamp.set(0L);
        this.segmentTimestamp.set(null);
        this.getCurrentReplayId().set(SentryId.EMPTY_ID);
    }

    @NotNull
    protected final ReplaySegment createSegment(long duration, @NotNull Date currentSegmentTimestamp, @NotNull SentryId replayId, int segmentId, int height, int width, @NotNull SentryReplayEvent.ReplayType replayType) {
        Intrinsics.checkNotNullParameter((Object)currentSegmentTimestamp, (String)"currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        Intrinsics.checkNotNullParameter((Object)replayType, (String)"replayType");
        Object object = this.cache;
        if (object == null || (object = ReplayCache.createVideoOf$default((ReplayCache)object, duration, currentSegmentTimestamp.getTime(), segmentId, height, width, null, 32, null)) == null) {
            return ReplaySegment.Failed.INSTANCE;
        }
        Object generatedVideo = object;
        File video = ((GeneratedVideo)generatedVideo).component1();
        int frameCount = ((GeneratedVideo)generatedVideo).component2();
        long videoDuration = ((GeneratedVideo)generatedVideo).component3();
        return this.buildReplay(video, replayId, currentSegmentTimestamp, segmentId, height, width, frameCount, videoDuration, replayType);
    }

    public static /* synthetic */ ReplaySegment createSegment$default(BaseCaptureStrategy baseCaptureStrategy, long l, Date date, SentryId sentryId, int n, int n2, int n3, SentryReplayEvent.ReplayType replayType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSegment");
        }
        if ((n4 & 0x40) != 0) {
            replayType = SentryReplayEvent.ReplayType.SESSION;
        }
        return baseCaptureStrategy.createSegment(l, date, sentryId, n, n2, n3, replayType);
    }

    private final ReplaySegment buildReplay(File video, SentryId currentReplayId, Date segmentTimestamp, int segmentId, int height, int width, int frameCount, long duration, SentryReplayEvent.ReplayType replayType) {
        RRWebMetaEvent rRWebMetaEvent;
        Date date = DateUtils.getDateTime((long)(segmentTimestamp.getTime() + duration));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getDateTime(segmentTimestamp.time + duration)");
        Date endTimestamp = date;
        SentryReplayEvent sentryReplayEvent = new SentryReplayEvent();
        Object $this$buildReplay_u24lambda_u243 = sentryReplayEvent;
        boolean bl = false;
        $this$buildReplay_u24lambda_u243.setEventId(currentReplayId);
        $this$buildReplay_u24lambda_u243.setReplayId(currentReplayId);
        $this$buildReplay_u24lambda_u243.setSegmentId(segmentId);
        $this$buildReplay_u24lambda_u243.setTimestamp(endTimestamp);
        $this$buildReplay_u24lambda_u243.setReplayStartTimestamp(segmentTimestamp);
        $this$buildReplay_u24lambda_u243.setReplayType(replayType);
        $this$buildReplay_u24lambda_u243.setVideoFile(video);
        SentryReplayEvent replay = sentryReplayEvent;
        List recordingPayload = new ArrayList();
        $this$buildReplay_u24lambda_u243 = recordingPayload;
        RRWebMetaEvent $this$buildReplay_u24lambda_u244 = rRWebMetaEvent = new RRWebMetaEvent();
        boolean bl2 = false;
        $this$buildReplay_u24lambda_u244.setTimestamp(segmentTimestamp.getTime());
        $this$buildReplay_u24lambda_u244.setHeight(height);
        $this$buildReplay_u24lambda_u244.setWidth(width);
        $this$buildReplay_u24lambda_u243.add(rRWebMetaEvent);
        $this$buildReplay_u24lambda_u243 = recordingPayload;
        RRWebMetaEvent $this$buildReplay_u24lambda_u245 = rRWebMetaEvent = new RRWebVideoEvent();
        boolean bl3 = false;
        $this$buildReplay_u24lambda_u245.setTimestamp(segmentTimestamp.getTime());
        $this$buildReplay_u24lambda_u245.setSegmentId(segmentId);
        $this$buildReplay_u24lambda_u245.setDurationMs(duration);
        $this$buildReplay_u24lambda_u245.setFrameCount(frameCount);
        $this$buildReplay_u24lambda_u245.setSize(video.length());
        $this$buildReplay_u24lambda_u245.setFrameRate(this.recorderConfig.getFrameRate());
        $this$buildReplay_u24lambda_u245.setHeight(height);
        $this$buildReplay_u24lambda_u245.setWidth(width);
        $this$buildReplay_u24lambda_u245.setLeft(0);
        $this$buildReplay_u24lambda_u245.setTop(0);
        $this$buildReplay_u24lambda_u243.add(rRWebMetaEvent);
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(arg_0 -> BaseCaptureStrategy.buildReplay$lambda$8(segmentTimestamp, endTimestamp, this, recordingPayload, arg_0));
        }
        RRWebMetaEvent $this$buildReplay_u24lambda_u2410 = rRWebMetaEvent = new ReplayRecording();
        boolean bl4 = false;
        $this$buildReplay_u24lambda_u2410.setSegmentId(Integer.valueOf(segmentId));
        Iterable $this$sortedBy$iv = recordingPayload;
        boolean $i$f$sortedBy = false;
        $this$buildReplay_u24lambda_u2410.setPayload(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RRWebEvent it = (RRWebEvent)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (RRWebEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        }));
        RRWebMetaEvent recording = rRWebMetaEvent;
        return new ReplaySegment.Created(duration, replay, (ReplayRecording)recording);
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.recorderConfig = recorderConfig;
    }

    @Override
    public void close() {
        ExecutorsKt.gracefullyShutdown(this.getReplayExecutor(), this.options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidForRRWebSpan(Breadcrumb $this$isValidForRRWebSpan) {
        Object v = $this$isValidForRRWebSpan.getData().get("url");
        CharSequence charSequence = v instanceof String ? (String)v : null;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        Map map = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
        Map map2 = map;
        if (!map2.containsKey("http.start_timestamp")) return false;
        Map map3 = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"data");
        Map map4 = map3;
        if (!map4.containsKey("http.end_timestamp")) return false;
        return true;
    }

    private final String snakeToCamelCase(String $this$snakeToCamelCase) {
        CharSequence charSequence = $this$snakeToCamelCase;
        Regex regex = snakecasePattern;
        Function1 function1 = snakeToCamelCase.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final RRWebSpanEvent toRRWebSpanEvent(Breadcrumb $this$toRRWebSpanEvent) {
        RRWebSpanEvent rRWebSpanEvent;
        Breadcrumb breadcrumb = $this$toRRWebSpanEvent;
        RRWebSpanEvent $this$toRRWebSpanEvent_u24lambda_u2411 = rRWebSpanEvent = new RRWebSpanEvent();
        boolean bl = false;
        $this$toRRWebSpanEvent_u24lambda_u2411.setTimestamp(breadcrumb.getTimestamp().getTime());
        $this$toRRWebSpanEvent_u24lambda_u2411.setOp("resource.http");
        Object v = breadcrumb.getData().get("url");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        $this$toRRWebSpanEvent_u24lambda_u2411.setDescription((String)v);
        Object v2 = breadcrumb.getData().get("http.start_timestamp");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Long");
        $this$toRRWebSpanEvent_u24lambda_u2411.setStartTimestamp((double)((Long)v2).longValue() / 1000.0);
        Object v3 = breadcrumb.getData().get("http.end_timestamp");
        Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Long");
        $this$toRRWebSpanEvent_u24lambda_u2411.setEndTimestamp((double)((Long)v3).longValue() / 1000.0);
        Map breadcrumbData = new LinkedHashMap();
        Map map = breadcrumb.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"breadcrumb.data");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!supportedNetworkData.contains(key)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            breadcrumbData.put(this.snakeToCamelCase(StringsKt.substringAfter$default((String)StringsKt.replace$default((String)key, (String)"content_length", (String)"body_size", (boolean)false, (int)4, null), (String)".", null, (int)2, null)), value);
        }
        $this$toRRWebSpanEvent_u24lambda_u2411.setData(breadcrumbData);
        return rRWebSpanEvent;
    }

    private static final boolean start$lambda$2$lambda$1$lambda$0(BaseCaptureStrategy this$0, File dir, String name) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (StringsKt.startsWith$default((String)name, (String)"replay_", (boolean)false, (int)2, null)) {
            CharSequence charSequence = name;
            String string = this$0.getCurrentReplayId().get().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentReplayId.get().toString()");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                FileUtils.deleteRecursively((File)new File(dir, name));
            }
        }
        return false;
    }

    private static final void start$lambda$2(BaseCaptureStrategy this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            String string = this$0.options.getCacheDirPath();
            if (string == null) break block0;
            String cacheDir = string;
            boolean bl = false;
            new File(cacheDir).listFiles((arg_0, arg_1) -> BaseCaptureStrategy.start$lambda$2$lambda$1$lambda$0(this$0, arg_0, arg_1));
        }
    }

    private static final void buildReplay$lambda$8(Date $segmentTimestamp, Date $endTimestamp, BaseCaptureStrategy this$0, List $recordingPayload, IScope scope) {
        Intrinsics.checkNotNullParameter((Object)$segmentTimestamp, (String)"$segmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$endTimestamp, (String)"$endTimestamp");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$recordingPayload, (String)"$recordingPayload");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Queue queue = scope.getBreadcrumbs();
        Intrinsics.checkNotNullExpressionValue((Object)queue, (String)"scope.breadcrumbs");
        Iterable $this$forEach$iv = queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Breadcrumb breadcrumb = (Breadcrumb)element$iv;
            boolean bl = false;
            if (!breadcrumb.getTimestamp().after($segmentTimestamp) || !breadcrumb.getTimestamp().before($endTimestamp)) continue;
            String breadcrumbMessage = null;
            String breadcrumbCategory = null;
            Map breadcrumbData = new LinkedHashMap();
            if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"http")) {
                Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"breadcrumb");
                if (!this$0.isValidForRRWebSpan(breadcrumb)) continue;
                ((Collection)$recordingPayload).add(this$0.toRRWebSpanEvent(breadcrumb));
                continue;
            }
            if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"device.orientation")) {
                String string = breadcrumb.getCategory();
                Intrinsics.checkNotNull((Object)string);
                breadcrumbCategory = string;
                object2 = breadcrumb.getData().get("position");
                String string2 = object2 instanceof String ? (String)object2 : null;
                if (string2 == null) {
                    string2 = "";
                }
                breadcrumbMessage = string2;
            } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation")) {
                String string;
                Object object3;
                breadcrumbCategory = "navigation";
                object = breadcrumbData;
                object2 = "to";
                if (Intrinsics.areEqual(breadcrumb.getData().get("state"), (Object)"resumed")) {
                    object3 = breadcrumb.getData().get("screen");
                    string = object3 instanceof String ? (String)object3 : null;
                } else if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"app.lifecycle")) {
                    object3 = breadcrumb.getData().get("state");
                    string = object3 instanceof String ? (String)object3 : null;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)breadcrumb.getData(), (String)"breadcrumb.data");
                    if (!object3.containsKey("to")) continue;
                    object3 = breadcrumb.getData().get("to");
                    string = object3 instanceof String ? (String)object3 : null;
                }
                if (string == null) continue;
                String string3 = string;
                object.put(object2, string3);
            } else {
                object = new String[]{"ui.click", "ui.scroll", "ui.swipe"};
                if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])object), (Object)breadcrumb.getCategory())) {
                    String string;
                    String string4 = breadcrumb.getCategory();
                    Intrinsics.checkNotNull((Object)string4);
                    breadcrumbCategory = string4;
                    Object v = breadcrumb.getData().get("view.id");
                    if (v == null && (v = breadcrumb.getData().get("view.class")) == null) {
                        v = breadcrumb.getData().get("view.tag");
                    }
                    if ((string = (object2 = v) instanceof String ? (String)object2 : null) == null) {
                        string = "";
                    }
                    breadcrumbMessage = string;
                } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"system")) {
                    String string = breadcrumb.getType();
                    Intrinsics.checkNotNull((Object)string);
                    breadcrumbCategory = string;
                    object2 = CollectionsKt.joinToString$default((Iterable)breadcrumb.getData().entrySet(), null, null, null, (int)0, null, null, (int)63, null);
                    Object object4 = object2 instanceof String ? object2 : null;
                    if (object4 == null) {
                        object4 = "";
                    }
                    breadcrumbMessage = object4;
                } else {
                    breadcrumbCategory = breadcrumb.getCategory();
                    breadcrumbMessage = breadcrumb.getMessage();
                }
            }
            if ((object = (CharSequence)breadcrumbCategory) == null || object.length() == 0) continue;
            object = $recordingPayload;
            Object $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246 = object2 = new RRWebBreadcrumbEvent();
            boolean bl2 = false;
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setTimestamp(breadcrumb.getTimestamp().getTime());
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setBreadcrumbTimestamp((double)breadcrumb.getTimestamp().getTime() / 1000.0);
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setBreadcrumbType("default");
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setCategory(breadcrumbCategory);
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setMessage(breadcrumbMessage);
            $this$buildReplay_u24lambda_u248_u24lambda_u247_u24lambda_u246.setData(breadcrumbData);
            object.add(object2);
        }
    }

    static {
        Object[] objectArray = new String[]{"status_code", "method", "response_content_length", "request_content_length", "http.response_content_length", "http.request_content_length"};
        supportedNetworkData = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "", "()V", "Created", "Failed", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Failed;", "sentry-android-replay_release"})
    protected static abstract class ReplaySegment {
        private ReplaySegment() {
        }

        public /* synthetic */ ReplaySegment(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Failed;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "()V", "sentry-android-replay_release"})
        public static final class Failed
        extends ReplaySegment {
            @NotNull
            public static final Failed INSTANCE = new Failed();

            private Failed() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001eJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "videoDuration", "", "replay", "Lio/sentry/SentryReplayEvent;", "recording", "Lio/sentry/ReplayRecording;", "(JLio/sentry/SentryReplayEvent;Lio/sentry/ReplayRecording;)V", "getRecording", "()Lio/sentry/ReplayRecording;", "getReplay", "()Lio/sentry/SentryReplayEvent;", "getVideoDuration", "()J", "capture", "", "hub", "Lio/sentry/IHub;", "hint", "Lio/sentry/Hint;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "setSegmentId", "segmentId", "toString", "", "sentry-android-replay_release"})
        @SourceDebugExtension(value={"SMAP\nBaseCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1#2:340\n1855#3,2:341\n*S KotlinDebug\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created\n*L\n294#1:341,2\n*E\n"})
        public static final class Created
        extends ReplaySegment {
            private final long videoDuration;
            @NotNull
            private final SentryReplayEvent replay;
            @NotNull
            private final ReplayRecording recording;

            public Created(long videoDuration, @NotNull SentryReplayEvent replay, @NotNull ReplayRecording recording) {
                Intrinsics.checkNotNullParameter((Object)replay, (String)"replay");
                Intrinsics.checkNotNullParameter((Object)recording, (String)"recording");
                super(null);
                this.videoDuration = videoDuration;
                this.replay = replay;
                this.recording = recording;
            }

            public final long getVideoDuration() {
                return this.videoDuration;
            }

            @NotNull
            public final SentryReplayEvent getReplay() {
                return this.replay;
            }

            @NotNull
            public final ReplayRecording getRecording() {
                return this.recording;
            }

            /*
             * WARNING - void declaration
             */
            public final void capture(@Nullable IHub hub, @NotNull Hint hint) {
                block0: {
                    void $this$capture_u24lambda_u240;
                    Hint hint2;
                    Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
                    IHub iHub = hub;
                    if (iHub == null) break block0;
                    Hint hint3 = hint2 = hint;
                    SentryReplayEvent sentryReplayEvent = this.replay;
                    IHub iHub2 = iHub;
                    boolean bl = false;
                    $this$capture_u24lambda_u240.setReplayRecording(this.recording);
                    Unit unit = Unit.INSTANCE;
                    iHub2.captureReplay(sentryReplayEvent, hint2);
                }
            }

            public static /* synthetic */ void capture$default(Created created, IHub iHub, Hint hint, int n, Object object) {
                if ((n & 2) != 0) {
                    hint = new Hint();
                }
                created.capture(iHub, hint);
            }

            public final void setSegmentId(int segmentId) {
                block1: {
                    this.replay.setSegmentId(segmentId);
                    List list = this.recording.getPayload();
                    if (list == null) break block1;
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RRWebEvent it = (RRWebEvent)element$iv;
                        boolean bl = false;
                        if (!(it instanceof RRWebVideoEvent)) continue;
                        ((RRWebVideoEvent)it).setSegmentId(segmentId);
                    }
                }
            }

            public final long component1() {
                return this.videoDuration;
            }

            @NotNull
            public final SentryReplayEvent component2() {
                return this.replay;
            }

            @NotNull
            public final ReplayRecording component3() {
                return this.recording;
            }

            @NotNull
            public final Created copy(long videoDuration, @NotNull SentryReplayEvent replay, @NotNull ReplayRecording recording) {
                Intrinsics.checkNotNullParameter((Object)replay, (String)"replay");
                Intrinsics.checkNotNullParameter((Object)recording, (String)"recording");
                return new Created(videoDuration, replay, recording);
            }

            public static /* synthetic */ Created copy$default(Created created, long l, SentryReplayEvent sentryReplayEvent, ReplayRecording replayRecording, int n, Object object) {
                if ((n & 1) != 0) {
                    l = created.videoDuration;
                }
                if ((n & 2) != 0) {
                    sentryReplayEvent = created.replay;
                }
                if ((n & 4) != 0) {
                    replayRecording = created.recording;
                }
                return created.copy(l, sentryReplayEvent, replayRecording);
            }

            @NotNull
            public String toString() {
                return "Created(videoDuration=" + this.videoDuration + ", replay=" + this.replay + ", recording=" + this.recording + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.videoDuration);
                result = result * 31 + this.replay.hashCode();
                result = result * 31 + this.recording.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Created)) {
                    return false;
                }
                Created created = (Created)other;
                if (this.videoDuration != created.videoDuration) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.replay, (Object)created.replay)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.recording, (Object)created.recording);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$Companion;", "", "()V", "TAG", "", "snakecasePattern", "Lkotlin/text/Regex;", "supportedNetworkData", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplayExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class ReplayExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayIntegration-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

