/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.view.MotionEvent;
import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.capture.SessionCaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.SamplingKt;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.Random;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 :2\u00020\u0001:\u0001:BV\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012%\b\u0002\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180\rH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180\rH\u0002J\u0012\u0010$\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0016J@\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010,2,\u0010-\u001a(\u0012\u0004\u0012\u00020\u0012\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u00180.\u00a2\u0006\u0002\b1H\u0016J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u0018H\u0016J\b\u00106\u001a\u00020\u0018H\u0016J\u0012\u00107\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001a\u00108\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u00109\u001a\u00020/H\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/sentry/android/replay/capture/BufferCaptureStrategy;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "random", "Lio/sentry/util/Random;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Lio/sentry/util/Random;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;)V", "bufferedSegments", "", "Lio/sentry/android/replay/capture/CaptureStrategy$ReplaySegment$Created;", "captureReplay", "", "isTerminating", "", "onSegmentSent", "Ljava/util/Date;", "convert", "Lio/sentry/android/replay/capture/CaptureStrategy;", "createCurrentSegment", "taskName", "", "onSegmentCreated", "Lio/sentry/android/replay/capture/CaptureStrategy$ReplaySegment;", "deleteFile", "file", "Ljava/io/File;", "onConfigurationChanged", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "store", "Lkotlin/Function2;", "", "frameTimestamp", "Lkotlin/ExtensionFunctionType;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "stop", "capture", "rotate", "bufferLimit", "Companion", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nBufferCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferCaptureStrategy.kt\nio/sentry/android/replay/capture/BufferCaptureStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1864#2,3:214\n*S KotlinDebug\n*F\n+ 1 BufferCaptureStrategy.kt\nio/sentry/android/replay/capture/BufferCaptureStrategy\n*L\n185#1:214,3\n*E\n"})
public final class BufferCaptureStrategy
extends BaseCaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private final Random random;
    @NotNull
    private final List<CaptureStrategy.ReplaySegment.Created> bufferedSegments;
    @NotNull
    private static final String TAG = "BufferCaptureStrategy";
    private static final long ENVELOPE_PROCESSING_DELAY = 100L;

    public BufferCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull Random random2, @NotNull ScheduledExecutorService executor, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(options, hub, dateProvider, executor, replayCacheProvider);
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
        this.random = random2;
        this.bufferedSegments = new ArrayList();
    }

    public /* synthetic */ BufferCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, Random random2, ScheduledExecutorService scheduledExecutorService, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, random2, scheduledExecutorService, (Function1<? super SentryId, ReplayCache>)function1);
    }

    @Override
    public void pause() {
        this.createCurrentSegment("pause", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this){
            final /* synthetic */ BufferCaptureStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    ((Collection)BufferCaptureStrategy.access$getBufferedSegments$p(this.this$0)).add(segment);
                    BufferCaptureStrategy bufferCaptureStrategy = this.this$0;
                    int n = bufferCaptureStrategy.getCurrentSegment();
                    bufferCaptureStrategy.setCurrentSegment(n + 1);
                }
            }
        }));
        super.pause();
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.getCache();
        File replayCacheDir2 = replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.stop", () -> BufferCaptureStrategy.stop$lambda$0(replayCacheDir2));
        super.stop();
    }

    @Override
    public void captureReplay(boolean isTerminating, @NotNull Function1<? super Date, Unit> onSegmentSent) {
        Intrinsics.checkNotNullParameter(onSegmentSent, (String)"onSegmentSent");
        boolean sampled = SamplingKt.sample(this.random, this.options.getExperimental().getSessionReplay().getOnErrorSampleRate());
        if (!sampled) {
            this.options.getLogger().log(SentryLevel.INFO, "Replay wasn't sampled by onErrorSampleRate, not capturing for event", new Object[0]);
            return;
        }
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(arg_0 -> BufferCaptureStrategy.captureReplay$lambda$1(this, arg_0));
        }
        if (isTerminating) {
            this.isTerminating().set(true);
            this.options.getLogger().log(SentryLevel.DEBUG, "Not capturing replay for crashed event, will be captured on next launch", new Object[0]);
            return;
        }
        this.createCurrentSegment("capture_replay", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this, onSegmentSent){
            final /* synthetic */ BufferCaptureStrategy this$0;
            final /* synthetic */ Function1<Date, Unit> $onSegmentSent;
            {
                this.this$0 = $receiver;
                this.$onSegmentSent = $onSegmentSent;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                BufferCaptureStrategy.access$capture(this.this$0, BufferCaptureStrategy.access$getBufferedSegments$p(this.this$0));
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    CaptureStrategy.ReplaySegment.Created.capture$default((CaptureStrategy.ReplaySegment.Created)segment, BufferCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                    Date date = ((CaptureStrategy.ReplaySegment.Created)segment).getReplay().getTimestamp();
                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"segment.replay.timestamp");
                    this.$onSegmentSent.invoke((Object)date);
                }
            }
        }));
    }

    @Override
    public void onScreenshotRecorded(@Nullable Bitmap bitmap, @NotNull Function2<? super ReplayCache, ? super Long, Unit> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        long frameTimestamp = this.dateProvider.getCurrentTimeMillis();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.add_frame", () -> BufferCaptureStrategy.onScreenshotRecorded$lambda$2(this, store, frameTimestamp));
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.createCurrentSegment("configuration_changed", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this){
            final /* synthetic */ BufferCaptureStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    ((Collection)BufferCaptureStrategy.access$getBufferedSegments$p(this.this$0)).add(segment);
                    BufferCaptureStrategy bufferCaptureStrategy = this.this$0;
                    int n = bufferCaptureStrategy.getCurrentSegment();
                    bufferCaptureStrategy.setCurrentSegment(n + 1);
                }
            }
        }));
        super.onConfigurationChanged(recorderConfig);
    }

    @Override
    @NotNull
    public CaptureStrategy convert() {
        if (this.isTerminating().get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Not converting to session mode, because the process is about to terminate", new Object[0]);
            return this;
        }
        SessionCaptureStrategy captureStrategy = new SessionCaptureStrategy(this.options, this.hub, this.dateProvider, this.getReplayExecutor(), null, 16, null);
        captureStrategy.start(this.getRecorderConfig(), this.getCurrentSegment(), this.getCurrentReplayId(), SentryReplayEvent.ReplayType.BUFFER);
        return captureStrategy;
    }

    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        long bufferLimit = this.dateProvider.getCurrentTimeMillis() - this.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        CaptureStrategy.Companion.rotateEvents$sentry_android_replay_release$default(CaptureStrategy.Companion, this.getCurrentEvents(), bufferLimit, null, 4, null);
    }

    private final void deleteFile(File file) {
        if (file == null) {
            return;
        }
        try {
            if (!file.delete()) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete replay segment: %s", objectArray);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to delete replay segment: %s", objectArray);
        }
    }

    private final void capture(List<CaptureStrategy.ReplaySegment.Created> $this$capture) {
        CaptureStrategy.ReplaySegment.Created bufferedSegment = (CaptureStrategy.ReplaySegment.Created)CollectionsKt.removeFirstOrNull($this$capture);
        while (bufferedSegment != null) {
            CaptureStrategy.ReplaySegment.Created.capture$default(bufferedSegment, this.hub, null, 2, null);
            bufferedSegment = (CaptureStrategy.ReplaySegment.Created)CollectionsKt.removeFirstOrNull($this$capture);
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rotate(List<CaptureStrategy.ReplaySegment.Created> $this$rotate, long bufferLimit) {
        Ref.BooleanRef removed = new Ref.BooleanRef();
        CollectionsKt.removeAll($this$rotate, (Function1)((Function1)new Function1<CaptureStrategy.ReplaySegment.Created, Boolean>(bufferLimit, this, removed){
            final /* synthetic */ long $bufferLimit;
            final /* synthetic */ BufferCaptureStrategy this$0;
            final /* synthetic */ Ref.BooleanRef $removed;
            {
                this.$bufferLimit = $bufferLimit;
                this.this$0 = $receiver;
                this.$removed = $removed;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CaptureStrategy.ReplaySegment.Created it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getReplay().getTimestamp().getTime() < this.$bufferLimit) {
                    BufferCaptureStrategy bufferCaptureStrategy = this.this$0;
                    int n = bufferCaptureStrategy.getCurrentSegment();
                    bufferCaptureStrategy.setCurrentSegment(n + -1);
                    BufferCaptureStrategy.access$deleteFile(this.this$0, it.getReplay().getVideoFile());
                    this.$removed.element = true;
                    return true;
                }
                return false;
            }
        }));
        if (removed.element) {
            Iterable $this$forEachIndexed$iv = $this$rotate;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void segment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CaptureStrategy.ReplaySegment.Created created = (CaptureStrategy.ReplaySegment.Created)item$iv;
                int index = n;
                boolean bl = false;
                segment.setSegmentId(index);
            }
        }
    }

    private final void createCurrentSegment(String taskName, Function1<? super CaptureStrategy.ReplaySegment, Unit> onSegmentCreated) {
        Date date;
        long errorReplayDuration = this.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        long now = this.dateProvider.getCurrentTimeMillis();
        Object object = this.getCache();
        boolean bl = object != null && (object = ((ReplayCache)object).getFrames$sentry_android_replay_release()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            ReplayCache replayCache = this.getCache();
            Intrinsics.checkNotNull((Object)replayCache);
            date = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(replayCache.getFrames$sentry_android_replay_release())).getTimestamp());
        } else {
            date = DateUtils.getDateTime((long)(now - errorReplayDuration));
        }
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"if (cache?.frames?.isNot\u2026ReplayDuration)\n        }");
        Date currentSegmentTimestamp = date;
        int segmentId = this.getCurrentSegment();
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.getCurrentReplayId();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy." + taskName, () -> BufferCaptureStrategy.createCurrentSegment$lambda$4(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width, onSegmentCreated));
    }

    private static final void stop$lambda$0(File $replayCacheDir) {
        FileUtils.deleteRecursively((File)$replayCacheDir);
    }

    private static final void captureReplay$lambda$1(BufferCaptureStrategy this$0, IScope it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(this$0.getCurrentReplayId());
    }

    private static final void onScreenshotRecorded$lambda$2(BufferCaptureStrategy this$0, Function2 $store, long $frameTimestamp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$store, (String)"$store");
        ReplayCache replayCache = this$0.getCache();
        if (replayCache != null) {
            $store.invoke((Object)replayCache, (Object)$frameTimestamp);
        }
        long now = this$0.dateProvider.getCurrentTimeMillis();
        long bufferLimit = now - this$0.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        ReplayCache replayCache2 = this$0.getCache();
        this$0.setScreenAtStart(replayCache2 != null ? replayCache2.rotate(bufferLimit) : null);
        this$0.rotate(this$0.bufferedSegments, bufferLimit);
    }

    private static final void createCurrentSegment$lambda$4(BufferCaptureStrategy this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width, Function1 $onSegmentCreated) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentSegmentTimestamp, (String)"$currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$replayId, (String)"$replayId");
        Intrinsics.checkNotNullParameter((Object)$onSegmentCreated, (String)"$onSegmentCreated");
        CaptureStrategy.ReplaySegment segment = BaseCaptureStrategy.createSegmentInternal$default(this$0, $duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, null, null, 0, 0, null, null, null, 8128, null);
        $onSegmentCreated.invoke((Object)segment);
    }

    public static final /* synthetic */ List access$getBufferedSegments$p(BufferCaptureStrategy $this) {
        return $this.bufferedSegments;
    }

    public static final /* synthetic */ void access$capture(BufferCaptureStrategy $this, List $receiver) {
        $this.capture($receiver);
    }

    public static final /* synthetic */ IHub access$getHub$p(BufferCaptureStrategy $this) {
        return $this.hub;
    }

    public static final /* synthetic */ void access$deleteFile(BufferCaptureStrategy $this, File file) {
        $this.deleteFile(file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/sentry/android/replay/capture/BufferCaptureStrategy$Companion;", "", "()V", "ENVELOPE_PROCESSING_DELAY", "", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

