/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.view.View;
import io.sentry.SentryOptions;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0002*+B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001fH\u0016R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/sentry/android/replay/WindowRecorder;", "Lio/sentry/android/replay/Recorder;", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/android/replay/util/MainLooperHandler;)V", "capturer", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getCapturer", "()Ljava/util/concurrent/ScheduledExecutorService;", "capturer$delegate", "Lkotlin/Lazy;", "capturingTask", "Ljava/util/concurrent/ScheduledFuture;", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "recorder", "Lio/sentry/android/replay/ScreenshotRecorder;", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "rootViewsLock", "", "close", "", "onRootViewsChanged", "root", "added", "", "pause", "resume", "start", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "stop", "Companion", "RecorderExecutorServiceThreadFactory", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nWindowRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1855#2,2:106\n*S KotlinDebug\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n*L\n81#1:106,2\n*E\n"})
public final class WindowRecorder
implements Recorder,
OnRootViewsChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    @NotNull
    private final Object rootViewsLock;
    @Nullable
    private ScreenshotRecorder recorder;
    @Nullable
    private ScheduledFuture<?> capturingTask;
    @NotNull
    private final Lazy capturer$delegate;
    @NotNull
    private static final String TAG = "WindowRecorder";

    public WindowRecorder(@NotNull SentryOptions options, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull MainLooperHandler mainLooperHandler) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.mainLooperHandler = mainLooperHandler;
        this.isRecording = new AtomicBoolean(false);
        this.rootViews = new ArrayList();
        this.rootViewsLock = new Object();
        this.capturer$delegate = LazyKt.lazy((Function0)capturer.2.INSTANCE);
    }

    public /* synthetic */ WindowRecorder(SentryOptions sentryOptions, ScreenshotRecorderCallback screenshotRecorderCallback, MainLooperHandler mainLooperHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            screenshotRecorderCallback = null;
        }
        this(sentryOptions, screenshotRecorderCallback, mainLooperHandler);
    }

    private final ScheduledExecutorService getCapturer() {
        Lazy lazy = this.capturer$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRootViewsChanged(@NotNull View root, boolean added) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = this.rootViewsLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            if (added) {
                this.rootViews.add(new WeakReference<View>(root));
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.bind(root);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                View newRoot;
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.unbind(root);
                }
                CollectionsKt.removeAll((List)this.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                    final /* synthetic */ View $root;
                    {
                        this.$root = $root;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull WeakReference<View> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return Intrinsics.areEqual(it.get(), (Object)this.$root);
                    }
                }));
                WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this.rootViews);
                Object object2 = newRoot = weakReference != null ? (View)weakReference.get() : null;
                if (newRoot != null && !Intrinsics.areEqual((Object)root, (Object)newRoot)) {
                    ScreenshotRecorder screenshotRecorder2 = this.recorder;
                    if (screenshotRecorder2 != null) {
                        screenshotRecorder2.bind(newRoot);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    unit = Unit.INSTANCE;
                }
            }
            Unit unit2 = unit;
        }
    }

    @Override
    public void start(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        if (this.isRecording.getAndSet(true)) {
            return;
        }
        this.recorder = new ScreenshotRecorder(recorderConfig, this.options, this.mainLooperHandler, this.screenshotRecorderCallback);
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        this.capturingTask = ExecutorsKt.scheduleAtFixedRateSafely(scheduledExecutorService, this.options, "WindowRecorder.capture", 100L, 1000L / (long)recorderConfig.getFrameRate(), TimeUnit.MILLISECONDS, () -> WindowRecorder.start$lambda$1(this));
    }

    @Override
    public void resume() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.resume();
        }
    }

    @Override
    public void pause() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.rootViewsLock;
        synchronized (object) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.rootViews;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl2 = false;
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder == null) continue;
                screenshotRecorder.unbind((View)it.get());
            }
            this.rootViews.clear();
            Unit unit = Unit.INSTANCE;
        }
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.close();
        }
        this.recorder = null;
        ScheduledFuture<?> scheduledFuture = this.capturingTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.capturingTask = null;
        this.isRecording.set(false);
    }

    @Override
    public void close() {
        this.stop();
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        ExecutorsKt.gracefullyShutdown(scheduledExecutorService, this.options);
    }

    private static final void start$lambda$1(WindowRecorder this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.capture();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/WindowRecorder$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/WindowRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryWindowRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

