/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.gestures;

import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.gestures.TouchRecorderCallback;
import io.sentry.android.replay.util.FixedWindowCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\f\u0010\u0012\u001a\u00020\r*\u00020\nH\u0002J\f\u0010\u0013\u001a\u00020\r*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/sentry/android/replay/gestures/GestureRecorder;", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "options", "Lio/sentry/SentryOptions;", "touchRecorderCallback", "Lio/sentry/android/replay/gestures/TouchRecorderCallback;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/gestures/TouchRecorderCallback;)V", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "onRootViewsChanged", "", "root", "added", "", "stop", "startGestureTracking", "stopGestureTracking", "SentryReplayGestureRecorder", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGestureRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GestureRecorder.kt\nio/sentry/android/replay/gestures/GestureRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1855#2,2:87\n*S KotlinDebug\n*F\n+ 1 GestureRecorder.kt\nio/sentry/android/replay/gestures/GestureRecorder\n*L\n32#1:87,2\n*E\n"})
public final class GestureRecorder
implements OnRootViewsChangedListener {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final TouchRecorderCallback touchRecorderCallback;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    public static final int $stable = 8;

    public GestureRecorder(@NotNull SentryOptions options, @NotNull TouchRecorderCallback touchRecorderCallback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)touchRecorderCallback, (String)"touchRecorderCallback");
        this.options = options;
        this.touchRecorderCallback = touchRecorderCallback;
        this.rootViews = new ArrayList();
    }

    @Override
    public void onRootViewsChanged(@NotNull View root, boolean added) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (added) {
            this.rootViews.add(new WeakReference<View>(root));
            this.startGestureTracking(root);
        } else {
            this.stopGestureTracking(root);
            CollectionsKt.removeAll((List)this.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                final /* synthetic */ View $root;
                {
                    this.$root = $root;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WeakReference<View> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Intrinsics.areEqual(it.get(), (Object)this.$root);
                }
            }));
        }
    }

    public final void stop() {
        Iterable $this$forEach$iv = this.rootViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View view;
            WeakReference it = (WeakReference)element$iv;
            boolean bl = false;
            View view2 = view = (View)it.get();
            if (view2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"get()");
            this.stopGestureTracking(view);
        }
        this.rootViews.clear();
    }

    private final void startGestureTracking(View $this$startGestureTracking) {
        Window window = WindowsKt.getPhoneWindow($this$startGestureTracking);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not tracking gestures", new Object[0]);
            return;
        }
        Window.Callback delegate = window.getCallback();
        if (!(delegate instanceof SentryReplayGestureRecorder)) {
            window.setCallback((Window.Callback)new SentryReplayGestureRecorder(this.options, this.touchRecorderCallback, delegate));
        }
    }

    private final void stopGestureTracking(View $this$stopGestureTracking) {
        Window window = WindowsKt.getPhoneWindow($this$stopGestureTracking);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window was null in stopGestureTracking", new Object[0]);
            return;
        }
        if (window.getCallback() instanceof SentryReplayGestureRecorder) {
            Window.Callback callback = window.getCallback();
            Intrinsics.checkNotNull((Object)callback, (String)"null cannot be cast to non-null type io.sentry.android.replay.gestures.GestureRecorder.SentryReplayGestureRecorder");
            Window.Callback delegate = ((SentryReplayGestureRecorder)callback).delegate;
            window.setCallback(delegate);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/sentry/android/replay/gestures/GestureRecorder$SentryReplayGestureRecorder;", "Lio/sentry/android/replay/util/FixedWindowCallback;", "options", "Lio/sentry/SentryOptions;", "touchRecorderCallback", "Lio/sentry/android/replay/gestures/TouchRecorderCallback;", "delegate", "Landroid/view/Window$Callback;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/gestures/TouchRecorderCallback;Landroid/view/Window$Callback;)V", "dispatchTouchEvent", "", "event", "Landroid/view/MotionEvent;", "sentry-android-replay_release"})
    public static final class SentryReplayGestureRecorder
    extends FixedWindowCallback {
        @NotNull
        private final SentryOptions options;
        @Nullable
        private final TouchRecorderCallback touchRecorderCallback;

        public SentryReplayGestureRecorder(@NotNull SentryOptions options, @Nullable TouchRecorderCallback touchRecorderCallback, @Nullable Window.Callback delegate) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(delegate);
            this.options = options;
            this.touchRecorderCallback = touchRecorderCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchTouchEvent(@Nullable MotionEvent event) {
            if (event != null) {
                MotionEvent motionEvent = MotionEvent.obtainNoHistory((MotionEvent)event);
                Intrinsics.checkNotNullExpressionValue((Object)motionEvent, (String)"obtainNoHistory(event)");
                MotionEvent copy = motionEvent;
                try {
                    TouchRecorderCallback touchRecorderCallback = this.touchRecorderCallback;
                    if (touchRecorderCallback != null) {
                        touchRecorderCallback.onTouchEvent(copy);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error dispatching touch event", e);
                }
                finally {
                    copy.recycle();
                }
            }
            return super.dispatchTouchEvent(event);
        }
    }
}

