/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import android.view.MotionEvent;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.capture.SessionCaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.SamplingKt;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=BV\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012%\b\u0002\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u0016J6\u0010(\u001a\u00020 2,\u0010)\u001a(\u0012\u0004\u0012\u00020\u0012\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020 0*\u00a2\u0006\u0002\b,H\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016J2\u00100\u001a\u00020 2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u00172\b\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020 07H\u0016J \u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010;\u001a\u000202H\u0016J\b\u0010<\u001a\u00020 H\u0016R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lio/sentry/android/replay/capture/BufferCaptureStrategy;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "random", "Ljava/security/SecureRandom;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Lio/sentry/android/replay/ScreenshotRecorderConfig;Ljava/security/SecureRandom;Lkotlin/jvm/functions/Function1;)V", "bufferedScreens", "", "Lkotlin/Pair;", "", "", "bufferedScreensLock", "", "bufferedSegments", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created;", "convert", "Lio/sentry/android/replay/capture/CaptureStrategy;", "deleteFile", "", "file", "Ljava/io/File;", "findAndSetStartScreen", "segmentStart", "onConfigurationChanged", "onScreenChanged", "screen", "onScreenshotRecorded", "store", "Lkotlin/Function2;", "frameTimestamp", "Lkotlin/ExtensionFunctionType;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "sendReplayForEvent", "isCrashed", "", "eventId", "hint", "Lio/sentry/Hint;", "onSegmentSent", "Lkotlin/Function0;", "start", "segmentId", "", "cleanupOldReplays", "stop", "Companion", "sentry-android-replay_release"})
@SourceDebugExtension(value={"SMAP\nBufferCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferCaptureStrategy.kt\nio/sentry/android/replay/capture/BufferCaptureStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n533#2,6:225\n1864#2,3:231\n*S KotlinDebug\n*F\n+ 1 BufferCaptureStrategy.kt\nio/sentry/android/replay/capture/BufferCaptureStrategy\n*L\n211#1:225,6\n150#1:231,3\n*E\n"})
public final class BufferCaptureStrategy
extends BaseCaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private final SecureRandom random;
    @NotNull
    private final List<BaseCaptureStrategy.ReplaySegment.Created> bufferedSegments;
    @NotNull
    private final Object bufferedScreensLock;
    @NotNull
    private final List<Pair<String, Long>> bufferedScreens;
    @NotNull
    private static final String TAG = "BufferCaptureStrategy";

    public BufferCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull ScreenshotRecorderConfig recorderConfig, @NotNull SecureRandom random2, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
        super(options, hub, dateProvider, recorderConfig, null, replayCacheProvider, 16, null);
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
        this.random = random2;
        this.bufferedSegments = new ArrayList();
        this.bufferedScreensLock = new Object();
        this.bufferedScreens = new ArrayList();
    }

    public /* synthetic */ BufferCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, ScreenshotRecorderConfig screenshotRecorderConfig, SecureRandom secureRandom, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, screenshotRecorderConfig, secureRandom, (Function1<? super SentryId, ReplayCache>)function1);
    }

    @Override
    public void start(int segmentId, @NotNull SentryId replayId, boolean cleanupOldReplays) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
            super.start(segmentId, replayId, cleanupOldReplays);
            IHub iHub = this.hub;
            if (iHub == null) break block0;
            iHub.configureScope(arg_0 -> BufferCaptureStrategy.start$lambda$1(this, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScreenChanged(@Nullable String screen) {
        Object object = this.bufferedScreensLock;
        synchronized (object) {
            String lastKnownScreen;
            boolean bl = false;
            Pair pair = (Pair)CollectionsKt.lastOrNull(this.bufferedScreens);
            String string = lastKnownScreen = pair != null ? (String)pair.getFirst() : null;
            if (screen != null && !Intrinsics.areEqual((Object)lastKnownScreen, (Object)screen)) {
                this.bufferedScreens.add((Pair<String, Long>)TuplesKt.to((Object)screen, (Object)this.dateProvider.getCurrentTimeMillis()));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.getCache();
        File replayCacheDir2 = replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.stop", () -> BufferCaptureStrategy.stop$lambda$3(replayCacheDir2));
        super.stop();
    }

    @Override
    public void sendReplayForEvent(boolean isCrashed, @Nullable String eventId, @Nullable Hint hint, @NotNull Function0<Unit> onSegmentSent) {
        Date date;
        Intrinsics.checkNotNullParameter(onSegmentSent, (String)"onSegmentSent");
        boolean sampled = SamplingKt.sample(this.random, this.options.getExperimental().getSessionReplay().getErrorSampleRate());
        if (!sampled) {
            Object[] objectArray = new Object[]{eventId};
            this.options.getLogger().log(SentryLevel.INFO, "Replay wasn't sampled by errorSampleRate, not capturing for event %s", objectArray);
            return;
        }
        long errorReplayDuration = this.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        long now = this.dateProvider.getCurrentTimeMillis();
        Object object = this.getCache();
        boolean bl = object != null && (object = ((ReplayCache)object).getFrames$sentry_android_replay_release()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            ReplayCache replayCache = this.getCache();
            Intrinsics.checkNotNull((Object)replayCache);
            date = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(replayCache.getFrames$sentry_android_replay_release())).getTimestamp());
        } else {
            date = DateUtils.getDateTime((long)(now - errorReplayDuration));
        }
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"if (cache?.frames?.isNot\u2026ReplayDuration)\n        }");
        Date currentSegmentTimestamp = date;
        int segmentId = this.getCurrentSegment().get();
        SentryId replayId = this.getCurrentReplayId().get();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        this.findAndSetStartScreen(currentSegmentTimestamp.getTime());
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.send_replay_for_event", () -> BufferCaptureStrategy.sendReplayForEvent$lambda$4(this, now, currentSegmentTimestamp, replayId, segmentId, height, width, hint, onSegmentSent));
    }

    @Override
    public void onScreenshotRecorded(@NotNull Function2<? super ReplayCache, ? super Long, Unit> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        long frameTimestamp = this.dateProvider.getCurrentTimeMillis();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.add_frame", () -> BufferCaptureStrategy.onScreenshotRecorded$lambda$6(this, store, frameTimestamp));
    }

    private final void deleteFile(File file) {
        if (file == null) {
            return;
        }
        try {
            if (!file.delete()) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete replay segment: %s", objectArray);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to delete replay segment: %s", objectArray);
        }
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        long errorReplayDuration = this.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        long now = this.dateProvider.getCurrentTimeMillis();
        Object object = this.getCache();
        boolean bl = object != null && (object = ((ReplayCache)object).getFrames$sentry_android_replay_release()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            ReplayCache replayCache = this.getCache();
            Intrinsics.checkNotNull((Object)replayCache);
            date = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(replayCache.getFrames$sentry_android_replay_release())).getTimestamp());
        } else {
            date = DateUtils.getDateTime((long)(now - errorReplayDuration));
        }
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"if (cache?.frames?.isNot\u2026ReplayDuration)\n        }");
        Date currentSegmentTimestamp = date;
        int segmentId = this.getCurrentSegment().get();
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.getCurrentReplayId().get();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "BufferCaptureStrategy.onConfigurationChanged", () -> BufferCaptureStrategy.onConfigurationChanged$lambda$7(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width));
        super.onConfigurationChanged(recorderConfig);
    }

    @Override
    @NotNull
    public CaptureStrategy convert() {
        SessionCaptureStrategy captureStrategy = new SessionCaptureStrategy(this.options, this.hub, this.dateProvider, this.getRecorderConfig(), this.getReplayExecutor(), null, 32, null);
        int n = this.getCurrentSegment().get();
        SentryId sentryId = this.getCurrentReplayId().get();
        Intrinsics.checkNotNullExpressionValue((Object)sentryId, (String)"currentReplayId.get()");
        captureStrategy.start(n, sentryId, false);
        return captureStrategy;
    }

    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTouchEvent(event);
        long bufferLimit = this.dateProvider.getCurrentTimeMillis() - this.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        BaseCaptureStrategy.rotateCurrentEvents$default(this, bufferLimit, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndSetStartScreen(long segmentStart) {
        Object object = this.bufferedScreensLock;
        synchronized (object) {
            String startScreen;
            Pair<String, Long> pair;
            block5: {
                boolean bl = false;
                List<Pair<String, Long>> $this$lastOrNull$iv = this.bufferedScreens;
                boolean $i$f$lastOrNull = false;
                ListIterator<Pair<String, Long>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Pair<String, Long> element$iv;
                    Pair<String, Long> pair2 = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    long timestamp = ((Number)pair2.component2()).longValue();
                    if (!(timestamp <= segmentStart)) continue;
                    pair = element$iv;
                    break block5;
                }
                pair = null;
            }
            Pair pair3 = (Pair)pair;
            String string = startScreen = pair3 != null ? (String)pair3.getFirst() : null;
            if (startScreen != null) {
                this.getScreenAtStart().set(startScreen);
            }
            this.bufferedSegments.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$1(BufferCaptureStrategy this$0, IScope it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String screen = it.getScreen();
        if (screen != null) {
            Object object = this$0.bufferedScreensLock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this$0.bufferedScreens.add((Pair<String, Long>)TuplesKt.to((Object)screen, (Object)this$0.dateProvider.getCurrentTimeMillis()));
            }
        }
    }

    private static final void stop$lambda$3(File $replayCacheDir) {
        FileUtils.deleteRecursively((File)$replayCacheDir);
    }

    private static final void sendReplayForEvent$lambda$4(BufferCaptureStrategy this$0, long $now, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width, Hint $hint, Function0 $onSegmentSent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentSegmentTimestamp, (String)"$currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$onSegmentSent, (String)"$onSegmentSent");
        BaseCaptureStrategy.ReplaySegment.Created bufferedSegment = (BaseCaptureStrategy.ReplaySegment.Created)CollectionsKt.removeFirstOrNull(this$0.bufferedSegments);
        while (bufferedSegment != null) {
            BaseCaptureStrategy.ReplaySegment.Created.capture$default(bufferedSegment, this$0.hub, null, 2, null);
            bufferedSegment = (BaseCaptureStrategy.ReplaySegment.Created)CollectionsKt.removeFirstOrNull(this$0.bufferedSegments);
            Thread.sleep(100L);
        }
        long l = $now - $currentSegmentTimestamp.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        BaseCaptureStrategy.ReplaySegment segment = this$0.createSegment(l, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, SentryReplayEvent.ReplayType.BUFFER);
        if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
            BaseCaptureStrategy.ReplaySegment.Created created = (BaseCaptureStrategy.ReplaySegment.Created)segment;
            IHub iHub = this$0.hub;
            Hint hint = $hint;
            if (hint == null) {
                hint = new Hint();
            }
            created.capture(iHub, hint);
            $onSegmentSent.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void onScreenshotRecorded$lambda$6(BufferCaptureStrategy this$0, Function2 $store, long $frameTimestamp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$store, (String)"$store");
        ReplayCache replayCache = this$0.getCache();
        if (replayCache != null) {
            $store.invoke((Object)replayCache, (Object)$frameTimestamp);
        }
        long now = this$0.dateProvider.getCurrentTimeMillis();
        long bufferLimit = now - this$0.options.getExperimental().getSessionReplay().getErrorReplayDuration();
        ReplayCache replayCache2 = this$0.getCache();
        if (replayCache2 != null) {
            replayCache2.rotate(bufferLimit);
        }
        Ref.BooleanRef removed = new Ref.BooleanRef();
        CollectionsKt.removeAll(this$0.bufferedSegments, (Function1)((Function1)new Function1<BaseCaptureStrategy.ReplaySegment.Created, Boolean>(bufferLimit, this$0, removed){
            final /* synthetic */ long $bufferLimit;
            final /* synthetic */ BufferCaptureStrategy this$0;
            final /* synthetic */ Ref.BooleanRef $removed;
            {
                this.$bufferLimit = $bufferLimit;
                this.this$0 = $receiver;
                this.$removed = $removed;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseCaptureStrategy.ReplaySegment.Created it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getReplay().getTimestamp().getTime() < this.$bufferLimit) {
                    this.this$0.getCurrentSegment().decrementAndGet();
                    BufferCaptureStrategy.access$deleteFile(this.this$0, it.getReplay().getVideoFile());
                    this.$removed.element = true;
                    return true;
                }
                return false;
            }
        }));
        if (removed.element) {
            Iterable $this$forEachIndexed$iv = this$0.bufferedSegments;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void segment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BaseCaptureStrategy.ReplaySegment.Created created = (BaseCaptureStrategy.ReplaySegment.Created)item$iv;
                int index = n;
                boolean bl = false;
                segment.setSegmentId(index);
            }
        }
    }

    private static final void onConfigurationChanged$lambda$7(BufferCaptureStrategy this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentSegmentTimestamp, (String)"$currentSegmentTimestamp");
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        BaseCaptureStrategy.ReplaySegment segment = this$0.createSegment($duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, SentryReplayEvent.ReplayType.BUFFER);
        if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
            ((Collection)this$0.bufferedSegments).add(segment);
            this$0.getCurrentSegment().getAndIncrement();
        }
    }

    public static final /* synthetic */ void access$deleteFile(BufferCaptureStrategy $this, File file) {
        $this.deleteFile(file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/capture/BufferCaptureStrategy$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

