/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020$J\u0006\u0010+\u001a\u00020)J\u0006\u0010,\u001a\u00020)J\b\u0010-\u001a\u00020)H\u0016J\u0006\u0010.\u001a\u00020)J\u0006\u0010/\u001a\u00020)J\u0010\u00100\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010$J\u0014\u00101\u001a\u000202*\u00020\u00112\u0006\u00103\u001a\u000204H\u0002J\u0014\u00105\u001a\u00020)*\u00020$2\u0006\u00106\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;)V", "getConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "handler", "Landroid/os/Handler;", "isCapturing", "lastScreenshot", "Landroid/graphics/Bitmap;", "maskingPaint", "Landroid/graphics/Paint;", "getOptions", "()Lio/sentry/SentryOptions;", "pendingViewHierarchy", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "prescaledMatrix", "Landroid/graphics/Matrix;", "recorder", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getRecorder", "()Ljava/util/concurrent/ScheduledExecutorService;", "recorder$delegate", "Lkotlin/Lazy;", "rootView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "singlePixelBitmap", "singlePixelBitmapCanvas", "Landroid/graphics/Canvas;", "bind", "", "root", "capture", "close", "onDraw", "pause", "resume", "unbind", "dominantColorForRect", "", "rect", "Landroid/graphics/Rect;", "traverse", "parentNode", "RecorderExecutorServiceThreadFactory", "sentry-android-replay_release"})
@TargetApi(value=26)
public final class ScreenshotRecorder
implements ViewTreeObserver.OnDrawListener {
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final Lazy recorder$delegate;
    @Nullable
    private WeakReference<View> rootView;
    @NotNull
    private final Handler handler;
    @NotNull
    private final AtomicReference<ViewHierarchyNode> pendingViewHierarchy;
    @NotNull
    private final Paint maskingPaint;
    @NotNull
    private final Bitmap singlePixelBitmap;
    @NotNull
    private final Canvas singlePixelBitmapCanvas;
    @NotNull
    private final Matrix prescaledMatrix;
    @NotNull
    private final AtomicBoolean contentChanged;
    @NotNull
    private final AtomicBoolean isCapturing;
    @Nullable
    private Bitmap lastScreenshot;

    /*
     * WARNING - void declaration
     */
    public ScreenshotRecorder(@NotNull ScreenshotRecorderConfig config, @NotNull SentryOptions options, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback) {
        void $this$prescaledMatrix_u24lambda_u240;
        Matrix matrix;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.config = config;
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.recorder$delegate = LazyKt.lazy((Function0)recorder.2.INSTANCE);
        this.handler = new Handler(Looper.getMainLooper());
        this.pendingViewHierarchy = new AtomicReference();
        this.maskingPaint = new Paint();
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n        1,\u2026ap.Config.ARGB_8888\n    )");
        this.singlePixelBitmap = bitmap;
        this.singlePixelBitmapCanvas = new Canvas(this.singlePixelBitmap);
        Matrix matrix2 = matrix = new Matrix();
        ScreenshotRecorder screenshotRecorder = this;
        boolean bl = false;
        $this$prescaledMatrix_u24lambda_u240.preScale(this.config.getScaleFactorX(), this.config.getScaleFactorY());
        screenshotRecorder.prescaledMatrix = matrix;
        this.contentChanged = new AtomicBoolean(false);
        this.isCapturing = new AtomicBoolean(true);
    }

    @NotNull
    public final ScreenshotRecorderConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final SentryOptions getOptions() {
        return this.options;
    }

    private final ScheduledExecutorService getRecorder() {
        Lazy lazy = this.recorder$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    public final void capture() {
        View root;
        if (!this.isCapturing.get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ScreenshotRecorder is paused, not capturing screenshot", new Object[0]);
            return;
        }
        if (!this.contentChanged.get() && this.lastScreenshot != null) {
            Bitmap bitmap = this.lastScreenshot;
            Intrinsics.checkNotNull((Object)bitmap);
            if (!bitmap.isRecycled()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Content hasn't changed, repeating last known frame", new Object[0]);
                Bitmap bitmap2 = this.lastScreenshot;
                if (bitmap2 != null) {
                    Bitmap it = bitmap2;
                    boolean bl = false;
                    ScreenshotRecorderCallback screenshotRecorderCallback = this.screenshotRecorderCallback;
                    if (screenshotRecorderCallback != null) {
                        Bitmap bitmap3 = it.copy(Bitmap.Config.ARGB_8888, false);
                        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"it.copy(ARGB_8888, false)");
                        screenshotRecorderCallback.onScreenshotRecorded(bitmap3);
                    }
                }
                return;
            }
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Window window = WindowsKt.getPhoneWindow(root);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.config.getRecordingWidth(), (int)this.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026onfig.ARGB_8888\n        )");
        Bitmap bitmap4 = bitmap;
        new Handler(Looper.getMainLooper()).post(() -> ScreenshotRecorder.capture$lambda$4(this, window, bitmap4, root));
    }

    public void onDraw() {
        View root;
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        this.contentChanged.set(true);
    }

    public final void bind(@NotNull View root) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            WeakReference<View> weakReference = this.rootView;
            this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
            WeakReference<View> weakReference2 = this.rootView;
            if (weakReference2 != null) {
                weakReference2.clear();
            }
            this.rootView = new WeakReference<View>(root);
            ViewTreeObserver viewTreeObserver = root.getViewTreeObserver();
            if (viewTreeObserver == null) break block1;
            viewTreeObserver.addOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
    }

    public final void unbind(@Nullable View root) {
        block0: {
            View view = root;
            if (view == null || (view = view.getViewTreeObserver()) == null) break block0;
            view.removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
    }

    public final void pause() {
        this.isCapturing.set(false);
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
    }

    public final void resume() {
        View view = this.rootView;
        if (view != null && (view = (View)view.get()) != null && (view = view.getViewTreeObserver()) != null) {
            view.addOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
        this.isCapturing.set(true);
    }

    public final void close() {
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        Bitmap bitmap = this.lastScreenshot;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.pendingViewHierarchy.set(null);
        this.isCapturing.set(false);
        ScheduledExecutorService scheduledExecutorService = this.getRecorder();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"recorder");
        ExecutorsKt.gracefullyShutdown(scheduledExecutorService, this.options);
    }

    private final int dominantColorForRect(Bitmap $this$dominantColorForRect, Rect rect) {
        Rect visibleRect = new Rect(rect);
        RectF visibleRectF = new RectF(visibleRect);
        this.prescaledMatrix.mapRect(visibleRectF);
        visibleRectF.round(visibleRect);
        this.singlePixelBitmapCanvas.drawBitmap($this$dominantColorForRect, visibleRect, new Rect(0, 0, 1, 1), null);
        return this.singlePixelBitmap.getPixel(0, 0);
    }

    private final void traverse(View $this$traverse, ViewHierarchyNode parentNode) {
        if (!($this$traverse instanceof ViewGroup)) {
            return;
        }
        if (((ViewGroup)$this$traverse).getChildCount() == 0) {
            return;
        }
        ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(((ViewGroup)$this$traverse).getChildCount());
        int n = ((ViewGroup)$this$traverse).getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = ((ViewGroup)$this$traverse).getChildAt(i);
            if (child == null) continue;
            ViewHierarchyNode childNode = ViewHierarchyNode.Companion.fromView(child, parentNode, ((ViewGroup)$this$traverse).indexOfChild(child), this.options);
            childNodes.add(childNode);
            this.traverse(child, childNode);
        }
        parentNode.setChildren((List<? extends ViewHierarchyNode>)childNodes);
    }

    private static final void capture$lambda$4$lambda$3$lambda$2(Bitmap $bitmap, ScreenshotRecorder this$0, ViewHierarchyNode $viewHierarchy) {
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewHierarchy, (String)"$viewHierarchy");
        Canvas canvas = new Canvas($bitmap);
        canvas.setMatrix(this$0.prescaledMatrix);
        $viewHierarchy.traverse((Function1<? super ViewHierarchyNode, Boolean>)((Function1)new Function1<ViewHierarchyNode, Boolean>($viewHierarchy, this$0, $bitmap, canvas){
            final /* synthetic */ ViewHierarchyNode $viewHierarchy;
            final /* synthetic */ ScreenshotRecorder this$0;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Canvas $canvas;
            {
                this.$viewHierarchy = $viewHierarchy;
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                this.$canvas = $canvas;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull ViewHierarchyNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getShouldRedact() && node.getWidth() > 0 && node.getHeight() > 0) {
                    void $this$forEach$iv;
                    Pair pair;
                    if (node.getVisibleRect() == null) {
                        return false;
                    }
                    if (this.$viewHierarchy.isObscured(node)) {
                        return true;
                    }
                    ViewHierarchyNode viewHierarchyNode = node;
                    if (viewHierarchyNode instanceof ViewHierarchyNode.ImageViewHierarchyNode) {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)ScreenshotRecorder.access$dominantColorForRect(this.this$0, this.$bitmap, node.getVisibleRect()));
                    } else if (viewHierarchyNode instanceof ViewHierarchyNode.TextViewHierarchyNode) {
                        Integer n = ((ViewHierarchyNode.TextViewHierarchyNode)node).getDominantColor();
                        pair = TuplesKt.to(ViewsKt.getVisibleRects(((ViewHierarchyNode.TextViewHierarchyNode)node).getLayout(), node.getVisibleRect(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingLeft(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingTop()), (Object)(n != null ? n : -16777216));
                    } else {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)-16777216);
                    }
                    Pair pair2 = pair;
                    List visibleRects = (List)pair2.component1();
                    int color = ((Number)pair2.component2()).intValue();
                    ScreenshotRecorder.access$getMaskingPaint$p(this.this$0).setColor(color);
                    Iterable iterable = visibleRects;
                    Canvas canvas = this.$canvas;
                    ScreenshotRecorder screenshotRecorder = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Rect rect = (Rect)element$iv;
                        boolean bl = false;
                        canvas.drawRoundRect(new RectF(rect), 10.0f, 10.0f, ScreenshotRecorder.access$getMaskingPaint$p(screenshotRecorder));
                    }
                }
                return true;
            }
        }));
        Bitmap screenshot = $bitmap.copy(Bitmap.Config.ARGB_8888, false);
        ScreenshotRecorderCallback screenshotRecorderCallback = this$0.screenshotRecorderCallback;
        if (screenshotRecorderCallback != null) {
            Intrinsics.checkNotNullExpressionValue((Object)screenshot, (String)"screenshot");
            screenshotRecorderCallback.onScreenshotRecorded(screenshot);
        }
        Bitmap bitmap = this$0.lastScreenshot;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this$0.lastScreenshot = screenshot;
        this$0.contentChanged.set(false);
        $bitmap.recycle();
    }

    private static final void capture$lambda$4$lambda$3(ScreenshotRecorder this$0, Bitmap $bitmap, View $root, int copyResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        if (copyResult != 0) {
            Object[] objectArray = new Object[]{copyResult};
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to capture replay recording: %d", objectArray);
            $bitmap.recycle();
            return;
        }
        if (this$0.contentChanged.get()) {
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to determine view hierarchy, not capturing", new Object[0]);
            $bitmap.recycle();
            return;
        }
        ViewHierarchyNode viewHierarchy = ViewHierarchyNode.Companion.fromView($root, null, 0, this$0.options);
        this$0.traverse($root, viewHierarchy);
        this$0.getRecorder().submit(() -> ScreenshotRecorder.capture$lambda$4$lambda$3$lambda$2($bitmap, this$0, viewHierarchy));
    }

    private static final void capture$lambda$4(ScreenshotRecorder this$0, Window $window, Bitmap $bitmap, View $root) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        try {
            this$0.contentChanged.set(false);
            PixelCopy.request((Window)$window, (Bitmap)$bitmap, arg_0 -> ScreenshotRecorder.capture$lambda$4$lambda$3(this$0, $bitmap, $root, arg_0), (Handler)this$0.handler);
        }
        catch (Throwable e) {
            this$0.options.getLogger().log(SentryLevel.WARNING, "Failed to capture replay recording", e);
            $bitmap.recycle();
        }
    }

    public static final /* synthetic */ int access$dominantColorForRect(ScreenshotRecorder $this, Bitmap $receiver, Rect rect) {
        return $this.dominantColorForRect($receiver, rect);
    }

    public static final /* synthetic */ Paint access$getMaskingPaint$p(ScreenshotRecorder $this) {
        return $this.maskingPaint;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

