/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 12\u00020\u0001:\u00011BZ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012%\b\u0002\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J6\u0010\u001d\u001a\u00020\u00172,\u0010\u001e\u001a(\u0012\u0004\u0012\u00020\u0012\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00170\u001f\u00a2\u0006\u0002\b\"H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J2\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00192\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170+H\u0016J \u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020&H\u0016J\b\u00100\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/sentry/android/replay/capture/SessionCaptureStrategy;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Lio/sentry/android/replay/ScreenshotRecorderConfig;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;)V", "convert", "Lio/sentry/android/replay/capture/CaptureStrategy;", "createCurrentSegment", "", "taskName", "", "onSegmentCreated", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "onConfigurationChanged", "onScreenshotRecorded", "store", "Lkotlin/Function2;", "", "frameTimestamp", "Lkotlin/ExtensionFunctionType;", "pause", "sendReplayForEvent", "isCrashed", "", "eventId", "hint", "Lio/sentry/Hint;", "onSegmentSent", "Lkotlin/Function0;", "start", "segmentId", "", "cleanupOldReplays", "stop", "Companion", "sentry-android-replay_release"})
public final class SessionCaptureStrategy
extends BaseCaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private static final String TAG = "SessionCaptureStrategy";

    public SessionCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull ScreenshotRecorderConfig recorderConfig, @Nullable ScheduledExecutorService executor, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        super(options, hub, dateProvider, recorderConfig, executor, replayCacheProvider);
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
    }

    public /* synthetic */ SessionCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, ScreenshotRecorderConfig screenshotRecorderConfig, ScheduledExecutorService scheduledExecutorService, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            scheduledExecutorService = null;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, screenshotRecorderConfig, scheduledExecutorService, (Function1<? super SentryId, ReplayCache>)function1);
    }

    @Override
    public void start(int segmentId, @NotNull SentryId replayId, boolean cleanupOldReplays) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
            super.start(segmentId, replayId, cleanupOldReplays);
            IHub iHub = this.hub;
            if (iHub == null) break block0;
            iHub.configureScope(arg_0 -> SessionCaptureStrategy.start$lambda$0(this, arg_0));
        }
    }

    @Override
    public void pause() {
        this.createCurrentSegment("pause", (Function1<? super BaseCaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<BaseCaptureStrategy.ReplaySegment, Unit>(this){
            final /* synthetic */ SessionCaptureStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BaseCaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
                    BaseCaptureStrategy.ReplaySegment.Created.capture$default((BaseCaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                    this.this$0.getCurrentSegment().getAndIncrement();
                }
            }
        }));
        super.pause();
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.getCache();
        File replayCacheDir2 = replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
        this.createCurrentSegment("stop", (Function1<? super BaseCaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<BaseCaptureStrategy.ReplaySegment, Unit>(this, replayCacheDir2){
            final /* synthetic */ SessionCaptureStrategy this$0;
            final /* synthetic */ File $replayCacheDir;
            {
                this.this$0 = $receiver;
                this.$replayCacheDir = $replayCacheDir;
                super(1);
            }

            public final void invoke(@NotNull BaseCaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
                    BaseCaptureStrategy.ReplaySegment.Created.capture$default((BaseCaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                }
                FileUtils.deleteRecursively((File)this.$replayCacheDir);
            }
        }));
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(SessionCaptureStrategy::stop$lambda$1);
        }
        super.stop();
    }

    @Override
    public void sendReplayForEvent(boolean isCrashed, @Nullable String eventId, @Nullable Hint hint, @NotNull Function0<Unit> onSegmentSent) {
        Intrinsics.checkNotNullParameter(onSegmentSent, (String)"onSegmentSent");
        if (!isCrashed) {
            Object[] objectArray = new Object[]{eventId};
            this.options.getLogger().log(SentryLevel.DEBUG, "Replay is already running in 'session' mode, not capturing for event %s", objectArray);
        } else {
            Object[] objectArray = new Object[]{eventId};
            this.options.getLogger().log(SentryLevel.DEBUG, "Replay is already running in 'session' mode, capturing last segment for crashed event %s", objectArray);
            this.createCurrentSegment("send_replay_for_event", (Function1<? super BaseCaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<BaseCaptureStrategy.ReplaySegment, Unit>(this, hint){
                final /* synthetic */ SessionCaptureStrategy this$0;
                final /* synthetic */ Hint $hint;
                {
                    this.this$0 = $receiver;
                    this.$hint = $hint;
                    super(1);
                }

                public final void invoke(@NotNull BaseCaptureStrategy.ReplaySegment segment) {
                    Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                    if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
                        BaseCaptureStrategy.ReplaySegment.Created created = (BaseCaptureStrategy.ReplaySegment.Created)segment;
                        IHub iHub = SessionCaptureStrategy.access$getHub$p(this.this$0);
                        Hint hint = this.$hint;
                        if (hint == null) {
                            hint = new Hint();
                        }
                        created.capture(iHub, hint);
                    }
                }
            }));
        }
    }

    @Override
    public void onScreenshotRecorded(@NotNull Function2<? super ReplayCache, ? super Long, Unit> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        long frameTimestamp = this.dateProvider.getCurrentTimeMillis();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "SessionCaptureStrategy.add_frame", () -> SessionCaptureStrategy.onScreenshotRecorded$lambda$2(this, store, frameTimestamp, height, width));
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        Date currentSegmentTimestamp = this.getSegmentTimestamp().get();
        this.createCurrentSegment("onConfigurationChanged", (Function1<? super BaseCaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<BaseCaptureStrategy.ReplaySegment, Unit>(this, currentSegmentTimestamp){
            final /* synthetic */ SessionCaptureStrategy this$0;
            final /* synthetic */ Date $currentSegmentTimestamp;
            {
                this.this$0 = $receiver;
                this.$currentSegmentTimestamp = $currentSegmentTimestamp;
                super(1);
            }

            public final void invoke(@NotNull BaseCaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
                    BaseCaptureStrategy.ReplaySegment.Created.capture$default((BaseCaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                    this.this$0.getCurrentSegment().getAndIncrement();
                    this.this$0.getSegmentTimestamp().set(DateUtils.getDateTime((long)(this.$currentSegmentTimestamp.getTime() + ((BaseCaptureStrategy.ReplaySegment.Created)segment).getVideoDuration())));
                }
            }
        }));
        super.onConfigurationChanged(recorderConfig);
    }

    @Override
    @NotNull
    public CaptureStrategy convert() {
        return this;
    }

    private final void createCurrentSegment(String taskName, Function1<? super BaseCaptureStrategy.ReplaySegment, Unit> onSegmentCreated) {
        long now = this.dateProvider.getCurrentTimeMillis();
        Date currentSegmentTimestamp = this.getSegmentTimestamp().get();
        int segmentId = this.getCurrentSegment().get();
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.getCurrentReplayId().get();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "SessionCaptureStrategy." + taskName, () -> SessionCaptureStrategy.createCurrentSegment$lambda$3(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width, onSegmentCreated));
    }

    private static final void start$lambda$0(SessionCaptureStrategy this$0, IScope it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(this$0.getCurrentReplayId().get());
    }

    private static final void stop$lambda$1(IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(SentryId.EMPTY_ID);
    }

    private static final void onScreenshotRecorded$lambda$2(SessionCaptureStrategy this$0, Function2 $store, long $frameTimestamp, int $height, int $width) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$store, (String)"$store");
        ReplayCache replayCache = this$0.getCache();
        if (replayCache != null) {
            $store.invoke((Object)replayCache, (Object)$frameTimestamp);
        }
        long now = this$0.dateProvider.getCurrentTimeMillis();
        if (now - this$0.getSegmentTimestamp().get().getTime() >= this$0.options.getExperimental().getSessionReplay().getSessionSegmentDuration()) {
            Date currentSegmentTimestamp = this$0.getSegmentTimestamp().get();
            int segmentId = this$0.getCurrentSegment().get();
            SentryId replayId = this$0.getCurrentReplayId().get();
            BaseCaptureStrategy baseCaptureStrategy = this$0;
            long l = this$0.options.getExperimental().getSessionReplay().getSessionSegmentDuration();
            Intrinsics.checkNotNullExpressionValue((Object)currentSegmentTimestamp, (String)"currentSegmentTimestamp");
            Intrinsics.checkNotNullExpressionValue((Object)replayId, (String)"replayId");
            BaseCaptureStrategy.ReplaySegment segment = BaseCaptureStrategy.createSegment$default(baseCaptureStrategy, l, currentSegmentTimestamp, replayId, segmentId, $height, $width, null, 64, null);
            if (segment instanceof BaseCaptureStrategy.ReplaySegment.Created) {
                BaseCaptureStrategy.ReplaySegment.Created.capture$default((BaseCaptureStrategy.ReplaySegment.Created)segment, this$0.hub, null, 2, null);
                this$0.getCurrentSegment().getAndIncrement();
                this$0.getSegmentTimestamp().set(DateUtils.getDateTime((long)(currentSegmentTimestamp.getTime() + ((BaseCaptureStrategy.ReplaySegment.Created)segment).getVideoDuration())));
            }
        } else if (now - this$0.getReplayStartTimestamp().get() >= this$0.options.getExperimental().getSessionReplay().getSessionDuration()) {
            this$0.stop();
            this$0.options.getLogger().log(SentryLevel.INFO, "Session replay deadline exceeded (1h), stopping recording", new Object[0]);
        }
    }

    private static final void createCurrentSegment$lambda$3(SessionCaptureStrategy this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width, Function1 $onSegmentCreated) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onSegmentCreated, (String)"$onSegmentCreated");
        BaseCaptureStrategy baseCaptureStrategy = this$0;
        Intrinsics.checkNotNullExpressionValue((Object)$currentSegmentTimestamp, (String)"currentSegmentTimestamp");
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        BaseCaptureStrategy.ReplaySegment segment = BaseCaptureStrategy.createSegment$default(baseCaptureStrategy, $duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, null, 64, null);
        $onSegmentCreated.invoke((Object)segment);
    }

    public static final /* synthetic */ IHub access$getHub$p(SessionCaptureStrategy $this) {
        return $this.hub;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/capture/SessionCaptureStrategy$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

