/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.okhttp;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import io.sentry.util.Platform;
import io.sentry.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J-\u0010\u0014\u001a\u00020\u00152%\b\u0002\u0010\u0016\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017J5\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2%\b\u0002\u0010\u0016\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017J\u0010\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/sentry/android/okhttp/SentryOkHttpEvent;", "", "hub", "Lio/sentry/IHub;", "request", "Lokhttp3/Request;", "(Lio/sentry/IHub;Lokhttp3/Request;)V", "breadcrumb", "Lio/sentry/Breadcrumb;", "callRootSpan", "Lio/sentry/ISpan;", "getCallRootSpan$sentry_android_okhttp_release", "()Lio/sentry/ISpan;", "eventSpans", "", "", "response", "Lokhttp3/Response;", "findParentSpan", "event", "finishEvent", "", "beforeFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "span", "finishSpan", "setError", "errorMessage", "setProtocol", "protocolName", "setRequestBodySize", "byteCount", "", "setResponse", "setResponseBodySize", "startSpan", "sentry-android-okhttp_release"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpEvent.kt\nio/sentry/android/okhttp/SentryOkHttpEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n766#3:154\n857#3,2:155\n1855#3,2:157\n*S KotlinDebug\n*F\n+ 1 SentryOkHttpEvent.kt\nio/sentry/android/okhttp/SentryOkHttpEvent\n*L\n126#1:154\n126#1:155,2\n126#1:157,2\n*E\n"})
public final class SentryOkHttpEvent {
    @NotNull
    private final IHub hub;
    @NotNull
    private final Request request;
    @NotNull
    private final Map<String, ISpan> eventSpans;
    @NotNull
    private final Breadcrumb breadcrumb;
    @Nullable
    private final ISpan callRootSpan;
    @Nullable
    private Response response;

    public SentryOkHttpEvent(@NotNull IHub hub, @NotNull Request request) {
        block4: {
            ISpan parentSpan;
            Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.hub = hub;
            this.request = request;
            this.eventSpans = new ConcurrentHashMap();
            UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)this.request.url().toString());
            Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(request.url.toString())");
            UrlUtils.UrlDetails urlDetails2 = urlDetails;
            String string = urlDetails2.getUrlOrFallback();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDetails.urlOrFallback");
            String url = string;
            String host = this.request.url().host();
            String encodedPath = this.request.url().encodedPath();
            String method = this.request.method();
            ISpan iSpan = parentSpan = Platform.isAndroid() ? (ISpan)this.hub.getTransaction() : this.hub.getSpan();
            ISpan iSpan2 = this.callRootSpan = iSpan != null ? iSpan.startChild("http.client", method + ' ' + url) : null;
            Object object = iSpan2 != null ? iSpan2.getSpanContext() : null;
            if (object != null) {
                object.setOrigin("auto.http.okhttp");
            }
            urlDetails2.applyToSpan(this.callRootSpan);
            Breadcrumb breadcrumb = Breadcrumb.http((String)url, (String)method);
            Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"http(url, method)");
            this.breadcrumb = breadcrumb;
            this.breadcrumb.setData("host", (Object)host);
            this.breadcrumb.setData("path", (Object)encodedPath);
            ISpan iSpan3 = this.callRootSpan;
            if (iSpan3 != null) {
                iSpan3.setData("url", (Object)url);
            }
            ISpan iSpan4 = this.callRootSpan;
            if (iSpan4 != null) {
                iSpan4.setData("host", (Object)host);
            }
            ISpan iSpan5 = this.callRootSpan;
            if (iSpan5 != null) {
                iSpan5.setData("path", (Object)encodedPath);
            }
            ISpan iSpan6 = this.callRootSpan;
            if (iSpan6 == null) break block4;
            String string2 = method;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
            iSpan6.setData("http.request.method", (Object)string3);
        }
    }

    @Nullable
    public final ISpan getCallRootSpan$sentry_android_okhttp_release() {
        return this.callRootSpan;
    }

    public final void setResponse(@NotNull Response response) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.response = response;
            this.breadcrumb.setData("protocol", (Object)response.protocol().name());
            this.breadcrumb.setData("status_code", (Object)response.code());
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)response.protocol().name());
            }
            ISpan iSpan2 = this.callRootSpan;
            if (iSpan2 == null) break block1;
            iSpan2.setData("http.response.status_code", (Object)response.code());
        }
    }

    public final void setProtocol(@Nullable String protocolName) {
        block1: {
            if (protocolName == null) break block1;
            this.breadcrumb.setData("protocol", (Object)protocolName);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)protocolName);
            }
        }
    }

    public final void setRequestBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("request_content_length", (Object)byteCount);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("http.request_content_length", (Object)byteCount);
            }
        }
    }

    public final void setResponseBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("response_content_length", (Object)byteCount);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("http.response_content_length", (Object)byteCount);
            }
        }
    }

    public final void setError(@Nullable String errorMessage) {
        block1: {
            if (errorMessage == null) break block1;
            this.breadcrumb.setData("error_message", (Object)errorMessage);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("error_message", (Object)errorMessage);
            }
        }
    }

    public final void startSpan(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ISpan parentSpan = this.findParentSpan(event);
        ISpan iSpan = parentSpan;
        if (iSpan == null || (iSpan = iSpan.startChild("http.client." + event)) == null) {
            return;
        }
        ISpan span = iSpan;
        span.getSpanContext().setOrigin("auto.http.okhttp");
        this.eventSpans.put(event, span);
    }

    public final void finishSpan(@NotNull String event, @Nullable Function1<? super ISpan, Unit> beforeFinish) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ISpan iSpan = this.eventSpans.get(event);
        if (iSpan == null) {
            return;
        }
        ISpan span = iSpan;
        ISpan parentSpan = this.findParentSpan(event);
        Function1<? super ISpan, Unit> function1 = beforeFinish;
        if (function1 != null) {
            function1.invoke((Object)span);
        }
        if (parentSpan != null && !Intrinsics.areEqual((Object)parentSpan, (Object)this.callRootSpan)) {
            Function1<? super ISpan, Unit> function12 = beforeFinish;
            if (function12 != null) {
                function12.invoke((Object)parentSpan);
            }
        }
        ISpan iSpan2 = this.callRootSpan;
        if (iSpan2 != null) {
            ISpan it = iSpan2;
            boolean bl = false;
            Function1<? super ISpan, Unit> function13 = beforeFinish;
            if (function13 != null) {
                function13.invoke((Object)it);
            }
        }
        span.finish();
    }

    public static /* synthetic */ void finishSpan$default(SentryOkHttpEvent sentryOkHttpEvent, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        sentryOkHttpEvent.finishSpan(string, (Function1<? super ISpan, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void finishEvent(@Nullable Function1<? super ISpan, Unit> beforeFinish) {
        void $this$filterTo$iv$iv;
        if (this.callRootSpan == null) {
            return;
        }
        Iterable $this$filter$iv = this.eventSpans.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ISpan it = (ISpan)element$iv$iv;
            boolean bl = false;
            if (!(!it.isFinished())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ISpan it = (ISpan)element$iv;
            boolean bl = false;
            SpanStatus spanStatus = it.getStatus();
            if (spanStatus == null) {
                spanStatus = SpanStatus.INTERNAL_ERROR;
            }
            it.finish(spanStatus);
        }
        Function1<? super ISpan, Unit> function1 = beforeFinish;
        if (function1 != null) {
            function1.invoke((Object)this.callRootSpan);
        }
        this.callRootSpan.finish();
        Hint hint = new Hint();
        hint.set("okHttp:request", (Object)this.request);
        Response response = this.response;
        if (response != null) {
            Response it = response;
            boolean bl = false;
            hint.set("okHttp:response", (Object)it);
        }
        this.hub.addBreadcrumb(this.breadcrumb, hint);
    }

    public static /* synthetic */ void finishEvent$default(SentryOkHttpEvent sentryOkHttpEvent, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        sentryOkHttpEvent.finishEvent((Function1<? super ISpan, Unit>)function1);
    }

    private final ISpan findParentSpan(String event) {
        ISpan iSpan;
        ISpan iSpan2;
        switch (event) {
            case "secure_connect": {
                iSpan2 = this.eventSpans.get("connect");
                break;
            }
            case "request_headers": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "request_body": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "response_headers": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "response_body": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            default: {
                iSpan2 = iSpan = this.callRootSpan;
            }
        }
        if (iSpan2 == null) {
            iSpan = this.callRootSpan;
        }
        return iSpan;
    }
}

