/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.NativeModuleListLoader;
import io.sentry.protocol.DebugImage;
import io.sentry.util.Objects;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DebugImagesLoader
implements IDebugImagesLoader {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final NativeModuleListLoader moduleListLoader;
    @Nullable
    private static volatile List<DebugImage> debugImages;
    @NotNull
    private static final Object debugImagesLock;

    public DebugImagesLoader(@NotNull SentryAndroidOptions options, @NotNull NativeModuleListLoader moduleListLoader) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"The SentryAndroidOptions is required.");
        this.moduleListLoader = (NativeModuleListLoader)Objects.requireNonNull((Object)moduleListLoader, (String)"The NativeModuleListLoader is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<DebugImage> loadDebugImages() {
        Object object = debugImagesLock;
        synchronized (object) {
            if (debugImages == null) {
                try {
                    DebugImage[] debugImagesArr = this.moduleListLoader.loadModuleList();
                    if (debugImagesArr != null) {
                        debugImages = Arrays.asList(debugImagesArr);
                        this.options.getLogger().log(SentryLevel.DEBUG, "Debug images loaded: %d", new Object[]{debugImages.size()});
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to load debug images.", new Object[0]);
                }
            }
        }
        return debugImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<DebugImage> loadDebugImagesForAddresses(@NotNull Set<String> addresses) {
        Object object = debugImagesLock;
        synchronized (object) {
            @Nullable List<DebugImage> allDebugImages = this.loadDebugImages();
            if (allDebugImages == null) {
                return null;
            }
            if (addresses.isEmpty()) {
                return null;
            }
            Set<DebugImage> referencedImages = this.filterImagesByAddresses(allDebugImages, addresses);
            if (referencedImages.isEmpty()) {
                this.options.getLogger().log(SentryLevel.WARNING, "No debug images found for any of the %d addresses.", new Object[]{addresses.size()});
                return null;
            }
            return referencedImages;
        }
    }

    @NotNull
    private Set<DebugImage> filterImagesByAddresses(@NotNull List<DebugImage> images, @NotNull Set<String> addresses) {
        HashSet<DebugImage> result = new HashSet<DebugImage>();
        block4: for (int i = 0; i < images.size(); ++i) {
            @NotNull DebugImage image = images.get(i);
            DebugImage nextDebugImage = i + 1 < images.size() ? images.get(i + 1) : null;
            String nextDebugImageAddress = nextDebugImage != null ? nextDebugImage.getImageAddr() : null;
            for (String rawAddress : addresses) {
                try {
                    long address = Long.parseLong(rawAddress.replace("0x", ""), 16);
                    @Nullable String imageAddress = image.getImageAddr();
                    if (imageAddress == null) continue;
                    try {
                        long imageStart = Long.parseLong(imageAddress.replace("0x", ""), 16);
                        @Nullable Long imageSize = image.getImageSize();
                        long imageEnd = imageSize != null ? imageStart + imageSize : (nextDebugImageAddress != null ? Long.parseLong(nextDebugImageAddress.replace("0x", ""), 16) : Long.MAX_VALUE);
                        if (address < imageStart || address >= imageEnd) continue;
                        result.add(image);
                        continue block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDebugImages() {
        Object object = debugImagesLock;
        synchronized (object) {
            try {
                this.moduleListLoader.clearModuleList();
                this.options.getLogger().log(SentryLevel.INFO, "Debug images cleared.", new Object[0]);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to clear debug images.", new Object[0]);
            }
            debugImages = null;
        }
    }

    @VisibleForTesting
    @Nullable
    List<DebugImage> getCachedDebugImages() {
        return debugImages;
    }

    static {
        debugImagesLock = new Object();
    }
}

