/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.IScopeObserver;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.DebugImagesLoader;
import io.sentry.android.ndk.NativeModuleListLoader;
import io.sentry.android.ndk.NdkScopeObserver;
import io.sentry.android.ndk.SentryNdkUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SentryNdk {
    @NotNull
    private static final CountDownLatch loadLibraryLatch = new CountDownLatch(1);

    private SentryNdk() {
    }

    private static native void initSentryNative(@NotNull SentryAndroidOptions var0);

    private static native void shutdown();

    public static void init(@NotNull SentryAndroidOptions options) {
        SentryNdkUtil.addPackage(options.getSdkVersion());
        try {
            if (loadLibraryLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                SentryNdk.initSentryNative(options);
                if (options.isEnableScopeSync()) {
                    options.addScopeObserver((IScopeObserver)new NdkScopeObserver((SentryOptions)options));
                }
            } else {
                throw new IllegalStateException("Timeout waiting for Sentry NDK library to load");
            }
            options.setDebugImagesLoader((IDebugImagesLoader)new DebugImagesLoader(options, new NativeModuleListLoader()));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread interrupted while waiting for NDK libs to be loaded", e);
        }
    }

    public static void close() {
        try {
            if (!loadLibraryLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Timeout waiting for Sentry NDK library to load");
            }
            SentryNdk.shutdown();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread interrupted while waiting for NDK libs to be loaded", e);
        }
    }

    static {
        new Thread(() -> {
            try {
                System.loadLibrary("log");
                System.loadLibrary("sentry");
                System.loadLibrary("sentry-android");
            }
            catch (Throwable throwable) {
            }
            finally {
                loadLibraryLatch.countDown();
            }
        }, "SentryNdkLoadLibs").start();
    }
}

