/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.navigation;

import android.content.res.Resources;
import android.os.Bundle;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.ITransaction;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SpanContext;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.TracingUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB1\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002J\"\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J.\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u001c\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017*\u0004\u0018\u00010\u000fH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/sentry/android/navigation/SentryNavigationListener;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "hub", "Lio/sentry/IHub;", "enableNavigationBreadcrumbs", "", "enableNavigationTracing", "traceOriginAppendix", "", "(Lio/sentry/IHub;ZZLjava/lang/String;)V", "activeTransaction", "Lio/sentry/ITransaction;", "isPerformanceEnabled", "()Z", "previousArgs", "Landroid/os/Bundle;", "previousDestinationRef", "Ljava/lang/ref/WeakReference;", "Landroidx/navigation/NavDestination;", "addBreadcrumb", "", "destination", "arguments", "", "", "onDestinationChanged", "controller", "Landroidx/navigation/NavController;", "startTracing", "stopTracing", "refined", "Companion", "sentry-android-navigation_release"})
@SourceDebugExtension(value={"SMAP\nSentryNavigationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryNavigationListener.kt\nio/sentry/android/navigation/SentryNavigationListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n764#3:193\n855#3,2:194\n1269#3,2:196\n1283#3,4:198\n*S KotlinDebug\n*F\n+ 1 SentryNavigationListener.kt\nio/sentry/android/navigation/SentryNavigationListener\n*L\n182#1:193\n182#1:194,2\n184#1:196,2\n184#1:198,4\n*E\n"})
public final class SentryNavigationListener
implements NavController.OnDestinationChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IHub hub;
    private final boolean enableNavigationBreadcrumbs;
    private final boolean enableNavigationTracing;
    @Nullable
    private final String traceOriginAppendix;
    @Nullable
    private WeakReference<NavDestination> previousDestinationRef;
    @Nullable
    private Bundle previousArgs;
    @Nullable
    private ITransaction activeTransaction;
    @NotNull
    public static final String NAVIGATION_OP = "navigation";

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub, boolean enableNavigationBreadcrumbs, boolean enableNavigationTracing, @Nullable String traceOriginAppendix) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.enableNavigationBreadcrumbs = enableNavigationBreadcrumbs;
        this.enableNavigationTracing = enableNavigationTracing;
        this.traceOriginAppendix = traceOriginAppendix;
        IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-navigation", "7.4.0");
    }

    public /* synthetic */ SentryNavigationListener(IHub iHub, boolean bl, boolean bl2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(iHub, bl, bl2, string);
    }

    private final boolean isPerformanceEnabled() {
        return this.hub.getOptions().isTracingEnabled() && this.enableNavigationTracing;
    }

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Map<String, Object> toArguments = this.refined(arguments);
        this.addBreadcrumb(destination, toArguments);
        this.startTracing(controller, destination, toArguments);
        this.previousDestinationRef = new WeakReference<NavDestination>(destination);
        this.previousArgs = arguments;
    }

    private final void addBreadcrumb(NavDestination destination, Map<String, ? extends Object> arguments) {
        String to;
        Object object;
        Object it;
        String from;
        Breadcrumb breadcrumb;
        if (!this.enableNavigationBreadcrumbs) {
            return;
        }
        Breadcrumb $this$addBreadcrumb_u24lambda_u242 = breadcrumb = new Breadcrumb();
        boolean bl = false;
        $this$addBreadcrumb_u24lambda_u242.setType(NAVIGATION_OP);
        $this$addBreadcrumb_u24lambda_u242.setCategory(NAVIGATION_OP);
        NavDestination navDestination = this.previousDestinationRef;
        String string = from = navDestination != null && (navDestination = (NavDestination)navDestination.get()) != null ? navDestination.getRoute() : null;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            Map map = $this$addBreadcrumb_u24lambda_u242.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            Map map2 = map;
            String string2 = "from";
            object = '/' + (String)it;
            map2.put(string2, object);
        }
        Map<String, Object> fromArguments = this.refined(this.previousArgs);
        if (!fromArguments.isEmpty()) {
            Map map = $this$addBreadcrumb_u24lambda_u242.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            it = map;
            it.put("from_arguments", fromArguments);
        }
        String string3 = to = destination.getRoute();
        if (string3 != null) {
            String it2 = string3;
            boolean bl3 = false;
            Map map = $this$addBreadcrumb_u24lambda_u242.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            object = map;
            String string4 = "to";
            String string5 = '/' + it2;
            object.put(string4, string5);
        }
        if (!arguments.isEmpty()) {
            Map map = $this$addBreadcrumb_u24lambda_u242.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            Map map3 = map;
            map3.put("to_arguments", arguments);
        }
        $this$addBreadcrumb_u24lambda_u242.setLevel(SentryLevel.INFO);
        Breadcrumb breadcrumb2 = breadcrumb;
        Hint hint = new Hint();
        hint.set("android:navigationDestination", (Object)destination);
        this.hub.addBreadcrumb(breadcrumb2, hint);
    }

    private final void startTracing(NavController controller, NavDestination destination, Map<String, ? extends Object> arguments) {
        String string;
        SpanContext spanContext;
        ITransaction transaction;
        block12: {
            block11: {
                String string2;
                if (!this.isPerformanceEnabled()) {
                    TracingUtils.startNewTrace((IHub)this.hub);
                    return;
                }
                if (this.activeTransaction != null) {
                    this.stopTracing();
                }
                if (Intrinsics.areEqual((Object)destination.getNavigatorName(), (Object)"activity")) {
                    this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Navigating to activity destination, no transaction captured.", new Object[0]);
                    return;
                }
                String string3 = destination.getRoute();
                if (string3 == null) {
                    try {
                        string2 = controller.getContext().getResources().getResourceEntryName(destination.getId());
                    }
                    catch (Resources.NotFoundException e) {
                        this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Destination id cannot be retrieved from Resources, no transaction captured.", new Object[0]);
                        return;
                    }
                    string3 = string2;
                }
                String name = string3;
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string4 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                name = stringBuilder.append(StringsKt.substringBefore$default((String)string4, (char)'/', null, (int)2, null)).toString();
                String it = string2 = new TransactionOptions();
                boolean bl = false;
                it.setWaitForChildren(true);
                it.setIdleTimeout(this.hub.getOptions().getIdleTimeout());
                it.setDeadlineTimeout(Long.valueOf(300000L));
                it.setTrimEnd(true);
                String transactionOptions = string2;
                ITransaction iTransaction = this.hub.startTransaction(new TransactionContext(name, TransactionNameSource.ROUTE, NAVIGATION_OP), (TransactionOptions)transactionOptions);
                Intrinsics.checkNotNullExpressionValue((Object)iTransaction, (String)"hub.startTransaction(\n  \u2026nsactionOptions\n        )");
                transaction = iTransaction;
                spanContext = transaction.getSpanContext();
                string = this.traceOriginAppendix;
                if (string == null) break block11;
                String string5 = string;
                SpanContext spanContext2 = spanContext;
                boolean bl2 = false;
                String string6 = "auto.navigation." + this.traceOriginAppendix;
                spanContext = spanContext2;
                string = string6;
                if (string6 != null) break block12;
            }
            string = "auto.navigation";
        }
        spanContext.setOrigin(string);
        if (!arguments.isEmpty()) {
            transaction.setData("arguments", arguments);
        }
        this.hub.configureScope(arg_0 -> SentryNavigationListener.startTracing$lambda$6(transaction, arg_0));
        this.activeTransaction = transaction;
    }

    private final void stopTracing() {
        ITransaction iTransaction = this.activeTransaction;
        if (iTransaction == null || (iTransaction = iTransaction.getStatus()) == null) {
            iTransaction = SpanStatus.OK;
        }
        Intrinsics.checkNotNullExpressionValue((Object)iTransaction, (String)"activeTransaction?.status ?: SpanStatus.OK");
        ITransaction status = iTransaction;
        ITransaction iTransaction2 = this.activeTransaction;
        if (iTransaction2 != null) {
            iTransaction2.finish((SpanStatus)status);
        }
        this.hub.configureScope(arg_0 -> SentryNavigationListener.stopTracing$lambda$8(this, arg_0));
        this.activeTransaction = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> refined(Bundle $this$refined) {
        Map map;
        Bundle bundle = $this$refined;
        if (bundle != null) {
            void $this$associateWith$iv;
            String it;
            void $this$filterTo$iv$iv;
            Bundle args = bundle;
            boolean bl = false;
            Set set = args.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"args.keySet()");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"android-support-nav:controller:deepLinkIntent"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                it = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl3 = false;
                Object object = args.get(it);
                map2.put(t, object);
            }
            map = result$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub, boolean enableNavigationBreadcrumbs, boolean enableNavigationTracing) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, enableNavigationBreadcrumbs, enableNavigationTracing, null, 8, null);
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub, boolean enableNavigationBreadcrumbs) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, enableNavigationBreadcrumbs, false, null, 12, null);
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, false, false, null, 14, null);
    }

    @JvmOverloads
    public SentryNavigationListener() {
        this(null, false, false, null, 15, null);
    }

    private static final void startTracing$lambda$6$lambda$5(IScope $scope, ITransaction $transaction, ITransaction tx) {
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        Intrinsics.checkNotNullParameter((Object)$transaction, (String)"$transaction");
        if (tx == null) {
            $scope.setTransaction($transaction);
        }
    }

    private static final void startTracing$lambda$6(ITransaction $transaction, IScope scope) {
        Intrinsics.checkNotNullParameter((Object)$transaction, (String)"$transaction");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        scope.withTransaction(arg_0 -> SentryNavigationListener.startTracing$lambda$6$lambda$5(scope, $transaction, arg_0));
    }

    private static final void stopTracing$lambda$8$lambda$7(SentryNavigationListener this$0, IScope $scope, ITransaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        if (Intrinsics.areEqual((Object)tx, (Object)this$0.activeTransaction)) {
            $scope.clearTransaction();
        }
    }

    private static final void stopTracing$lambda$8(SentryNavigationListener this$0, IScope scope) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        scope.withTransaction(arg_0 -> SentryNavigationListener.stopTracing$lambda$8$lambda$7(this$0, scope, arg_0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/navigation/SentryNavigationListener$Companion;", "", "()V", "NAVIGATION_OP", "", "sentry-android-navigation_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

