/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import android.os.Looper;
import android.os.SystemClock;
import io.sentry.ISpan;
import io.sentry.Instrumenter;
import io.sentry.SentryDate;
import io.sentry.SpanStatus;
import io.sentry.android.core.AndroidDateUtils;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.AppStartMetrics;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ActivityLifecycleSpanHelper {
    private static final String APP_METRICS_ACTIVITIES_OP = "activity.load";
    @NotNull
    private final String activityName;
    @Nullable
    private SentryDate onCreateStartTimestamp = null;
    @Nullable
    private SentryDate onStartStartTimestamp = null;
    @Nullable
    private ISpan onCreateSpan = null;
    @Nullable
    private ISpan onStartSpan = null;

    public ActivityLifecycleSpanHelper(@NotNull String activityName) {
        this.activityName = activityName;
    }

    public void setOnCreateStartTimestamp(@NotNull SentryDate onCreateStartTimestamp) {
        this.onCreateStartTimestamp = onCreateStartTimestamp;
    }

    public void setOnStartStartTimestamp(@NotNull SentryDate onStartStartTimestamp) {
        this.onStartStartTimestamp = onStartStartTimestamp;
    }

    public void createAndStopOnCreateSpan(@Nullable ISpan parentSpan) {
        if (this.onCreateStartTimestamp != null && parentSpan != null) {
            this.onCreateSpan = this.createLifecycleSpan(parentSpan, this.activityName + ".onCreate", this.onCreateStartTimestamp);
            this.onCreateSpan.finish();
        }
    }

    public void createAndStopOnStartSpan(@Nullable ISpan parentSpan) {
        if (this.onStartStartTimestamp != null && parentSpan != null) {
            this.onStartSpan = this.createLifecycleSpan(parentSpan, this.activityName + ".onStart", this.onStartStartTimestamp);
            this.onStartSpan.finish();
        }
    }

    @Nullable
    public ISpan getOnCreateSpan() {
        return this.onCreateSpan;
    }

    @Nullable
    public ISpan getOnStartSpan() {
        return this.onStartSpan;
    }

    @Nullable
    public SentryDate getOnCreateStartTimestamp() {
        return this.onCreateStartTimestamp;
    }

    @Nullable
    public SentryDate getOnStartStartTimestamp() {
        return this.onStartStartTimestamp;
    }

    public void saveSpanToAppStartMetrics() {
        if (this.onCreateSpan == null || this.onStartSpan == null) {
            return;
        }
        @Nullable SentryDate onCreateFinishDate = this.onCreateSpan.getFinishDate();
        @Nullable SentryDate onStartFinishDate = this.onStartSpan.getFinishDate();
        if (onCreateFinishDate == null || onStartFinishDate == null) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        @NotNull SentryDate nowDate = AndroidDateUtils.getCurrentSentryDateTime();
        long onCreateShiftMs = TimeUnit.NANOSECONDS.toMillis(nowDate.diff(this.onCreateSpan.getStartDate()));
        long onCreateStopShiftMs = TimeUnit.NANOSECONDS.toMillis(nowDate.diff(onCreateFinishDate));
        long onStartShiftMs = TimeUnit.NANOSECONDS.toMillis(nowDate.diff(this.onStartSpan.getStartDate()));
        long onStartStopShiftMs = TimeUnit.NANOSECONDS.toMillis(nowDate.diff(onStartFinishDate));
        ActivityLifecycleTimeSpan activityLifecycleTimeSpan = new ActivityLifecycleTimeSpan();
        activityLifecycleTimeSpan.getOnCreate().setup(this.onCreateSpan.getDescription(), TimeUnit.NANOSECONDS.toMillis(this.onCreateSpan.getStartDate().nanoTimestamp()), now - onCreateShiftMs, now - onCreateStopShiftMs);
        activityLifecycleTimeSpan.getOnStart().setup(this.onStartSpan.getDescription(), TimeUnit.NANOSECONDS.toMillis(this.onStartSpan.getStartDate().nanoTimestamp()), now - onStartShiftMs, now - onStartStopShiftMs);
        AppStartMetrics.getInstance().addActivityLifecycleTimeSpans(activityLifecycleTimeSpan);
    }

    @NotNull
    private ISpan createLifecycleSpan(@NotNull ISpan parentSpan, @NotNull String description, @NotNull SentryDate startTimestamp) {
        @NotNull ISpan span = parentSpan.startChild(APP_METRICS_ACTIVITIES_OP, description, startTimestamp, Instrumenter.SENTRY);
        this.setDefaultStartSpanData(span);
        return span;
    }

    public void clear() {
        if (this.onCreateSpan != null && !this.onCreateSpan.isFinished()) {
            this.onCreateSpan.finish(SpanStatus.CANCELLED);
        }
        this.onCreateSpan = null;
        if (this.onStartSpan != null && !this.onStartSpan.isFinished()) {
            this.onStartSpan.finish(SpanStatus.CANCELLED);
        }
        this.onStartSpan = null;
    }

    private void setDefaultStartSpanData(@NotNull ISpan span) {
        span.setData("thread.id", (Object)AndroidThreadChecker.getThreadId(Looper.getMainLooper().getThread()));
        span.setData("thread.name", (Object)"main");
        span.setData("ui.contributes_to_ttid", (Object)true);
        span.setData("ui.contributes_to_ttfd", (Object)true);
    }
}

