/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CurrentActivityHolder {
    @NotNull
    private static final CurrentActivityHolder instance = new CurrentActivityHolder();
    @Nullable
    private WeakReference<Activity> currentActivity;

    private CurrentActivityHolder() {
    }

    @NotNull
    public static CurrentActivityHolder getInstance() {
        return instance;
    }

    @Nullable
    public Activity getActivity() {
        if (this.currentActivity != null) {
            return (Activity)this.currentActivity.get();
        }
        return null;
    }

    public void setActivity(@NotNull Activity activity) {
        if (this.currentActivity != null && this.currentActivity.get() == activity) {
            return;
        }
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public void clearActivity() {
        this.currentActivity = null;
    }

    public void clearActivity(@NotNull Activity activity) {
        if (this.currentActivity != null && this.currentActivity.get() != activity) {
            return;
        }
        this.currentActivity = null;
    }
}

