/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AppState;
import io.sentry.android.core.LifecycleWatcher;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AppLifecycleIntegration
implements Integration,
Closeable {
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    @TestOnly
    @Nullable
    volatile LifecycleWatcher watcher;
    @Nullable
    private SentryAndroidOptions options;

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSessionTracking enabled: %s", new Object[]{this.options.isEnableAutoSessionTracking()});
        this.options.getLogger().log(SentryLevel.DEBUG, "enableAppLifecycleBreadcrumbs enabled: %s", new Object[]{this.options.isEnableAppLifecycleBreadcrumbs()});
        if (this.options.isEnableAutoSessionTracking() || this.options.isEnableAppLifecycleBreadcrumbs()) {
            try (ISentryLifecycleToken ignored = this.lock.acquire();){
                if (this.watcher != null) {
                    return;
                }
                this.watcher = new LifecycleWatcher(scopes, this.options.getSessionTrackingIntervalMillis(), this.options.isEnableAutoSessionTracking(), this.options.isEnableAppLifecycleBreadcrumbs());
                AppState.getInstance().addAppStateListener(this.watcher);
            }
            options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion((String)"AppLifecycle");
        }
    }

    private void removeObserver() {
        LifecycleWatcher watcherRef;
        try (ISentryLifecycleToken ignored = this.lock.acquire();){
            watcherRef = this.watcher;
            this.watcher = null;
        }
        if (watcherRef != null) {
            AppState.getInstance().removeAppStateListener(watcherRef);
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration removed.", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.removeObserver();
        AppState.getInstance().unregisterLifecycleObserver();
    }
}

