/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AppState;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.internal.util.Debouncer;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import io.sentry.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SystemEventsBreadcrumbsIntegration
implements Integration,
Closeable,
AppState.AppStateListener {
    @NotNull
    private final Context context;
    @TestOnly
    @Nullable
    volatile SystemEventsBroadcastReceiver receiver;
    @Nullable
    private SentryAndroidOptions options;
    @Nullable
    private IScopes scopes;
    @NotNull
    private final String[] actions;
    private volatile boolean isClosed = false;
    private volatile boolean isStopped = false;
    private volatile IntentFilter filter = null;
    private volatile HandlerThread handlerThread = null;
    @NotNull
    private final AtomicBoolean isReceiverRegistered = new AtomicBoolean(false);
    @NotNull
    private final AutoClosableReentrantLock receiverLock = new AutoClosableReentrantLock();
    @Nullable
    private BatteryState previousBatteryState;
    @TestOnly
    @Nullable
    Handler customHandler = null;

    public SystemEventsBreadcrumbsIntegration(@NotNull Context context) {
        this(context, SystemEventsBreadcrumbsIntegration.getDefaultActionsInternal(), null);
    }

    public SystemEventsBreadcrumbsIntegration(@NotNull Context context, @NotNull Handler handler) {
        this(context, SystemEventsBreadcrumbsIntegration.getDefaultActionsInternal(), handler);
    }

    SystemEventsBreadcrumbsIntegration(@NotNull Context context, @NotNull String[] actions, @Nullable Handler handler) {
        this.context = ContextUtils.getApplicationContext(context);
        this.actions = actions;
        this.customHandler = handler;
    }

    public SystemEventsBreadcrumbsIntegration(@NotNull Context context, @NotNull List<String> actions) {
        this.context = ContextUtils.getApplicationContext(context);
        this.actions = new String[actions.size()];
        actions.toArray(this.actions);
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.scopes = scopes;
        this.options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableSystemEventBreadcrumbs()});
        if (this.options.isEnableSystemEventBreadcrumbs()) {
            AppState.getInstance().addAppStateListener(this);
            if (ContextUtils.isForegroundImportance()) {
                this.registerReceiver(this.scopes, this.options);
            }
        }
    }

    private void registerReceiver(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        if (!options.isEnableSystemEventBreadcrumbs()) {
            return;
        }
        if (this.isClosed || this.isStopped || this.receiver != null) {
            return;
        }
        try {
            options.getExecutorService().submit(() -> {
                try (@NotNull ISentryLifecycleToken ignored = this.receiverLock.acquire();){
                    if (this.isClosed || this.isStopped || this.receiver != null) {
                        return;
                    }
                    this.receiver = new SystemEventsBroadcastReceiver(scopes, options);
                    if (this.filter == null) {
                        this.filter = new IntentFilter();
                        for (String item : this.actions) {
                            this.filter.addAction(item);
                        }
                    }
                    if (this.customHandler == null && this.handlerThread == null) {
                        this.handlerThread = new HandlerThread("SystemEventsReceiver", 10);
                        this.handlerThread.start();
                    }
                    try {
                        @NotNull Handler handler = this.customHandler != null ? this.customHandler : new Handler(this.handlerThread.getLooper());
                        ContextUtils.registerReceiver(this.context, options, (BroadcastReceiver)this.receiver, this.filter, handler);
                        if (!this.isReceiverRegistered.getAndSet(true)) {
                            options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration installed.", new Object[0]);
                            IntegrationUtils.addIntegrationToSdkVersion((String)"SystemEventsBreadcrumbs");
                        }
                    }
                    catch (Throwable e) {
                        options.setEnableSystemEventBreadcrumbs(false);
                        options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SystemEventsBreadcrumbsIntegration.", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.WARNING, "Failed to start SystemEventsBreadcrumbsIntegration on executor thread.", new Object[0]);
        }
    }

    private void scheduleUnregisterReceiver() {
        if (this.options == null) {
            return;
        }
        try {
            this.options.getExecutorService().submit(() -> this.unregisterReceiver());
        }
        catch (RejectedExecutionException e) {
            this.unregisterReceiver();
        }
    }

    private void unregisterReceiver() {
        SystemEventsBroadcastReceiver receiverRef;
        try (@NotNull ISentryLifecycleToken ignored = this.receiverLock.acquire();){
            this.isStopped = true;
            receiverRef = this.receiver;
            this.receiver = null;
        }
        if (receiverRef != null) {
            this.context.unregisterReceiver((BroadcastReceiver)receiverRef);
        }
    }

    @Override
    public void close() throws IOException {
        try (@NotNull ISentryLifecycleToken ignored = this.receiverLock.acquire();){
            this.isClosed = true;
            this.filter = null;
            if (this.handlerThread != null) {
                this.handlerThread.quit();
            }
            this.handlerThread = null;
        }
        AppState.getInstance().removeAppStateListener(this);
        this.scheduleUnregisterReceiver();
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "SystemEventsBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    @NotNull
    public static List<String> getDefaultActions() {
        return Arrays.asList(SystemEventsBreadcrumbsIntegration.getDefaultActionsInternal());
    }

    @NotNull
    private static String[] getDefaultActionsInternal() {
        String[] actions = new String[]{"android.intent.action.ACTION_SHUTDOWN", "android.intent.action.AIRPLANE_MODE", "android.intent.action.BATTERY_CHANGED", "android.intent.action.CAMERA_BUTTON", "android.intent.action.CONFIGURATION_CHANGED", "android.intent.action.DATE_CHANGED", "android.intent.action.DEVICE_STORAGE_LOW", "android.intent.action.DEVICE_STORAGE_OK", "android.intent.action.DOCK_EVENT", "android.intent.action.DREAMING_STARTED", "android.intent.action.DREAMING_STOPPED", "android.intent.action.INPUT_METHOD_CHANGED", "android.intent.action.LOCALE_CHANGED", "android.intent.action.SCREEN_OFF", "android.intent.action.SCREEN_ON", "android.intent.action.TIMEZONE_CHANGED", "android.intent.action.TIME_SET", "android.os.action.DEVICE_IDLE_MODE_CHANGED", "android.os.action.POWER_SAVE_MODE_CHANGED"};
        return actions;
    }

    @Override
    public void onForeground() {
        if (this.scopes == null || this.options == null) {
            return;
        }
        this.isStopped = false;
        this.registerReceiver(this.scopes, this.options);
    }

    @Override
    public void onBackground() {
        this.scheduleUnregisterReceiver();
    }

    static final class BatteryState {
        @Nullable
        private final Integer level;
        @Nullable
        private final Boolean charging;

        BatteryState(@Nullable Integer level, @Nullable Boolean charging) {
            this.level = level;
            this.charging = charging;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof BatteryState)) {
                return false;
            }
            BatteryState that = (BatteryState)other;
            return Objects.equals((Object)this.level, (Object)that.level) && Objects.equals((Object)this.charging, (Object)that.charging);
        }

        public int hashCode() {
            return Objects.hash((Object[])new Object[]{this.level, this.charging});
        }
    }

    final class SystemEventsBroadcastReceiver
    extends BroadcastReceiver {
        private static final long DEBOUNCE_WAIT_TIME_MS = 60000L;
        @NotNull
        private final IScopes scopes;
        @NotNull
        private final SentryAndroidOptions options;
        @NotNull
        private final Debouncer batteryChangedDebouncer = new Debouncer(AndroidCurrentDateProvider.getInstance(), 60000L, 0);
        private final char[] buf = new char[64];

        SystemEventsBroadcastReceiver(@NotNull IScopes scopes, SentryAndroidOptions options) {
            this.scopes = scopes;
            this.options = options;
        }

        public void onReceive(Context context, @NotNull Intent intent) {
            @Nullable String action = intent.getAction();
            boolean isBatteryChanged = "android.intent.action.BATTERY_CHANGED".equals(action);
            BatteryState batteryState = null;
            if (isBatteryChanged) {
                Boolean currentChargingState;
                if (this.batteryChangedDebouncer.checkForDebounce()) {
                    return;
                }
                @Nullable Float batteryLevel = DeviceInfoUtil.getBatteryLevel(intent, this.options);
                Integer currentBatteryLevel = batteryLevel != null ? Integer.valueOf(batteryLevel.intValue()) : null;
                batteryState = new BatteryState(currentBatteryLevel, currentChargingState = DeviceInfoUtil.isCharging(intent, this.options));
                if (batteryState.equals(SystemEventsBreadcrumbsIntegration.this.previousBatteryState)) {
                    return;
                }
                SystemEventsBreadcrumbsIntegration.this.previousBatteryState = batteryState;
            }
            BatteryState state = batteryState;
            long now = System.currentTimeMillis();
            Breadcrumb breadcrumb = this.createBreadcrumb(now, intent, action, state);
            Hint hint = new Hint();
            hint.set("android:intent", (Object)intent);
            this.scopes.addBreadcrumb(breadcrumb, hint);
        }

        @TestOnly
        @Nullable
        String getStringAfterDotFast(@Nullable String str) {
            if (str == null) {
                return null;
            }
            int len = str.length();
            int bufIndex = this.buf.length;
            for (int i = len - 1; i >= 0; --i) {
                char c = str.charAt(i);
                if (c == '.') {
                    return new String(this.buf, bufIndex, this.buf.length - bufIndex);
                }
                if (bufIndex == 0) {
                    return StringUtils.getStringAfterDot((String)str);
                }
                this.buf[--bufIndex] = c;
            }
            return str;
        }

        @NotNull
        private Breadcrumb createBreadcrumb(long timeMs, @NotNull Intent intent, @Nullable String action, @Nullable BatteryState batteryState) {
            Bundle extras;
            Breadcrumb breadcrumb = new Breadcrumb(timeMs);
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            String shortAction = this.getStringAfterDotFast(action);
            if (shortAction != null) {
                breadcrumb.setData("action", (Object)shortAction);
            }
            if (batteryState != null) {
                if (batteryState.level != null) {
                    breadcrumb.setData("level", (Object)batteryState.level);
                }
                if (batteryState.charging != null) {
                    breadcrumb.setData("charging", (Object)batteryState.charging);
                }
            } else if (this.options.isEnableSystemEventBreadcrumbsExtras() && (extras = intent.getExtras()) != null && !extras.isEmpty()) {
                HashMap<String, String> newExtras = new HashMap<String, String>(extras.size());
                for (String item : extras.keySet()) {
                    try {
                        Object value = extras.get(item);
                        if (value == null) continue;
                        newExtras.put(item, value.toString());
                    }
                    catch (Throwable exception) {
                        this.options.getLogger().log(SentryLevel.ERROR, exception, "%s key of the %s action threw an error.", new Object[]{item, action});
                    }
                }
                breadcrumb.setData("extras", newExtras);
            }
            breadcrumb.setLevel(SentryLevel.INFO);
            return breadcrumb;
        }
    }
}

