/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.PerformanceCollectionData;
import io.sentry.SentryLevel;
import io.sentry.SentryNanotimeDate;
import io.sentry.SentryUUID;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AndroidProfiler {
    private static final int BUFFER_SIZE_BYTES = 3000000;
    private static final int PROFILING_TIMEOUT_MILLIS = 30000;
    private long profileStartNanos = 0L;
    @NotNull
    private final File traceFilesDir;
    private final int intervalUs;
    @Nullable
    private Future<?> scheduledFinish = null;
    @Nullable
    private File traceFile = null;
    @Nullable
    private String frameMetricsCollectorId;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> screenFrameRateMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> slowFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> frozenFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final Map<String, ProfileMeasurement> measurementsMap = new HashMap<String, ProfileMeasurement>();
    @Nullable
    private final ISentryExecutorService timeoutExecutorService;
    @NotNull
    private final ILogger logger;
    private volatile boolean isRunning = false;
    @NotNull
    protected final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public AndroidProfiler(@NotNull String tracesFilesDirPath, int intervalUs, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @Nullable ISentryExecutorService timeoutExecutorService, @NotNull ILogger logger) {
        this.traceFilesDir = new File((String)Objects.requireNonNull((Object)tracesFilesDirPath, (String)"TracesFilesDirPath is required"));
        this.intervalUs = intervalUs;
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"Logger is required");
        this.timeoutExecutorService = timeoutExecutorService;
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public ProfileStartData start() {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.intervalUs == 0) {
                this.logger.log(SentryLevel.WARNING, "Disabling profiling because intervaUs is set to %d", new Object[]{this.intervalUs});
                ProfileStartData profileStartData = null;
                return profileStartData;
            }
            if (this.isRunning) {
                this.logger.log(SentryLevel.WARNING, "Profiling has already started...", new Object[0]);
                ProfileStartData profileStartData = null;
                return profileStartData;
            }
            this.traceFile = new File(this.traceFilesDir, SentryUUID.generateSentryId() + ".trace");
            this.measurementsMap.clear();
            this.screenFrameRateMeasurements.clear();
            this.slowFrameRenderMeasurements.clear();
            this.frozenFrameRenderMeasurements.clear();
            this.frameMetricsCollectorId = this.frameMetricsCollector.startCollection(new SentryFrameMetricsCollector.FrameMetricsCollectorListener(){
                float lastRefreshRate = 0.0f;

                @Override
                public void onFrameMetricCollected(long frameStartNanos, long frameEndNanos, long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen, float refreshRate) {
                    long timestampNanos = new SentryNanotimeDate().nanoTimestamp();
                    long frameTimestampRelativeNanos = frameEndNanos - System.nanoTime() + SystemClock.elapsedRealtimeNanos() - AndroidProfiler.this.profileStartNanos;
                    if (frameTimestampRelativeNanos < 0L) {
                        return;
                    }
                    if (isFrozen) {
                        AndroidProfiler.this.frozenFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos, timestampNanos));
                    } else if (isSlow) {
                        AndroidProfiler.this.slowFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos, timestampNanos));
                    }
                    if (refreshRate != this.lastRefreshRate) {
                        this.lastRefreshRate = refreshRate;
                        AndroidProfiler.this.screenFrameRateMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)Float.valueOf(refreshRate), timestampNanos));
                    }
                }
            });
            try {
                if (this.timeoutExecutorService != null) {
                    this.scheduledFinish = this.timeoutExecutorService.schedule(() -> this.endAndCollect(true, null), 30000L);
                }
            }
            catch (RejectedExecutionException e) {
                this.logger.log(SentryLevel.ERROR, "Failed to call the executor. Profiling will not be automatically finished. Did you call Sentry.close()?", (Throwable)e);
            }
            this.profileStartNanos = SystemClock.elapsedRealtimeNanos();
            @NotNull Date profileStartTimestamp = DateUtils.getCurrentDateTime();
            long profileStartCpuMillis = Process.getElapsedCpuTime();
            try {
                Debug.startMethodTracingSampling((String)this.traceFile.getPath(), (int)3000000, (int)this.intervalUs);
                this.isRunning = true;
                ProfileStartData profileStartData = new ProfileStartData(this.profileStartNanos, profileStartCpuMillis, profileStartTimestamp);
                return profileStartData;
            }
            catch (Throwable e) {
                ProfileStartData profileStartData;
                block16: {
                    this.endAndCollect(false, null);
                    this.logger.log(SentryLevel.ERROR, "Unable to start a profile: ", e);
                    this.isRunning = false;
                    profileStartData = null;
                    if (ignored == null) break block16;
                    ignored.close();
                }
                return profileStartData;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public ProfileEndData endAndCollect(boolean isTimeout, @Nullable List<PerformanceCollectionData> performanceCollectionData) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.isRunning) {
                this.logger.log(SentryLevel.WARNING, "Profiler not running", new Object[0]);
                ProfileEndData profileEndData = null;
                return profileEndData;
            }
            try {
                Debug.stopMethodTracing();
            }
            catch (Throwable e) {
                this.logger.log(SentryLevel.ERROR, "Error while stopping profiling: ", e);
            }
            finally {
                this.isRunning = false;
            }
            this.frameMetricsCollector.stopCollection(this.frameMetricsCollectorId);
            long transactionEndNanos = SystemClock.elapsedRealtimeNanos();
            long transactionEndCpuMillis = Process.getElapsedCpuTime();
            if (this.traceFile == null) {
                this.logger.log(SentryLevel.ERROR, "Trace file does not exists", new Object[0]);
                ProfileEndData profileEndData = null;
                return profileEndData;
            }
            if (!this.slowFrameRenderMeasurements.isEmpty()) {
                this.measurementsMap.put("slow_frame_renders", new ProfileMeasurement("nanosecond", this.slowFrameRenderMeasurements));
            }
            if (!this.frozenFrameRenderMeasurements.isEmpty()) {
                this.measurementsMap.put("frozen_frame_renders", new ProfileMeasurement("nanosecond", this.frozenFrameRenderMeasurements));
            }
            if (!this.screenFrameRateMeasurements.isEmpty()) {
                this.measurementsMap.put("screen_frame_rates", new ProfileMeasurement("hz", this.screenFrameRateMeasurements));
            }
            this.putPerformanceCollectionDataInMeasurements(performanceCollectionData);
            if (this.scheduledFinish != null) {
                this.scheduledFinish.cancel(true);
                this.scheduledFinish = null;
            }
            ProfileEndData profileEndData = new ProfileEndData(transactionEndNanos, transactionEndCpuMillis, isTimeout, this.traceFile, this.measurementsMap);
            return profileEndData;
        }
    }

    public void close() {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.scheduledFinish != null) {
                this.scheduledFinish.cancel(true);
                this.scheduledFinish = null;
            }
            if (this.isRunning) {
                this.endAndCollect(true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void putPerformanceCollectionDataInMeasurements(@Nullable List<PerformanceCollectionData> performanceCollectionData) {
        long timestampDiff = SystemClock.elapsedRealtimeNanos() - this.profileStartNanos - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        if (performanceCollectionData != null) {
            @NotNull ArrayDeque<ProfileMeasurementValue> memoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            @NotNull ArrayDeque<ProfileMeasurementValue> nativeMemoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            @NotNull ArrayDeque<ProfileMeasurementValue> cpuUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            List<PerformanceCollectionData> list = performanceCollectionData;
            synchronized (list) {
                for (PerformanceCollectionData data : performanceCollectionData) {
                    long nanoTimestamp = data.getNanoTimestamp();
                    long relativeStartNs = nanoTimestamp + timestampDiff;
                    @Nullable Double cpuUsagePercentage = data.getCpuUsagePercentage();
                    @Nullable Long usedHeapMemory = data.getUsedHeapMemory();
                    @Nullable Long usedNativeMemory = data.getUsedNativeMemory();
                    if (cpuUsagePercentage != null) {
                        cpuUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(relativeStartNs), (Number)cpuUsagePercentage, nanoTimestamp));
                    }
                    if (usedHeapMemory != null) {
                        memoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(relativeStartNs), (Number)usedHeapMemory, nanoTimestamp));
                    }
                    if (usedNativeMemory == null) continue;
                    nativeMemoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(relativeStartNs), (Number)usedNativeMemory, nanoTimestamp));
                }
            }
            if (!cpuUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("cpu_usage", new ProfileMeasurement("percent", cpuUsageMeasurements));
            }
            if (!memoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_footprint", new ProfileMeasurement("byte", memoryUsageMeasurements));
            }
            if (!nativeMemoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_native_footprint", new ProfileMeasurement("byte", nativeMemoryUsageMeasurements));
            }
        }
    }

    boolean isRunning() {
        return this.isRunning;
    }

    public static class ProfileStartData {
        public final long startNanos;
        public final long startCpuMillis;
        @NotNull
        public final Date startTimestamp;

        public ProfileStartData(long startNanos, long startCpuMillis, @NotNull Date startTimestamp) {
            this.startNanos = startNanos;
            this.startCpuMillis = startCpuMillis;
            this.startTimestamp = startTimestamp;
        }
    }

    public static class ProfileEndData {
        public final long endNanos;
        public final long endCpuMillis;
        @NotNull
        public final File traceFile;
        @NotNull
        public final Map<String, ProfileMeasurement> measurementsMap;
        public final boolean didTimeout;

        public ProfileEndData(long endNanos, long endCpuMillis, boolean didTimeout, @NotNull File traceFile, @NotNull Map<String, ProfileMeasurement> measurementsMap) {
            this.endNanos = endNanos;
            this.traceFile = traceFile;
            this.endCpuMillis = endCpuMillis;
            this.measurementsMap = measurementsMap;
            this.didTimeout = didTimeout;
        }
    }
}

