/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.OptionsContainer;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidOptionsInitializer;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.android.fragment.FragmentLifecycleIntegration;
import io.sentry.android.timber.SentryTimberIntegration;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LoadClass;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryAndroid {
    private static final long sdkInitMillis = SystemClock.uptimeMillis();
    static final String SENTRY_FRAGMENT_INTEGRATION_CLASS_NAME = "io.sentry.android.fragment.FragmentLifecycleIntegration";
    static final String SENTRY_TIMBER_INTEGRATION_CLASS_NAME = "io.sentry.android.timber.SentryTimberIntegration";
    static final String SENTRY_REPLAY_INTEGRATION_CLASS_NAME = "io.sentry.android.replay.ReplayIntegration";
    static final String SENTRY_DISTRIBUTION_INTEGRATION_CLASS_NAME = "io.sentry.android.distribution.DistributionIntegration";
    private static final String TIMBER_CLASS_NAME = "timber.log.Timber";
    private static final String FRAGMENT_CLASS_NAME = "androidx.fragment.app.FragmentManager$FragmentLifecycleCallbacks";
    @NotNull
    protected static final AutoClosableReentrantLock staticLock = new AutoClosableReentrantLock();

    private SentryAndroid() {
    }

    public static void init(@NotNull Context context) {
        SentryAndroid.init(context, new AndroidLogger());
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger) {
        SentryAndroid.init(context, logger, (Sentry.OptionsConfiguration<SentryAndroidOptions>)((Sentry.OptionsConfiguration)options -> {}));
    }

    public static void init(@NotNull Context context, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        SentryAndroid.init(context, new AndroidLogger(), configuration);
    }

    @SuppressLint(value={"NewApi"})
    public static void init(@NotNull Context context, @NotNull ILogger logger, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
            Sentry.init((OptionsContainer)OptionsContainer.create(SentryAndroidOptions.class), options -> {
                TimeSpan sdkInitTimeSpan;
                TimeSpan appStartTimeSpan;
                LoadClass classLoader = new LoadClass();
                boolean isTimberUpstreamAvailable = classLoader.isClassAvailable(TIMBER_CLASS_NAME, options);
                boolean isFragmentUpstreamAvailable = classLoader.isClassAvailable(FRAGMENT_CLASS_NAME, options);
                boolean isFragmentAvailable = isFragmentUpstreamAvailable && classLoader.isClassAvailable(SENTRY_FRAGMENT_INTEGRATION_CLASS_NAME, options);
                boolean isTimberAvailable = isTimberUpstreamAvailable && classLoader.isClassAvailable(SENTRY_TIMBER_INTEGRATION_CLASS_NAME, options);
                boolean isReplayAvailable = classLoader.isClassAvailable(SENTRY_REPLAY_INTEGRATION_CLASS_NAME, options);
                boolean isDistributionAvailable = classLoader.isClassAvailable(SENTRY_DISTRIBUTION_INTEGRATION_CLASS_NAME, options);
                BuildInfoProvider buildInfoProvider = new BuildInfoProvider(logger);
                LoadClass loadClass = new LoadClass();
                ActivityFramesTracker activityFramesTracker = new ActivityFramesTracker(loadClass, (SentryAndroidOptions)options);
                AndroidOptionsInitializer.loadDefaultAndMetadataOptions(options, context, logger, buildInfoProvider);
                AndroidOptionsInitializer.installDefaultIntegrations(context, options, buildInfoProvider, loadClass, activityFramesTracker, isFragmentAvailable, isTimberAvailable, isReplayAvailable, isDistributionAvailable);
                try {
                    configuration.configure(options);
                }
                catch (Throwable t) {
                    options.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", t);
                }
                @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
                if (options.isEnablePerformanceV2() && buildInfoProvider.getSdkInfoVersion() >= 24 && (appStartTimeSpan = appStartMetrics.getAppStartTimeSpan()).hasNotStarted()) {
                    appStartTimeSpan.setStartedAt(Process.getStartUptimeMillis());
                }
                if (context.getApplicationContext() instanceof Application) {
                    appStartMetrics.registerLifecycleCallbacks((Application)context.getApplicationContext());
                }
                if ((sdkInitTimeSpan = appStartMetrics.getSdkInitTimeSpan()).hasNotStarted()) {
                    sdkInitTimeSpan.setStartedAt(sdkInitMillis);
                }
                AndroidOptionsInitializer.initializeIntegrationsAndProcessors(options, context, buildInfoProvider, loadClass, activityFramesTracker);
                SentryAndroid.deduplicateIntegrations(options, isFragmentAvailable, isTimberAvailable);
            }, (boolean)true);
            @NotNull IScopes scopes = Sentry.getCurrentScopes();
            if (ContextUtils.isForegroundImportance()) {
                if (scopes.getOptions().isEnableAutoSessionTracking()) {
                    AtomicBoolean sessionStarted = new AtomicBoolean(false);
                    scopes.configureScope(scope -> {
                        @Nullable Session currentSession = scope.getSession();
                        if (currentSession != null && currentSession.getStarted() != null) {
                            sessionStarted.set(true);
                        }
                    });
                    if (!sessionStarted.get()) {
                        scopes.startSession();
                    }
                }
                scopes.getOptions().getReplayController().start();
            }
        }
        catch (IllegalAccessException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InstantiationException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InvocationTargetException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", (Throwable)e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
    }

    private static void deduplicateIntegrations(@NotNull SentryOptions options, boolean isFragmentAvailable, boolean isTimberAvailable) {
        Integration integration2;
        ArrayList<Integration> timberIntegrations = new ArrayList<Integration>();
        ArrayList<Integration> fragmentIntegrations = new ArrayList<Integration>();
        for (Integration integration2 : options.getIntegrations()) {
            if (isFragmentAvailable && integration2 instanceof FragmentLifecycleIntegration) {
                fragmentIntegrations.add(integration2);
            }
            if (!isTimberAvailable || !(integration2 instanceof SentryTimberIntegration)) continue;
            timberIntegrations.add(integration2);
        }
        if (fragmentIntegrations.size() > 1) {
            for (int i = 0; i < fragmentIntegrations.size() - 1; ++i) {
                integration2 = (Integration)fragmentIntegrations.get(i);
                options.getIntegrations().remove(integration2);
            }
        }
        if (timberIntegrations.size() > 1) {
            for (int i = 0; i < timberIntegrations.size() - 1; ++i) {
                integration2 = (Integration)timberIntegrations.get(i);
                options.getIntegrations().remove(integration2);
            }
        }
    }
}

