/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.threaddump;

import io.sentry.SentryLevel;
import io.sentry.SentryLockReason;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.android.core.internal.threaddump.Line;
import io.sentry.android.core.internal.threaddump.Lines;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumpParser {
    private static final Pattern BEGIN_MANAGED_THREAD_RE = Pattern.compile("\"(.*)\" (.*) ?prio=(\\d+)\\s+tid=(\\d+)\\s*(.*)");
    private static final Pattern BEGIN_UNMANAGED_NATIVE_THREAD_RE = Pattern.compile("\"(.*)\" (.*) ?sysTid=(\\d+)");
    private static final Pattern NATIVE_RE = Pattern.compile(" *(?:native: )?#(\\d+) \\S+ ([0-9a-fA-F]+)\\s+((.*?)(?:\\s+\\(deleted\\))?(?:\\s+\\(offset (.*?)\\))?)(?:\\s+\\((?:\\?\\?\\?|(.*?)(?:\\+(\\d+))?)\\))?(?:\\s+\\(BuildId: (.*?)\\))?");
    private static final Pattern JAVA_RE = Pattern.compile(" *at (?:(.+)\\.)?([^.]+)\\.([^.]+)\\((.*):([\\d-]+)\\)");
    private static final Pattern JNI_RE = Pattern.compile(" *at (?:(.+)\\.)?([^.]+)\\.([^.]+)\\(Native method\\)");
    private static final Pattern LOCKED_RE = Pattern.compile(" *- locked \\<([0x0-9a-fA-F]{1,16})\\> \\(a (?:(.+)\\.)?([^.]+)\\)");
    private static final Pattern SLEEPING_ON_RE = Pattern.compile(" *- sleeping on \\<([0x0-9a-fA-F]{1,16})\\> \\(a (?:(.+)\\.)?([^.]+)\\)");
    private static final Pattern WAITING_ON_RE = Pattern.compile(" *- waiting on \\<([0x0-9a-fA-F]{1,16})\\> \\(a (?:(.+)\\.)?([^.]+)\\)");
    private static final Pattern WAITING_TO_LOCK_RE = Pattern.compile(" *- waiting to lock \\<([0x0-9a-fA-F]{1,16})\\> \\(a (?:(.+)\\.)?([^.]+)\\)");
    private static final Pattern WAITING_TO_LOCK_HELD_RE = Pattern.compile(" *- waiting to lock \\<([0x0-9a-fA-F]{1,16})\\> \\(a (?:(.+)\\.)?([^.]+)\\)(?: held by thread (\\d+))");
    private static final Pattern WAITING_TO_LOCK_UNKNOWN_RE = Pattern.compile(" *- waiting to lock an unknown object");
    private static final Pattern BLANK_RE = Pattern.compile("\\s+");
    @NotNull
    private final SentryOptions options;
    private final boolean isBackground;
    @NotNull
    private final SentryStackTraceFactory stackTraceFactory;
    @NotNull
    private final Map<String, DebugImage> debugImages;
    @NotNull
    private final List<SentryThread> threads;

    public ThreadDumpParser(@NotNull SentryOptions options, boolean isBackground) {
        this.options = options;
        this.isBackground = isBackground;
        this.stackTraceFactory = new SentryStackTraceFactory(options);
        this.debugImages = new HashMap<String, DebugImage>();
        this.threads = new ArrayList<SentryThread>();
    }

    @NotNull
    public List<DebugImage> getDebugImages() {
        return new ArrayList<DebugImage>(this.debugImages.values());
    }

    @NotNull
    public List<SentryThread> getThreads() {
        return this.threads;
    }

    @Nullable
    private static String buildIdToDebugId(@NotNull String buildId) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(new BigInteger("10" + buildId, 16).toByteArray());
            buf.get();
            return String.format("%08x-%04x-%04x-%04x-%04x%08x", buf.order(ByteOrder.LITTLE_ENDIAN).getInt(), buf.getShort(), buf.getShort(), buf.order(ByteOrder.BIG_ENDIAN).getShort(), buf.getShort(), buf.getInt());
        }
        catch (NumberFormatException | BufferUnderflowException e) {
            return null;
        }
    }

    public void parse(@NotNull Lines lines) {
        Matcher beginManagedThreadRe = BEGIN_MANAGED_THREAD_RE.matcher("");
        Matcher beginUnmanagedNativeThreadRe = BEGIN_UNMANAGED_NATIVE_THREAD_RE.matcher("");
        while (lines.hasNext()) {
            Line line = lines.next();
            if (line == null) {
                this.options.getLogger().log(SentryLevel.WARNING, "Internal error while parsing thread dump.", new Object[0]);
                return;
            }
            String text = line.text;
            if (!this.matches(beginManagedThreadRe, text) && !this.matches(beginUnmanagedNativeThreadRe, text)) continue;
            lines.rewind();
            SentryThread thread = this.parseThread(lines);
            if (thread == null) continue;
            this.threads.add(thread);
        }
    }

    private SentryThread parseThread(@NotNull Lines lines) {
        SentryThread sentryThread = new SentryThread();
        Matcher beginManagedThreadRe = BEGIN_MANAGED_THREAD_RE.matcher("");
        Matcher beginUnmanagedNativeThreadRe = BEGIN_UNMANAGED_NATIVE_THREAD_RE.matcher("");
        if (!lines.hasNext()) {
            return null;
        }
        Line line = lines.next();
        if (line == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Internal error while parsing thread dump.", new Object[0]);
            return null;
        }
        if (this.matches(beginManagedThreadRe, line.text)) {
            Long tid = this.getLong(beginManagedThreadRe, 4, null);
            if (tid == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "No thread id in the dump, skipping thread.", new Object[0]);
                return null;
            }
            sentryThread.setId(tid);
            sentryThread.setName(beginManagedThreadRe.group(1));
            String state = beginManagedThreadRe.group(5);
            if (state != null) {
                if (state.contains(" ")) {
                    sentryThread.setState(state.substring(0, state.indexOf(32)));
                } else {
                    sentryThread.setState(state);
                }
            }
        } else if (this.matches(beginUnmanagedNativeThreadRe, line.text)) {
            Long sysTid = this.getLong(beginUnmanagedNativeThreadRe, 3, null);
            if (sysTid == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "No thread id in the dump, skipping thread.", new Object[0]);
                return null;
            }
            sentryThread.setId(sysTid);
            sentryThread.setName(beginUnmanagedNativeThreadRe.group(1));
        }
        String threadName = sentryThread.getName();
        if (threadName != null) {
            boolean isMain = threadName.equals("main");
            sentryThread.setMain(Boolean.valueOf(isMain));
            sentryThread.setCrashed(Boolean.valueOf(isMain));
            sentryThread.setCurrent(Boolean.valueOf(isMain && !this.isBackground));
        }
        SentryStackTrace stackTrace = this.parseStacktrace(lines, sentryThread);
        sentryThread.setStacktrace(stackTrace);
        return sentryThread;
    }

    @NotNull
    private SentryStackTrace parseStacktrace(@NotNull Lines lines, @NotNull SentryThread thread) {
        ArrayList<SentryStackFrame> frames = new ArrayList<SentryStackFrame>();
        SentryStackFrame lastJavaFrame = null;
        Matcher nativeRe = NATIVE_RE.matcher("");
        Matcher javaRe = JAVA_RE.matcher("");
        Matcher jniRe = JNI_RE.matcher("");
        Matcher lockedRe = LOCKED_RE.matcher("");
        Matcher waitingOnRe = WAITING_ON_RE.matcher("");
        Matcher sleepingOnRe = SLEEPING_ON_RE.matcher("");
        Matcher waitingToLockHeldRe = WAITING_TO_LOCK_HELD_RE.matcher("");
        Matcher waitingToLockRe = WAITING_TO_LOCK_RE.matcher("");
        Matcher waitingToLockUnknownRe = WAITING_TO_LOCK_UNKNOWN_RE.matcher("");
        Matcher blankRe = BLANK_RE.matcher("");
        while (lines.hasNext()) {
            SentryLockReason lock;
            String module;
            String className;
            String packageName;
            SentryStackFrame frame;
            Line line = lines.next();
            if (line == null) {
                this.options.getLogger().log(SentryLevel.WARNING, "Internal error while parsing thread dump.", new Object[0]);
                break;
            }
            String text = line.text;
            if (this.matches(javaRe, text)) {
                frame = new SentryStackFrame();
                packageName = javaRe.group(1);
                className = javaRe.group(2);
                module = String.format("%s.%s", packageName, className);
                frame.setModule(module);
                frame.setFunction(javaRe.group(3));
                frame.setFilename(javaRe.group(4));
                frame.setLineno(this.getUInteger(javaRe, 5, null));
                frame.setInApp(this.stackTraceFactory.isInApp(module));
                frames.add(frame);
                lastJavaFrame = frame;
                continue;
            }
            if (this.matches(nativeRe, text)) {
                String debugId;
                frame = new SentryStackFrame();
                frame.setPackage(nativeRe.group(3));
                frame.setFunction(nativeRe.group(6));
                frame.setLineno(this.getInteger(nativeRe, 7, null));
                frame.setInstructionAddr("0x" + nativeRe.group(2));
                frame.setPlatform("native");
                String buildId = nativeRe.group(8);
                String string = debugId = buildId == null ? null : ThreadDumpParser.buildIdToDebugId(buildId);
                if (debugId != null) {
                    if (!this.debugImages.containsKey(debugId)) {
                        DebugImage debugImage = new DebugImage();
                        debugImage.setDebugId(debugId);
                        debugImage.setType("elf");
                        debugImage.setCodeFile(nativeRe.group(4));
                        debugImage.setCodeId(buildId);
                        this.debugImages.put(debugId, debugImage);
                    }
                    frame.setAddrMode("rel:" + debugId);
                }
                frames.add(frame);
                lastJavaFrame = null;
                continue;
            }
            if (this.matches(jniRe, text)) {
                frame = new SentryStackFrame();
                packageName = jniRe.group(1);
                className = jniRe.group(2);
                module = String.format("%s.%s", packageName, className);
                frame.setModule(module);
                frame.setFunction(jniRe.group(3));
                frame.setInApp(this.stackTraceFactory.isInApp(module));
                frame.setNative(Boolean.valueOf(true));
                frames.add(frame);
                lastJavaFrame = frame;
                continue;
            }
            if (this.matches(lockedRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(1);
                lock.setAddress(lockedRe.group(1));
                lock.setPackageName(lockedRe.group(2));
                lock.setClassName(lockedRe.group(3));
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (this.matches(waitingOnRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(2);
                lock.setAddress(waitingOnRe.group(1));
                lock.setPackageName(waitingOnRe.group(2));
                lock.setClassName(waitingOnRe.group(3));
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (this.matches(sleepingOnRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(4);
                lock.setAddress(sleepingOnRe.group(1));
                lock.setPackageName(sleepingOnRe.group(2));
                lock.setClassName(sleepingOnRe.group(3));
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (this.matches(waitingToLockHeldRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(8);
                lock.setAddress(waitingToLockHeldRe.group(1));
                lock.setPackageName(waitingToLockHeldRe.group(2));
                lock.setClassName(waitingToLockHeldRe.group(3));
                lock.setThreadId(this.getLong(waitingToLockHeldRe, 4, null));
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (this.matches(waitingToLockRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(8);
                lock.setAddress(waitingToLockRe.group(1));
                lock.setPackageName(waitingToLockRe.group(2));
                lock.setClassName(waitingToLockRe.group(3));
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (this.matches(waitingToLockUnknownRe, text)) {
                if (lastJavaFrame == null) continue;
                lock = new SentryLockReason();
                lock.setType(8);
                lastJavaFrame.setLock(lock);
                this.combineThreadLocks(thread, lock);
                continue;
            }
            if (text.length() != 0 && !this.matches(blankRe, text)) continue;
            break;
        }
        Collections.reverse(frames);
        SentryStackTrace stackTrace = new SentryStackTrace(frames);
        stackTrace.setSnapshot(Boolean.valueOf(true));
        return stackTrace;
    }

    private boolean matches(@NotNull Matcher matcher, @NotNull String text) {
        matcher.reset(text);
        return matcher.matches();
    }

    private void combineThreadLocks(@NotNull SentryThread thread, @NotNull SentryLockReason lockReason) {
        SentryLockReason prev;
        HashMap<String, SentryLockReason> heldLocks = thread.getHeldLocks();
        if (heldLocks == null) {
            heldLocks = new HashMap<String, SentryLockReason>();
        }
        if ((prev = (SentryLockReason)heldLocks.get(lockReason.getAddress())) != null) {
            prev.setType(Math.max(prev.getType(), lockReason.getType()));
        } else {
            heldLocks.put(lockReason.getAddress(), new SentryLockReason(lockReason));
        }
        thread.setHeldLocks(heldLocks);
    }

    @Nullable
    private Long getLong(@NotNull Matcher matcher, int group, @Nullable Long defaultValue) {
        String str = matcher.group(group);
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        return Long.parseLong(str);
    }

    @Nullable
    private Integer getInteger(@NotNull Matcher matcher, int groupIndex, @Nullable Integer defaultValue) {
        String str = matcher.group(groupIndex);
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    @Nullable
    private Integer getUInteger(@NotNull Matcher matcher, int group, @Nullable Integer defaultValue) {
        String str = matcher.group(group);
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        Integer parsed = Integer.parseInt(str);
        return parsed >= 0 ? parsed : defaultValue;
    }
}

