/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.ISerializer;
import io.sentry.ScopeType;
import io.sentry.ScopesAdapter;
import io.sentry.SentryDate;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.cache.EnvelopeCache;
import io.sentry.protocol.App;
import io.sentry.protocol.Device;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.MapObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InternalSentrySdk {
    @Nullable
    public static IScope getCurrentScope() {
        @NotNull AtomicReference<V> scopeRef = new AtomicReference();
        ScopesAdapter.getInstance().configureScope(ScopeType.COMBINED, scope -> scopeRef.set(scope.clone()));
        return (IScope)scopeRef.get();
    }

    @NotNull
    public static Map<String, Object> serializeScope(@NotNull Context context, @NotNull SentryAndroidOptions options, @Nullable IScope scope) {
        @NotNull HashMap<String, Object> data = new HashMap<String, Object>();
        if (scope == null) {
            return data;
        }
        try {
            App app;
            @NotNull ILogger logger = options.getLogger();
            @NotNull MapObjectWriter writer = new MapObjectWriter(data);
            @NotNull DeviceInfoUtil deviceInfoUtil = DeviceInfoUtil.getInstance(context, options);
            @NotNull Device deviceInfo = deviceInfoUtil.collectDeviceInformation(true, true);
            scope.getContexts().setDevice(deviceInfo);
            scope.getContexts().setOperatingSystem(deviceInfoUtil.getOperatingSystem());
            @Nullable User user = scope.getUser();
            if (user == null) {
                user = new User();
                scope.setUser(user);
            }
            if (user.getId() == null) {
                try {
                    user.setId(Installation.id(context));
                }
                catch (RuntimeException e) {
                    logger.log(SentryLevel.ERROR, "Could not retrieve installation ID", (Throwable)e);
                }
            }
            if ((app = scope.getContexts().getApp()) == null) {
                app = new App();
            }
            app.setAppName(ContextUtils.getApplicationName(context));
            @NotNull TimeSpan appStartTimeSpan = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(options);
            if (appStartTimeSpan.hasStarted()) {
                app.setAppStartTime(DateUtils.toUtilDate((SentryDate)appStartTimeSpan.getStartTimestamp()));
            }
            @NotNull BuildInfoProvider buildInfoProvider = new BuildInfoProvider(options.getLogger());
            @Nullable PackageInfo packageInfo = ContextUtils.getPackageInfo(context, 4096, options.getLogger(), buildInfoProvider);
            if (packageInfo != null) {
                ContextUtils.setAppPackageInfo(packageInfo, buildInfoProvider, deviceInfoUtil, app);
            }
            scope.getContexts().setApp(app);
            writer.name("user").value(logger, (Object)scope.getUser());
            writer.name("contexts").value(logger, (Object)scope.getContexts());
            writer.name("tags").value(logger, (Object)scope.getTags());
            writer.name("extras").value(logger, (Object)scope.getExtras());
            writer.name("fingerprint").value(logger, (Object)scope.getFingerprint());
            writer.name("level").value(logger, (Object)scope.getLevel());
            writer.name("breadcrumbs").value(logger, (Object)scope.getBreadcrumbs());
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Could not serialize scope.", e);
            return new HashMap<String, Object>();
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SentryId captureEnvelope(@NotNull byte[] envelopeData, boolean maybeStartNewSession) {
        @NotNull ScopesAdapter scopes = ScopesAdapter.getInstance();
        @NotNull SentryOptions options = scopes.getOptions();
        try (ByteArrayInputStream envelopeInputStream = new ByteArrayInputStream(envelopeData);){
            @NotNull ISerializer serializer = options.getSerializer();
            @Nullable SentryEnvelope envelope = options.getEnvelopeReader().read((InputStream)envelopeInputStream);
            if (envelope == null) {
                SentryId sentryId = null;
                return sentryId;
            }
            @NotNull ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
            Session.State status = null;
            boolean crashedOrErrored = false;
            for (SentryEnvelopeItem item : envelope.getItems()) {
                envelopeItems.add(item);
                SentryEvent event = item.getEvent(serializer);
                if (event == null) continue;
                if (event.isCrashed()) {
                    status = Session.State.Crashed;
                }
                if (!event.isCrashed() && !event.isErrored()) continue;
                crashedOrErrored = true;
            }
            @Nullable Session session = InternalSentrySdk.updateSession((IScopes)scopes, options, status, crashedOrErrored);
            if (session != null) {
                SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession((ISerializer)serializer, (Session)session);
                envelopeItems.add(sessionItem);
                InternalSentrySdk.deleteCurrentSessionFile(options, !maybeStartNewSession || !scopes.getOptions().getThreadChecker().isMainThread());
                if (maybeStartNewSession) {
                    scopes.startSession();
                }
            }
            SentryEnvelope repackagedEnvelope = new SentryEnvelope(envelope.getHeader(), envelopeItems);
            SentryId sentryId = scopes.captureEnvelope(repackagedEnvelope);
            return sentryId;
        }
        catch (Throwable t) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope", t);
            return null;
        }
    }

    public static Map<String, Object> getAppStartMeasurement() {
        @NotNull AppStartMetrics metrics = AppStartMetrics.getInstance();
        @NotNull ArrayList<Map<String, Object>> spans = new ArrayList<Map<String, Object>>();
        InternalSentrySdk.addTimeSpanToSerializedSpans(metrics.createProcessInitSpan(), spans);
        InternalSentrySdk.addTimeSpanToSerializedSpans(metrics.getApplicationOnCreateTimeSpan(), spans);
        for (TimeSpan timeSpan : metrics.getContentProviderOnCreateTimeSpans()) {
            InternalSentrySdk.addTimeSpanToSerializedSpans(timeSpan, spans);
        }
        for (ActivityLifecycleTimeSpan activityLifecycleTimeSpan : metrics.getActivityLifecycleTimeSpans()) {
            InternalSentrySdk.addTimeSpanToSerializedSpans(activityLifecycleTimeSpan.getOnCreate(), spans);
            InternalSentrySdk.addTimeSpanToSerializedSpans(activityLifecycleTimeSpan.getOnStart(), spans);
        }
        @NotNull HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("spans", spans);
        result.put("type", metrics.getAppStartType().toString().toLowerCase(Locale.ROOT));
        if (metrics.getAppStartTimeSpan().hasStarted()) {
            result.put("app_start_timestamp_ms", metrics.getAppStartTimeSpan().getStartTimestampMs());
        }
        return result;
    }

    private static void addTimeSpanToSerializedSpans(TimeSpan span, List<Map<String, Object>> spans) {
        if (span.hasNotStarted()) {
            ScopesAdapter.getInstance().getOptions().getLogger().log(SentryLevel.WARNING, "Can not convert not-started TimeSpan to Map for Hybrid SDKs.", new Object[0]);
            return;
        }
        if (span.hasNotStopped()) {
            ScopesAdapter.getInstance().getOptions().getLogger().log(SentryLevel.WARNING, "Can not convert not-stopped TimeSpan to Map for Hybrid SDKs.", new Object[0]);
            return;
        }
        @NotNull HashMap<String, Object> spanMap = new HashMap<String, Object>();
        spanMap.put("description", span.getDescription());
        spanMap.put("start_timestamp_ms", span.getStartTimestampMs());
        spanMap.put("end_timestamp_ms", span.getProjectedStopTimestampMs());
        spans.add(spanMap);
    }

    private static void deleteCurrentSessionFile(@NotNull SentryOptions options, boolean isSync) {
        if (!isSync) {
            try {
                options.getExecutorService().submit(() -> InternalSentrySdk.deleteCurrentSessionFile(options));
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.WARNING, "Submission of deletion of the current session file rejected.", e);
            }
        } else {
            InternalSentrySdk.deleteCurrentSessionFile(options);
        }
    }

    private static void deleteCurrentSessionFile(@NotNull SentryOptions options) {
        String cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath == null) {
            options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, not deleting the current session.", new Object[0]);
            return;
        }
        if (!options.isEnableAutoSessionTracking()) {
            options.getLogger().log(SentryLevel.DEBUG, "Session tracking is disabled, bailing from deleting current session file.", new Object[0]);
            return;
        }
        File sessionFile = EnvelopeCache.getCurrentSessionFile((String)cacheDirPath);
        if (!sessionFile.delete()) {
            options.getLogger().log(SentryLevel.WARNING, "Failed to delete the current session file.", new Object[0]);
        }
    }

    @Nullable
    private static Session updateSession(@NotNull IScopes scopes, @NotNull SentryOptions options, @Nullable Session.State status, boolean crashedOrErrored) {
        @NotNull AtomicReference<V> sessionRef = new AtomicReference();
        scopes.configureScope(scope -> {
            @Nullable Session session = scope.getSession();
            if (session != null) {
                boolean updated = session.update(status, null, crashedOrErrored, null);
                if (updated) {
                    if (session.getStatus() == Session.State.Crashed) {
                        session.end();
                        scope.clearSession();
                    }
                    sessionRef.set(session);
                }
            } else {
                options.getLogger().log(SentryLevel.INFO, "Session is null on updateSession", new Object[0]);
            }
        });
        return (Session)sessionRef.get();
    }
}

