/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.util.Log;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;

final class AndroidLogger
implements ILogger {
    private static final String tag = "Sentry";

    AndroidLogger() {
    }

    public void log(SentryLevel level, String message, Object ... args) {
        Log.println((int)this.toLogcatLevel(level), (String)tag, (String)String.format(message, args));
    }

    public void log(SentryLevel level, Throwable throwable, String message, Object ... args) {
        this.log(level, String.format(message, args), throwable);
    }

    public void log(SentryLevel level, String message, Throwable throwable) {
        switch (level) {
            case DEBUG: {
                Log.d((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case WARNING: {
                Log.w((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case ERROR: {
                Log.e((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case FATAL: {
                Log.wtf((String)tag, (String)message, (Throwable)throwable);
            }
        }
    }

    SentryLevel toSentryLevel(int logcatLevel) {
        switch (logcatLevel) {
            case 2: 
            case 3: {
                return SentryLevel.DEBUG;
            }
            case 4: {
                return SentryLevel.INFO;
            }
            case 5: {
                return SentryLevel.WARNING;
            }
            case 6: {
                return SentryLevel.ERROR;
            }
        }
        return SentryLevel.FATAL;
    }

    private int toLogcatLevel(SentryLevel sentryLevel) {
        switch (sentryLevel) {
            case DEBUG: {
                return 3;
            }
            case INFO: {
                return 4;
            }
            case WARNING: {
                return 5;
            }
            case FATAL: {
                return 7;
            }
        }
        return 6;
    }
}

