/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.android.core.ANRWatchDog;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.exception.ExceptionMechanismException;
import io.sentry.core.protocol.Mechanism;

public final class AnrIntegration
implements Integration {
    private static ANRWatchDog anrWatchDog;

    public void register(IHub hub, SentryOptions options) {
        this.register(hub, (SentryAndroidOptions)options);
    }

    private void register(IHub hub, SentryAndroidOptions options) {
        ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"ANR enabled: %s", (Object[])new Object[]{options.isAnrEnabled()});
        if (options.isAnrEnabled() && anrWatchDog == null) {
            ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.DEBUG, (String)"ANR timeout in milliseconds: %d", (Object[])new Object[]{options.getAnrTimeoutIntervalMills()});
            anrWatchDog = new ANRWatchDog(options.getAnrTimeoutIntervalMills(), options.isAnrReportInDebug(), error -> {
                ILogger.logIfNotNull((ILogger)options.getLogger(), (SentryLevel)SentryLevel.INFO, (String)"ANR triggered with message: %s", (Object[])new Object[]{error.getMessage()});
                Mechanism mechanism = new Mechanism();
                mechanism.setType("ANR");
                mechanism.setHandled(Boolean.valueOf(false));
                ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, (Throwable)error, Thread.currentThread());
                hub.captureException((Throwable)throwable);
            }, options.getLogger());
            anrWatchDog.start();
        }
    }
}

