/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidSerializer;
import io.sentry.android.core.AnrIntegration;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryOptions;
import java.io.File;

final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    static void init(SentryAndroidOptions options, Context context) {
        AndroidOptionsInitializer.init(options, context, new AndroidLogger());
    }

    static void init(SentryAndroidOptions options, Context context, ILogger logger) {
        options.setLogger(logger);
        options.setSentryClientName("sentry.java.android/2.0.0-alpha02");
        ManifestMetadataReader.applyMetadata(context, options);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        AndroidOptionsInitializer.setDefaultInApp(context, options);
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration(new NdkIntegration());
        options.addIntegration(new AnrIntegration());
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, options));
        options.setSerializer(new AndroidSerializer(options.getLogger()));
    }

    private static void setDefaultInApp(Context context, SentryOptions options) {
        String packageName = context.getPackageName();
        if (packageName != null && !packageName.startsWith("android.")) {
            options.addInAppInclude(packageName);
        }
        options.addInAppExclude("android.");
        options.addInAppExclude("com.android.");
        options.addInAppExclude("androidx.");
        options.addInAppExclude("kotlin.");
    }

    private static void initializeCacheDirs(Context context, SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        cacheDir.mkdirs();
        options.setCacheDirPath(cacheDir.getAbsolutePath());
        new File(options.getOutboxPath()).mkdirs();
    }
}

