/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.android.core.EnvelopeFileObserver;
import io.sentry.core.EnvelopeReader;
import io.sentry.core.EnvelopeSender;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.Closeable;
import java.io.File;
import org.jetbrains.annotations.Nullable;

abstract class EnvelopeFileObserverIntegration
implements Integration,
Closeable {
    @Nullable
    private EnvelopeFileObserver observer;

    protected EnvelopeFileObserverIntegration() {
    }

    public void register(IHub hub, SentryOptions options) {
        ILogger logger = options.getLogger();
        String path = this.getPath(options);
        if (path == null) {
            logger.log(SentryLevel.WARNING, "Null given as a path to %s. Nothing will be registered.", new Object[0]);
        } else {
            logger.log(SentryLevel.DEBUG, "Registering CachedEventReaderIntegration for path: %s", new Object[]{path});
            EnvelopeSender envelopeSender = new EnvelopeSender(hub, (IEnvelopeReader)new EnvelopeReader(), options.getSerializer(), logger);
            this.observer = new EnvelopeFileObserver(path, (IEnvelopeSender)envelopeSender, logger);
            this.observer.startWatching();
        }
    }

    @Override
    public void close() {
        if (this.observer != null) {
            this.observer.stopWatching();
        }
    }

    public static EnvelopeFileObserverIntegration getOutboxFileObserver() {
        return new OutboxEnvelopeFileObserverIntegration();
    }

    public static EnvelopeFileObserverIntegration getCachedEnvelopeFileObserver() {
        return new JavaCachedEnvelopeFileObserverIntegration();
    }

    abstract String getPath(SentryOptions var1);

    private static final class JavaCachedEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private JavaCachedEnvelopeFileObserverIntegration() {
        }

        @Override
        protected String getPath(SentryOptions options) {
            return options.getCacheDirPath() + File.separator + "cached";
        }
    }

    private static final class OutboxEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private OutboxEnvelopeFileObserverIntegration() {
        }

        @Override
        protected String getPath(SentryOptions options) {
            return options.getOutboxPath();
        }
    }
}

