/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.selendroid.client.TouchAction;
import io.selendroid.server.common.action.touch.FlickDirection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class TouchActionBuilder {
    private List<Map<String, Object>> actionChain = Lists.newArrayList();
    private boolean isDown = false;

    private void addAction(String actionName, Map<String, Object> params) {
        params.put("name", actionName);
        this.actionChain.add(params);
    }

    public void addAction(String actionName) {
        HashMap params = Maps.newHashMap();
        this.addAction(actionName, params);
    }

    private Map<String, Object> getTouchParameters(WebElement element, int x, int y) {
        HashMap params = Maps.newHashMap();
        if (element != null) {
            params.put("element", ((RemoteWebElement)element).getId());
        }
        params.put("x", x);
        params.put("y", y);
        return params;
    }

    public TouchActionBuilder pointerDown(WebElement element) {
        return this.pointerDown(element, 0, 0);
    }

    public TouchActionBuilder pointerDown(int x, int y) {
        return this.pointerDown(null, x, y);
    }

    public TouchActionBuilder pointerDown(WebElement element, int x, int y) {
        Preconditions.checkState((!this.isDown ? 1 : 0) != 0);
        Map<String, Object> params = this.getTouchParameters(element, x, y);
        this.addAction("pointerDown", params);
        this.isDown = true;
        return this;
    }

    public TouchActionBuilder pointerUp() {
        Preconditions.checkState((boolean)this.isDown);
        this.addAction("pointerUp");
        return this;
    }

    public TouchActionBuilder pointerMove(WebElement element) {
        return this.pointerMove(element, 0, 0);
    }

    public TouchActionBuilder pointerMove(int x, int y) {
        return this.pointerMove(null, x, y);
    }

    public TouchActionBuilder pointerMove(WebElement element, int x, int y) {
        Preconditions.checkState((boolean)this.isDown);
        Map<String, Object> params = this.getTouchParameters(element, x, y);
        this.addAction("pointerMove", params);
        return this;
    }

    public TouchActionBuilder pause() {
        return this.pause(0);
    }

    public TouchActionBuilder pause(int ms) {
        HashMap params = Maps.newHashMap();
        params.put("ms", ms);
        this.addAction("pause", params);
        return this;
    }

    public TouchActionBuilder flick(Point origin, FlickDirection direction, int distance, int duration) {
        Preconditions.checkState((!this.isDown ? 1 : 0) != 0);
        HashMap params = Maps.newHashMap();
        params.put("x", origin.getX());
        params.put("y", origin.getY());
        params.put("direction", direction.getDirection());
        params.put("distance", distance);
        params.put("duration", duration);
        this.addAction("flick", params);
        return this;
    }

    public TouchActionBuilder pointerCancel() {
        this.addAction("pointerCancel");
        return this;
    }

    public TouchAction build() {
        return new TouchAction((List<Map<String, Object>>)ImmutableList.copyOf(this.actionChain));
    }
}

