/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.selendroid.client.MultiTouchAction;
import io.selendroid.client.TouchAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.ExecuteMethod;

public class MultiTouchScreen {
    private ExecuteMethod mExecuteMethod;

    public MultiTouchScreen(ExecuteMethod executeMethod) {
        this.mExecuteMethod = executeMethod;
    }

    private Map<String, Object> createActionChain(TouchAction touchAction) {
        HashMap actionChain = Maps.newHashMap();
        actionChain.put("inputDevice", "touch");
        actionChain.put("id", "");
        actionChain.put("actions", touchAction.getActionChain());
        return actionChain;
    }

    protected void executeAction(TouchAction touchAction) {
        ArrayList payload = Lists.newArrayList();
        payload.add(this.createActionChain(touchAction));
        HashMap params = Maps.newHashMap();
        params.put("payload", payload);
        this.mExecuteMethod.execute("actions", (Map)params);
    }

    protected void executeAction(MultiTouchAction multiAction) {
        ArrayList payload = Lists.newArrayList();
        for (TouchAction touchAction : multiAction.getTouchActions()) {
            payload.add(this.createActionChain(touchAction));
        }
        HashMap params = Maps.newHashMap();
        params.put("payload", payload);
        this.mExecuteMethod.execute("actions", (Map)params);
    }
}

