/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import io.seata.spring.boot.autoconfigure.util.SpringUtils;
import io.seata.spring.boot.autoconfigure.util.StringFormatUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final String INTERCEPT_METHOD_PREFIX = "get";

    public Configuration provide(final Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(originalConfiguration.getClass(), (Callback)new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (method.getName().startsWith(SpringBootConfigurationProvider.INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                    Object result = null;
                    String rawDataId = (String)args[0];
                    if (args.length == 1) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId));
                    } else if (args.length == 2) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1]);
                    } else if (args.length == 3) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1], (Long)args[2]);
                    }
                    if (null != result) {
                        return result;
                    }
                }
                return method.invoke((Object)originalConfiguration, args);
            }
        });
    }

    private Object get(String dataId, Object defaultValue, long timeoutMills) throws IllegalAccessException {
        return this.get(dataId, defaultValue);
    }

    private Object get(String dataId, Object defaultValue) throws IllegalAccessException {
        Object result = this.get(dataId);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    private Object get(String dataId) throws IllegalAccessException {
        Object propertyObject;
        Optional<Field> fieldOptional;
        String propertySuffix = this.getPropertySuffix(dataId);
        Class propertyClass = this.getPropertyClass(this.getPropertyPrefix(dataId));
        if (null != propertyClass && (fieldOptional = Stream.of((propertyObject = SpringUtils.getBean(propertyClass)).getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(propertySuffix)).findAny()).isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            return field.get(propertyObject);
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_VGROUP_MAPPING)) {
            return "seata.service." + StarterConstants.NORMALIZED_KEY_VGROUP_MAPPING;
        }
        if (rawDataId.endsWith(StarterConstants.SPECIAL_KEY_GROUPLIST)) {
            return "seata.service." + StarterConstants.NORMALIZED_KEY_GROUPLIST;
        }
        if (rawDataId.endsWith(StarterConstants.SPECIAL_KEY_DATASOURCE_AUTOPROXY)) {
            return "seata.client.support.spring." + StarterConstants.NORMALIZED_KEY_DATASOURCE_AUTOPROXY;
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_UNDO)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_UNDO);
            return "seata.client.undo." + StringFormatUtils.dotToCamel(suffix);
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_CLIENT_LOCK)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_CLIENT_LOCK);
            return "seata.client.rm.lock." + StringFormatUtils.minusToCamel(StringFormatUtils.dotToCamel(suffix));
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_CLIENT)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_CLIENT);
            return "seata.client." + StringFormatUtils.dotToCamel(suffix);
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_TRANSPORT_THREAD_FACTORY)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_TRANSPORT_THREAD_FACTORY);
            return "seata.transport.thread-factory." + StringFormatUtils.minusToCamel(suffix);
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_REGISTRY_ZK)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_REGISTRY_ZK);
            return "seata.registry.zk." + StringFormatUtils.dotToCamel(suffix);
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_CONFIG_ZK)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_CONFIG_ZK);
            return "seata.config.zk." + StringFormatUtils.dotToCamel(suffix);
        }
        if (rawDataId.startsWith(StarterConstants.SPECIAL_KEY_CONFIG_APOLLO)) {
            String suffix = StringUtils.removeStart((String)rawDataId, (String)StarterConstants.NORMALIZED_KEY_CONFIG_APOLLO);
            return "seata.config.apollo." + StringFormatUtils.dotToCamel(suffix);
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        return StringFormatUtils.underlineToCamel(StringFormatUtils.minusToCamel(StringUtils.substringBeforeLast((String)dataId, (String)".")));
    }

    private String getPropertySuffix(String dataId) {
        return StringUtils.substringAfterLast((String)dataId, (String)".");
    }

    private Class getPropertyClass(String propertyPrefix) {
        Optional<Map.Entry> entry = StarterConstants.PROPERTY_MAP.entrySet().stream().filter(e -> propertyPrefix.equals(e.getKey())).findAny();
        return entry.map(Map.Entry::getValue).orElse(null);
    }
}

