/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.transaction.saga;

import io.netty.channel.Channel;
import io.seata.common.util.CollectionUtils;
import io.seata.core.exception.GlobalTransactionException;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.core.protocol.transaction.BranchCommitRequest;
import io.seata.core.protocol.transaction.BranchCommitResponse;
import io.seata.core.protocol.transaction.BranchRollbackRequest;
import io.seata.core.protocol.transaction.BranchRollbackResponse;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.netty.ChannelManager;
import io.seata.server.coordinator.AbstractCore;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHelper;
import io.seata.server.session.SessionHolder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class SagaCore
extends AbstractCore {
    public SagaCore(RemotingServer remotingServer) {
        super(remotingServer);
    }

    @Override
    public BranchType getHandleBranchType() {
        return BranchType.SAGA;
    }

    @Override
    public void globalSessionStatusCheck(GlobalSession globalSession) throws GlobalTransactionException {
    }

    @Override
    public BranchStatus branchCommitSend(BranchCommitRequest request, GlobalSession globalSession, BranchSession branchSession) throws IOException, TimeoutException {
        Map channels = ChannelManager.getRmChannels();
        if (CollectionUtils.isEmpty((Map)channels)) {
            LOGGER.error("Failed to commit SAGA global[" + globalSession.getXid() + ", RM channels is empty.");
            return BranchStatus.PhaseTwo_CommitFailed_Retryable;
        }
        String sagaResourceId = this.getSagaResourceId(globalSession);
        Channel sagaChannel = (Channel)channels.get(sagaResourceId);
        if (sagaChannel == null) {
            LOGGER.error("Failed to commit SAGA global[" + globalSession.getXid() + ", cannot find channel by resourceId[" + sagaResourceId + "]");
            return BranchStatus.PhaseTwo_CommitFailed_Retryable;
        }
        BranchCommitResponse response = (BranchCommitResponse)this.remotingServer.sendSyncRequest(sagaChannel, (Object)request);
        return response.getBranchStatus();
    }

    @Override
    public BranchStatus branchRollbackSend(BranchRollbackRequest request, GlobalSession globalSession, BranchSession branchSession) throws IOException, TimeoutException {
        Map channels = ChannelManager.getRmChannels();
        if (CollectionUtils.isEmpty((Map)channels)) {
            LOGGER.error("Failed to rollback SAGA global[" + globalSession.getXid() + ", RM channels is empty.");
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
        String sagaResourceId = this.getSagaResourceId(globalSession);
        Channel sagaChannel = (Channel)channels.get(sagaResourceId);
        if (sagaChannel == null) {
            LOGGER.error("Failed to rollback SAGA global[" + globalSession.getXid() + ", cannot find channel by resourceId[" + sagaResourceId + "]");
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
        BranchRollbackResponse response = (BranchRollbackResponse)this.remotingServer.sendSyncRequest(sagaChannel, (Object)request);
        return response.getBranchStatus();
    }

    @Override
    public boolean doGlobalCommit(GlobalSession globalSession, boolean retrying) throws TransactionException {
        try {
            BranchStatus branchStatus = this.branchCommit(globalSession, SessionHelper.newBranch(BranchType.SAGA, globalSession.getXid(), -1L, this.getSagaResourceId(globalSession), globalSession.getStatus().name()));
            switch (branchStatus) {
                case PhaseTwo_Committed: {
                    SessionHelper.removeAllBranch(globalSession, !retrying);
                    LOGGER.info("Successfully committed SAGA global[" + globalSession.getXid() + "]");
                    break;
                }
                case PhaseTwo_Rollbacked: {
                    LOGGER.info("Successfully rollbacked SAGA global[" + globalSession.getXid() + "]");
                    SessionHelper.removeAllBranch(globalSession, !retrying);
                    SessionHelper.endRollbacked(globalSession, retrying);
                    return false;
                }
                case PhaseTwo_RollbackFailed_Retryable: {
                    LOGGER.error("By [{}], failed to rollback SAGA global [{}], will retry later.", (Object)branchStatus, (Object)globalSession.getXid());
                    SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
                    globalSession.queueToRetryRollback();
                    return false;
                }
                case PhaseOne_Failed: {
                    LOGGER.error("By [{}], finish SAGA global [{}]", (Object)branchStatus, (Object)globalSession.getXid());
                    SessionHelper.removeAllBranch(globalSession, !retrying);
                    globalSession.changeGlobalStatus(GlobalStatus.Finished);
                    globalSession.end();
                    return false;
                }
                case PhaseTwo_CommitFailed_Unretryable: {
                    if (globalSession.canBeCommittedAsync()) {
                        LOGGER.error("By [{}], failed to commit SAGA global [{}]", (Object)branchStatus, (Object)globalSession.getXid());
                        break;
                    }
                    SessionHelper.endCommitFailed(globalSession, retrying);
                    LOGGER.error("Finally, failed to commit SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                default: {
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                    } else {
                        LOGGER.error("Failed to commit SAGA global[{}], will retry later.", (Object)globalSession.getXid());
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to commit global[" + globalSession.getXid() + "]", (Throwable)ex);
            if (!retrying) {
                globalSession.queueToRetryRollback();
            }
            throw new TransactionException((Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean doGlobalRollback(GlobalSession globalSession, boolean retrying) throws TransactionException {
        try {
            BranchStatus branchStatus = this.branchRollback(globalSession, SessionHelper.newBranch(BranchType.SAGA, globalSession.getXid(), -1L, this.getSagaResourceId(globalSession), globalSession.getStatus().name()));
            switch (branchStatus) {
                case PhaseTwo_Rollbacked: {
                    SessionHelper.removeAllBranch(globalSession, !retrying);
                    LOGGER.info("Successfully rollbacked SAGA global[{}]", (Object)globalSession.getXid());
                    break;
                }
                case PhaseTwo_RollbackFailed_Unretryable: {
                    SessionHelper.endRollbackFailed(globalSession, retrying);
                    LOGGER.error("Failed to rollback SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                case PhaseTwo_CommitFailed_Retryable: {
                    SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
                    globalSession.queueToRetryCommit();
                    LOGGER.warn("Retry by custom recover strategy [Forward] on timeout, SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                default: {
                    LOGGER.error("Failed to rollback SAGA global[{}]", (Object)globalSession.getXid());
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to rollback global[{}]", (Object)globalSession.getXid(), (Object)ex);
            if (!retrying) {
                globalSession.queueToRetryRollback();
            }
            throw new TransactionException((Throwable)ex);
        }
        return true;
    }

    @Override
    public void doGlobalReport(GlobalSession globalSession, String xid, GlobalStatus globalStatus) throws TransactionException {
        if (GlobalStatus.Committed.equals((Object)globalStatus)) {
            SessionHelper.removeAllBranch(globalSession, false);
            SessionHelper.endCommitted(globalSession, false);
            LOGGER.info("Global[{}] committed", (Object)globalSession.getXid());
        } else if (GlobalStatus.Rollbacked.equals((Object)globalStatus) || GlobalStatus.Finished.equals((Object)globalStatus)) {
            SessionHelper.removeAllBranch(globalSession, false);
            SessionHelper.endRollbacked(globalSession, false);
            LOGGER.info("Global[{}] rollbacked", (Object)globalSession.getXid());
        } else {
            globalSession.changeGlobalStatus(globalStatus);
            LOGGER.info("Global[{}] reporting is successfully done. status[{}]", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            if (GlobalStatus.RollbackRetrying.equals((Object)globalStatus) || GlobalStatus.TimeoutRollbackRetrying.equals((Object)globalStatus) || GlobalStatus.UnKnown.equals((Object)globalStatus)) {
                globalSession.queueToRetryRollback();
                LOGGER.info("Global[{}] will retry rollback", (Object)globalSession.getXid());
            } else if (GlobalStatus.CommitRetrying.equals((Object)globalStatus)) {
                globalSession.queueToRetryCommit();
                LOGGER.info("Global[{}] will retry commit", (Object)globalSession.getXid());
            }
        }
    }

    private String getSagaResourceId(GlobalSession globalSession) {
        return globalSession.getApplicationId() + "#" + globalSession.getTransactionServiceGroup();
    }
}

