/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.store;

import com.google.common.collect.ImmutableMap;
import io.seata.common.exception.RedisException;
import io.seata.common.exception.StoreException;
import io.seata.common.util.BeanUtils;
import io.seata.common.util.CollectionUtils;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.server.storage.redis.JedisPooledFactory;
import io.seata.server.storage.redis.LuaParser;
import io.seata.server.storage.redis.store.RedisTransactionStoreManager;
import io.seata.server.store.TransactionStoreManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisLuaTransactionStoreManager
extends RedisTransactionStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLuaTransactionStoreManager.class);
    private static final String LUA_PREFIX = "lua/redisStore/";
    private static final String INSERT_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/insertTransactionDO.lua";
    private static final String DELETE_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/deleteTransactionDO.lua";
    private static final String UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/updateBranchTransactionDO.lua";
    private static final String UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/updateGlobalTransactionDO.lua";
    private static final String ROLLBACK_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/rollbackGlobalTransactionDO.lua";
    private static final Map<String, String> LOCK_SHA_MAP = new HashMap<String, String>();

    private void initRedisMode() {
        this.loadLuaFile(INSERT_TRANSACTION_DO_LUA_FILE_NAME, "insertTransactionDO");
        this.loadLuaFile(DELETE_TRANSACTION_DO_LUA_FILE_NAME, "deleteTransactionDO");
        this.loadLuaFile(UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME, "updateBranchTransactionDO");
        this.loadLuaFile(UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, "updateGlobalTransactionDO");
        this.loadLuaFile(ROLLBACK_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, "rollbackGlobalTransactionDO");
    }

    private void loadLuaFile(String fileName, String mode) {
        block3: {
            try {
                LOCK_SHA_MAP.putAll(LuaParser.getEvalShaMapFromFile(fileName));
            }
            catch (IOException e) {
                if (LOCK_SHA_MAP.get(fileName) != null) {
                    LOCK_SHA_MAP.remove(fileName);
                }
                if (!LOGGER.isInfoEnabled()) break block3;
                LOGGER.info("redis session: {} use pipeline mode", (Object)mode);
            }
        }
    }

    public RedisLuaTransactionStoreManager() {
        LOGGER.info("init redisLuaTransactionStoreManager");
        this.initRedisMode();
    }

    @Override
    public void initGlobalMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            globalMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.GLOBAL_ADD, this::insertGlobalTransactionDO).put((Object)TransactionStoreManager.LogOperation.GLOBAL_UPDATE, this::updateGlobalTransactionDO).put((Object)TransactionStoreManager.LogOperation.GLOBAL_REMOVE, this::deleteGlobalTransactionDO).build();
        }
    }

    @Override
    public void initBranchMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            branchMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.BRANCH_ADD, this::insertBranchTransactionDO).put((Object)TransactionStoreManager.LogOperation.BRANCH_UPDATE, this::updateBranchTransactionDO).put((Object)TransactionStoreManager.LogOperation.BRANCH_REMOVE, this::deleteBranchTransactionDO).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        final String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        final String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
        Date now = new Date();
        branchTransactionDO.setGmtCreate(now);
        branchTransactionDO.setGmtModified(now);
        final Map branchTransactionDOMap = BeanUtils.objectToMap((Object)branchTransactionDO);
        String luaSHA = LOCK_SHA_MAP.get(INSERT_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.insertBranchTransactionDO(branchTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(branchKey);
                    this.add(branchListKey);
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add("branch");
                    this.add(String.valueOf(branchTransactionDOMap.size()));
                }
            };
            for (Map.Entry entry : branchTransactionDOMap.entrySet()) {
                keys.add((String)entry.getKey());
                args.add((String)entry.getValue());
            }
            LuaParser.jedisEvalSha(jedis, luaSHA, INSERT_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        final String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        final String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
        String luaSHA = LOCK_SHA_MAP.get(DELETE_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.deleteBranchTransactionDO(branchTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(branchKey);
                    this.add(branchListKey);
                    this.add("xid");
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add("branch");
                }
            };
            LuaParser.jedisEvalSha(jedis, luaSHA, DELETE_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        final String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        final String branchStatus = String.valueOf(branchTransactionDO.getStatus());
        final String applicationData = String.valueOf(branchTransactionDO.getApplicationData());
        String luaSHA = LOCK_SHA_MAP.get(UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.updateBranchTransactionDO(branchTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(branchKey);
                    this.add("status");
                    this.add("gmtModified");
                    this.add("applicationData");
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add(branchStatus);
                    this.add(String.valueOf(new Date().getTime()));
                    this.add(applicationData);
                }
            };
            String result = (String)LuaParser.jedisEvalSha(jedis, luaSHA, UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            LuaParser.LuaResult luaResult = LuaParser.getObjectFromJson(result, LuaParser.LuaResult.class);
            if (!luaResult.getSuccess().booleanValue()) {
                throw new StoreException("Branch transaction is not exist, update branch transaction failed.");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        final String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        final String globalStatus = this.buildGlobalStatus(globalTransactionDO.getStatus());
        String xid = globalTransactionDO.getXid();
        Date now = new Date();
        globalTransactionDO.setGmtCreate(now);
        globalTransactionDO.setGmtModified(now);
        final Map globalTransactionDOMap = BeanUtils.objectToMap((Object)globalTransactionDO);
        String luaSHA = LOCK_SHA_MAP.get(INSERT_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.insertGlobalTransactionDO(globalTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(globalKey);
                    this.add(globalStatus);
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add("global");
                    this.add(String.valueOf(globalTransactionDOMap.size()));
                }
            };
            for (Map.Entry entry : globalTransactionDOMap.entrySet()) {
                keys.add((String)entry.getKey());
                args.add((String)entry.getValue());
            }
            keys.add("SEATA_BEGIN_TRANSACTIONS");
            args.add(xid);
            args.add(String.valueOf(globalTransactionDO.getBeginTime() + (long)globalTransactionDO.getTimeout().intValue()));
            LuaParser.jedisEvalSha(jedis, luaSHA, INSERT_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean deleteGlobalTransactionDO(final GlobalTransactionDO globalTransactionDO) {
        final String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        final String globalStatus = this.buildGlobalStatus(globalTransactionDO.getStatus());
        String luaSHA = LOCK_SHA_MAP.get(DELETE_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.deleteGlobalTransactionDO(globalTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(globalKey);
                    this.add(globalStatus);
                    this.add("xid");
                    this.add("SEATA_BEGIN_TRANSACTIONS");
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add("global");
                    this.add(globalTransactionDO.getXid());
                    this.add(String.valueOf(globalTransactionDO.getStatus()));
                }
            };
            LuaParser.jedisEvalSha(jedis, luaSHA, DELETE_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        final String xid = globalTransactionDO.getXid();
        final String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        final Integer status = globalTransactionDO.getStatus();
        String luaSHA = LOCK_SHA_MAP.get(UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.updateGlobalTransactionDO(globalTransactionDO);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            ArrayList<String> keys = new ArrayList<String>(){
                {
                    this.add(globalKey);
                    this.add("status");
                    this.add("gmtModified");
                    this.add("SEATA_BEGIN_TRANSACTIONS");
                }
            };
            ArrayList<String> args = new ArrayList<String>(){
                {
                    this.add(String.valueOf(status));
                    this.add(String.valueOf(new Date().getTime()));
                    this.add(xid);
                }
            };
            String result = (String)LuaParser.jedisEvalSha(jedis, luaSHA, UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, (List<String>)keys, (List<String>)args);
            LuaParser.LuaResult luaResult = LuaParser.getObjectFromJson(result, LuaParser.LuaResult.class);
            if (!luaResult.getSuccess().booleanValue()) {
                String type = luaResult.getStatus();
                if ("NotExisted".equals(type)) {
                    throw new StoreException("Global transaction is not exist, update global transaction failed.");
                }
                if ("ChangeStatusFail".equals(type)) {
                    String previousStatus = luaResult.getData();
                    GlobalStatus before = GlobalStatus.get((int)Integer.parseInt(previousStatus));
                    GlobalStatus after = GlobalStatus.get((int)status);
                    throw new StoreException("Illegal changing of global status, update global transaction failed. beforeStatus[" + before.name() + "] cannot be changed to afterStatus[" + after.name() + "]");
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }
}

