/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.session;

import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.GlobalStatus;
import io.seata.server.session.AbstractSessionManager;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.redis.store.RedisTransactionStoreManagerFactory;
import io.seata.server.store.TransactionStoreManager;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="redis", scope=Scope.PROTOTYPE)
public class RedisSessionManager
extends AbstractSessionManager
implements Initialize {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RedisSessionManager.class);

    public void init() {
        this.transactionStoreManager = RedisTransactionStoreManagerFactory.getInstance();
    }

    @Override
    public void addGlobalSession(GlobalSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_ADD, session);
        if (!ret) {
            throw new StoreException("addGlobalSession failed.");
        }
    }

    @Override
    public void updateGlobalSessionStatus(GlobalSession session, GlobalStatus status) throws TransactionException {
        session.setStatus(status);
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_UPDATE, session);
        if (!ret) {
            throw new StoreException("updateGlobalSessionStatus failed.");
        }
    }

    @Override
    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_REMOVE, session);
        if (!ret) {
            throw new StoreException("removeGlobalSession failed.");
        }
    }

    @Override
    public void addBranchSession(GlobalSession globalSession, BranchSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_ADD, session);
        if (!ret) {
            throw new StoreException("addBranchSession failed.");
        }
    }

    @Override
    public void updateBranchSessionStatus(BranchSession session, BranchStatus status) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_UPDATE, session);
        if (!ret) {
            throw new StoreException("updateBranchSessionStatus failed.");
        }
    }

    @Override
    public void removeBranchSession(GlobalSession globalSession, BranchSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_REMOVE, session);
        if (!ret) {
            throw new StoreException("removeBranchSession failed.");
        }
    }

    @Override
    public GlobalSession findGlobalSession(String xid) {
        return this.findGlobalSession(xid, true);
    }

    @Override
    public GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return this.transactionStoreManager.readSession(xid, withBranchSessions);
    }

    @Override
    public Collection<GlobalSession> allSessions() {
        return this.findGlobalSessions(new SessionCondition(GlobalStatus.UnKnown, GlobalStatus.Begin, GlobalStatus.Committing, GlobalStatus.CommitRetrying, GlobalStatus.Rollbacking, GlobalStatus.RollbackRetrying, GlobalStatus.TimeoutRollbacking, GlobalStatus.TimeoutRollbackRetrying, GlobalStatus.AsyncCommitting));
    }

    @Override
    public List<GlobalSession> findGlobalSessions(SessionCondition condition) {
        return this.transactionStoreManager.readSession(condition);
    }

    @Override
    public <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return lockCallable.call();
    }
}

